/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smackx.carbons.CarbonCopyReceivedListener;
import org.jivesoftware.smackx.carbons.CarbonManager;
import org.jivesoftware.smackx.carbons.packet.CarbonExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.jivesoftware.smackx.mam.MamManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.omemo.OmemoConfiguration;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.element.OmemoBundleVAxolotlElement;
import org.jivesoftware.smackx.omemo.element.OmemoDeviceListElement;
import org.jivesoftware.smackx.omemo.element.OmemoDeviceListVAxolotlElement;
import org.jivesoftware.smackx.omemo.element.OmemoElement;
import org.jivesoftware.smackx.omemo.element.OmemoVAxolotlElement;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.NoRawSessionException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.internal.CachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.CipherAndAuthTag;
import org.jivesoftware.smackx.omemo.internal.ClearTextMessage;
import org.jivesoftware.smackx.omemo.internal.IdentityKeyWrapper;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.internal.OmemoMessageInformation;
import org.jivesoftware.smackx.omemo.internal.OmemoSession;
import org.jivesoftware.smackx.omemo.util.OmemoConstants;
import org.jivesoftware.smackx.omemo.util.OmemoMessageBuilder;
import org.jivesoftware.smackx.pep.PEPManager;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;

public abstract class OmemoService<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    protected static final Logger LOGGER;
    private static OmemoService<?, ?, ?, ?, ?, ?, ?, ?, ?> INSTANCE;
    protected OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> omemoStore;
    private final StanzaFilter omemoStanzaFilter = new StanzaFilter(){

        public boolean accept(Stanza stanza) {
            return stanza instanceof Message && OmemoManager.stanzaContainsOmemoElement(stanza);
        }
    };

    public static OmemoService<?, ?, ?, ?, ?, ?, ?, ?, ?> getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("No OmemoService registered");
        }
        return INSTANCE;
    }

    protected static void setInstance(OmemoService<?, ?, ?, ?, ?, ?, ?, ?, ?> omemoService) {
        if (INSTANCE != null) {
            throw new IllegalStateException("An OmemoService is already registered");
        }
        INSTANCE = omemoService;
    }

    public static boolean isServiceRegistered() {
        return INSTANCE != null;
    }

    public OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> getOmemoStoreBackend() {
        if (this.omemoStore == null) {
            this.setOmemoStoreBackend(this.createDefaultOmemoStoreBackend());
            return this.getOmemoStoreBackend();
        }
        return this.omemoStore;
    }

    public void setOmemoStoreBackend(OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> omemoStore) {
        if (this.omemoStore != null) {
            throw new IllegalStateException("An OmemoStore backend has already been set.");
        }
        this.omemoStore = omemoStore;
    }

    public abstract OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> createDefaultOmemoStoreBackend();

    public OmemoService() throws NoSuchPaddingException, InvalidKeyException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        OmemoService.checkAvailableAlgorithms();
    }

    void initialize(OmemoManager omemoManager) throws InterruptedException, CorruptedOmemoKeyException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, SmackException.NotLoggedInException, PubSubException.NotALeafNodeException {
        if (!omemoManager.getConnection().isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        boolean mustPublishId = false;
        if (this.getOmemoStoreBackend().isFreshInstallation(omemoManager)) {
            LOGGER.log(Level.INFO, "No key material found. Looks like we have a fresh installation.");
            this.regenerate(omemoManager, omemoManager.getDeviceId());
            mustPublishId = true;
        }
        this.publishDeviceIdIfNeeded(omemoManager, false, mustPublishId |= this.refreshOwnDeviceList(omemoManager));
        this.publishBundle(omemoManager);
        OmemoService.subscribeToDeviceLists(omemoManager);
        this.registerOmemoMessageStanzaListeners(omemoManager);
        this.getOmemoStoreBackend().initializeOmemoSessions(omemoManager);
    }

    protected static void checkAvailableAlgorithms() throws NoSuchPaddingException, UnsupportedEncodingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidKeyException {
        new OmemoMessageBuilder(null, null, "");
    }

    void regenerate(OmemoManager omemoManager, Integer nDeviceId) throws CorruptedOmemoKeyException {
        while (nDeviceId == null || !this.getOmemoStoreBackend().isAvailableDeviceId(omemoManager, nDeviceId)) {
            nDeviceId = OmemoManager.randomDeviceId();
        }
        this.getOmemoStoreBackend().forgetOmemoSessions(omemoManager);
        this.getOmemoStoreBackend().purgeOwnDeviceKeys(omemoManager);
        omemoManager.setDeviceId(nDeviceId);
        this.getOmemoStoreBackend().regenerate(omemoManager);
    }

    void publishBundle(OmemoManager omemoManager) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, CorruptedOmemoKeyException, XMPPException.XMPPErrorException {
        Date lastSignedPreKeyRenewal = this.getOmemoStoreBackend().getDateOfLastSignedPreKeyRenewal(omemoManager);
        if (OmemoConfiguration.getRenewOldSignedPreKeys() && lastSignedPreKeyRenewal != null) {
            if (System.currentTimeMillis() - lastSignedPreKeyRenewal.getTime() > 3600000L * (long)OmemoConfiguration.getRenewOldSignedPreKeysAfterHours()) {
                LOGGER.log(Level.INFO, "Renewing signedPreKey");
                this.getOmemoStoreBackend().changeSignedPreKey(omemoManager);
            }
        } else {
            this.getOmemoStoreBackend().setDateOfLastSignedPreKeyRenewal(omemoManager);
        }
        PubSubManager.getInstance((XMPPConnection)omemoManager.getConnection(), (BareJid)omemoManager.getOwnJid()).tryToPublishAndPossibleAutoCreate(OmemoConstants.PEP_NODE_BUNDLE_FROM_DEVICE_ID(omemoManager.getDeviceId()), (Item)new PayloadItem((ExtensionElement)this.getOmemoStoreBackend().packOmemoBundle(omemoManager)));
    }

    void publishDeviceIdIfNeeded(OmemoManager omemoManager, boolean deleteOtherDevices) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        this.publishDeviceIdIfNeeded(omemoManager, deleteOtherDevices, false);
    }

    void publishDeviceIdIfNeeded(OmemoManager omemoManager, boolean deleteOtherDevices, boolean publish) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        int ourDeviceId;
        CachedDeviceList deviceList = this.getOmemoStoreBackend().loadCachedDeviceList(omemoManager, omemoManager.getOwnJid());
        HashSet<Object> deviceListIds = deviceList == null ? new HashSet() : new HashSet<Integer>(deviceList.getActiveDevices());
        if (deleteOtherDevices) {
            deviceListIds.clear();
        }
        if (deviceListIds.add(ourDeviceId = omemoManager.getDeviceId())) {
            publish = true;
        }
        if (publish |= this.removeStaleDevicesIfNeeded(omemoManager, deviceListIds)) {
            OmemoService.publishDeviceIds(omemoManager, new OmemoDeviceListVAxolotlElement(deviceListIds));
        }
    }

    boolean removeStaleDevicesIfNeeded(OmemoManager omemoManager, Set<Integer> deviceListIds) {
        boolean publish = false;
        int ownDeviceId = omemoManager.getDeviceId();
        Iterator<Integer> it = deviceListIds.iterator();
        while (OmemoConfiguration.getDeleteStaleDevices() && it.hasNext()) {
            int id = it.next();
            if (id == ownDeviceId) continue;
            OmemoDevice d = new OmemoDevice(omemoManager.getOwnJid(), id);
            Date date = this.getOmemoStoreBackend().getDateOfLastReceivedMessage(omemoManager, d);
            if (date == null) {
                this.getOmemoStoreBackend().setDateOfLastReceivedMessage(omemoManager, d);
                continue;
            }
            if (System.currentTimeMillis() - date.getTime() <= 3600000L * (long)OmemoConfiguration.getDeleteStaleDevicesAfterHours()) continue;
            LOGGER.log(Level.INFO, "Remove device " + id + " because of more than " + OmemoConfiguration.getDeleteStaleDevicesAfterHours() + " hours of inactivity.");
            it.remove();
            publish = true;
        }
        return publish;
    }

    static void publishDeviceIds(OmemoManager omemoManager, OmemoDeviceListElement deviceList) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, PubSubException.NotALeafNodeException {
        PubSubManager.getInstance((XMPPConnection)omemoManager.getConnection(), (BareJid)omemoManager.getOwnJid()).tryToPublishAndPossibleAutoCreate("eu.siacs.conversations.axolotl.devicelist", (Item)new PayloadItem((ExtensionElement)deviceList));
    }

    static LeafNode fetchDeviceListNode(OmemoManager omemoManager, BareJid contact) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, PubSubException.NotAPubSubNodeException {
        return PubSubManager.getInstance((XMPPConnection)omemoManager.getConnection(), (BareJid)contact).getLeafNode("eu.siacs.conversations.axolotl.devicelist");
    }

    static OmemoDeviceListElement fetchDeviceList(OmemoManager omemoManager, BareJid contact) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, PubSubException.NotALeafNodeException, PubSubException.NotAPubSubNodeException {
        return OmemoService.extractDeviceListFrom(OmemoService.fetchDeviceListNode(omemoManager, contact));
    }

    private boolean refreshOwnDeviceList(OmemoManager omemoManager) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException {
        try {
            this.getOmemoStoreBackend().mergeCachedDeviceList(omemoManager, omemoManager.getOwnJid(), OmemoService.fetchDeviceList(omemoManager, omemoManager.getOwnJid()));
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getXMPPError().getCondition() == XMPPError.Condition.item_not_found) {
                LOGGER.log(Level.WARNING, "Could not refresh own deviceList, because the node did not exist: " + e.getMessage());
                return true;
            }
            throw e;
        }
        catch (PubSubException.NotALeafNodeException e) {
            LOGGER.log(Level.WARNING, "Could not refresh own deviceList, because the Node is not a LeafNode: " + e.getMessage());
        }
        catch (PubSubException.NotAPubSubNodeException e) {
            LOGGER.log(Level.WARNING, "Caught a PubSubAssertionError when fetching a deviceList node. This probably means that we're dealing with an ejabberd server and the LeafNode does not exist.", e);
            return true;
        }
        return false;
    }

    void refreshDeviceList(OmemoManager omemoManager, BareJid contact) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        OmemoDeviceListElement omemoDeviceListElement;
        try {
            omemoDeviceListElement = OmemoService.fetchDeviceList(omemoManager, contact);
        }
        catch (XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException e) {
            LOGGER.log(Level.WARNING, "Could not fetch device list of " + contact + ": " + e, e);
            return;
        }
        catch (PubSubException.NotAPubSubNodeException e) {
            LOGGER.log(Level.WARNING, "Could not fetch device list of " + contact, e);
            return;
        }
        this.getOmemoStoreBackend().mergeCachedDeviceList(omemoManager, contact, omemoDeviceListElement);
    }

    static OmemoBundleVAxolotlElement fetchBundle(OmemoManager omemoManager, OmemoDevice contact) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, PubSubException.NotALeafNodeException, PubSubException.NotAPubSubNodeException {
        LeafNode node = PubSubManager.getInstance((XMPPConnection)omemoManager.getConnection(), (BareJid)contact.getJid()).getLeafNode(OmemoConstants.PEP_NODE_BUNDLE_FROM_DEVICE_ID(contact.getDeviceId()));
        return OmemoService.extractBundleFrom(node);
    }

    private static OmemoBundleVAxolotlElement extractBundleFrom(LeafNode node) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        if (node == null) {
            return null;
        }
        try {
            return (OmemoBundleVAxolotlElement)((PayloadItem)node.getItems().get(0)).getPayload();
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private static OmemoDeviceListElement extractDeviceListFrom(LeafNode node) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        if (node == null) {
            LOGGER.log(Level.WARNING, "DeviceListNode is null.");
            return null;
        }
        List items = node.getItems();
        if (items.size() > 0) {
            OmemoDeviceListVAxolotlElement listElement = (OmemoDeviceListVAxolotlElement)((PayloadItem)items.get(items.size() - 1)).getPayload();
            if (items.size() > 1) {
                node.deleteAllItems();
                node.publish((Item)new PayloadItem((ExtensionElement)listElement));
            }
            return listElement;
        }
        Set<Integer> emptySet = Collections.emptySet();
        return new OmemoDeviceListVAxolotlElement(emptySet);
    }

    private static void subscribeToDeviceLists(OmemoManager omemoManager) {
        OmemoService.registerDeviceListListener(omemoManager);
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)omemoManager.getConnection()).addFeature("eu.siacs.conversations.axolotl.devicelist+notify");
    }

    void buildOrCreateOmemoSessionsFromBundles(OmemoManager omemoManager, BareJid jid) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, CannotEstablishOmemoSessionException {
        CachedDeviceList devices = this.getOmemoStoreBackend().loadCachedDeviceList(omemoManager, jid);
        CannotEstablishOmemoSessionException sessionException = null;
        if (devices == null || devices.getAllDevices().isEmpty()) {
            this.refreshDeviceList(omemoManager, jid);
            devices = this.getOmemoStoreBackend().loadCachedDeviceList(omemoManager, jid);
        }
        for (int id : devices.getActiveDevices()) {
            OmemoDevice device = new OmemoDevice(jid, id);
            if (this.getOmemoStoreBackend().containsRawSession(omemoManager, device)) continue;
            try {
                this.buildSessionFromOmemoBundle(omemoManager, device, false);
            }
            catch (CannotEstablishOmemoSessionException e) {
                if (sessionException == null) {
                    sessionException = e;
                    continue;
                }
                sessionException.addFailures(e);
            }
            catch (CorruptedOmemoKeyException e) {
                CannotEstablishOmemoSessionException fail = new CannotEstablishOmemoSessionException(device, (Throwable)e);
                if (sessionException == null) {
                    sessionException = fail;
                    continue;
                }
                sessionException.addFailures(fail);
            }
        }
        if (sessionException != null) {
            throw sessionException;
        }
    }

    public void buildSessionFromOmemoBundle(OmemoManager omemoManager, OmemoDevice device, boolean fresh) throws CannotEstablishOmemoSessionException, CorruptedOmemoKeyException {
        OmemoBundleVAxolotlElement bundle;
        if (device.equals(omemoManager.getOwnDevice())) {
            return;
        }
        if (!fresh && this.getOmemoStoreBackend().containsRawSession(omemoManager, device)) {
            this.getOmemoStoreBackend().getOmemoSessionOf(omemoManager, device);
            return;
        }
        try {
            bundle = OmemoService.fetchBundle(omemoManager, device);
        }
        catch (InterruptedException | SmackException | XMPPException.XMPPErrorException e) {
            throw new CannotEstablishOmemoSessionException(device, e);
        }
        HashMap bundles = this.getOmemoStoreBackend().keyUtil().BUNDLE.bundles(bundle, device);
        int randomIndex = new Random().nextInt(bundles.size());
        Object randomPreKeyBundle = new ArrayList(bundles.values()).get(randomIndex);
        this.processBundle(omemoManager, randomPreKeyBundle, device);
    }

    protected abstract void processBundle(OmemoManager var1, T_Bundle var2, OmemoDevice var3) throws CorruptedOmemoKeyException;

    private static void registerDeviceListListener(OmemoManager omemoManager) {
        PEPManager.getInstanceFor((XMPPConnection)omemoManager.getConnection()).removePEPListener(omemoManager.deviceListUpdateListener);
        PEPManager.getInstanceFor((XMPPConnection)omemoManager.getConnection()).addPEPListener(omemoManager.deviceListUpdateListener);
    }

    private Message processReceivingMessage(OmemoManager omemoManager, OmemoDevice sender, OmemoElement message, OmemoMessageInformation information) throws NoRawSessionException, InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, CryptoFailedException, XMPPException.XMPPErrorException, CorruptedOmemoKeyException {
        ArrayList<OmemoElement.OmemoHeader.Key> messageRecipientKeys = message.getHeader().getKeys();
        for (OmemoElement.OmemoHeader.Key k : messageRecipientKeys) {
            if (k.getId() != omemoManager.getDeviceId()) continue;
            Message decrypted = this.decryptOmemoMessageElement(omemoManager, sender, message, information);
            if (sender.equals(omemoManager.getOwnJid()) && decrypted != null) {
                this.getOmemoStoreBackend().setDateOfLastReceivedMessage(omemoManager, sender);
            }
            return decrypted;
        }
        LOGGER.log(Level.INFO, "There is no key with our deviceId. Silently discard the message.");
        return null;
    }

    ClearTextMessage processLocalMessage(OmemoManager omemoManager, BareJid sender, Message message) throws InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, CryptoFailedException, XMPPException.XMPPErrorException, CorruptedOmemoKeyException, NoRawSessionException {
        if (OmemoManager.stanzaContainsOmemoElement((Stanza)message)) {
            OmemoElement omemoMessageElement = (OmemoElement)message.getExtension("encrypted", "eu.siacs.conversations.axolotl");
            OmemoMessageInformation info = new OmemoMessageInformation();
            Message decrypted = this.processReceivingMessage(omemoManager, new OmemoDevice(sender, omemoMessageElement.getHeader().getSid()), omemoMessageElement, info);
            return new ClearTextMessage(decrypted != null ? decrypted.getBody() : null, message, info);
        }
        LOGGER.log(Level.WARNING, "Stanza does not contain an OMEMO message.");
        return null;
    }

    OmemoVAxolotlElement processSendingMessage(OmemoManager omemoManager, BareJid recipient, Message message) throws CryptoFailedException, UndecidedOmemoIdentityException, NoSuchAlgorithmException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, CannotEstablishOmemoSessionException {
        ArrayList<BareJid> recipients = new ArrayList<BareJid>();
        recipients.add(recipient);
        return this.processSendingMessage(omemoManager, recipients, message);
    }

    OmemoVAxolotlElement processSendingMessage(OmemoManager omemoManager, ArrayList<BareJid> recipients, Message message) throws CryptoFailedException, UndecidedOmemoIdentityException, NoSuchAlgorithmException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, CannotEstablishOmemoSessionException {
        CannotEstablishOmemoSessionException sessionException = null;
        HashMap<BareJid, ArrayList<OmemoDevice>> receivers = new HashMap<BareJid, ArrayList<OmemoDevice>>();
        for (BareJid recipient : recipients) {
            try {
                this.buildOrCreateOmemoSessionsFromBundles(omemoManager, recipient);
            }
            catch (CannotEstablishOmemoSessionException e) {
                if (sessionException == null) {
                    sessionException = e;
                    continue;
                }
                sessionException.addFailures(e);
            }
        }
        for (BareJid recipient : recipients) {
            CachedDeviceList theirDevices = this.getOmemoStoreBackend().loadCachedDeviceList(omemoManager, recipient);
            ArrayList<OmemoDevice> receivingDevices = new ArrayList<OmemoDevice>();
            for (int id : theirDevices.getActiveDevices()) {
                OmemoDevice recipientDevice = new OmemoDevice(recipient, id);
                if (this.getOmemoStoreBackend().containsRawSession(omemoManager, recipientDevice)) {
                    receivingDevices.add(recipientDevice);
                }
                if (sessionException == null) continue;
                sessionException.addSuccess(recipientDevice);
            }
            if (receivingDevices.isEmpty()) continue;
            receivers.put(recipient, receivingDevices);
        }
        CachedDeviceList ourDevices = this.getOmemoStoreBackend().loadCachedDeviceList(omemoManager, omemoManager.getOwnJid());
        if (ourDevices == null) {
            ourDevices = new CachedDeviceList();
        }
        ArrayList<OmemoDevice> ourReceivingDevices = new ArrayList<OmemoDevice>();
        for (int id : ourDevices.getActiveDevices()) {
            OmemoDevice ourDevice = new OmemoDevice(omemoManager.getOwnJid(), id);
            if (id == omemoManager.getDeviceId()) continue;
            Date lastReceived = this.getOmemoStoreBackend().getDateOfLastReceivedMessage(omemoManager, ourDevice);
            if (lastReceived == null) {
                this.getOmemoStoreBackend().setDateOfLastReceivedMessage(omemoManager, ourDevice);
                lastReceived = new Date();
            }
            if (OmemoConfiguration.getIgnoreStaleDevices() && System.currentTimeMillis() - lastReceived.getTime() > 3600000L * (long)OmemoConfiguration.getIgnoreStaleDevicesAfterHours()) {
                LOGGER.log(Level.WARNING, "Refusing to encrypt message for stale device " + ourDevice + " which was inactive for at least " + OmemoConfiguration.getIgnoreStaleDevicesAfterHours() + " hours.");
                continue;
            }
            if (!this.getOmemoStoreBackend().containsRawSession(omemoManager, ourDevice)) continue;
            ourReceivingDevices.add(ourDevice);
        }
        if (!ourReceivingDevices.isEmpty()) {
            receivers.put(omemoManager.getOwnJid(), ourReceivingDevices);
        }
        if (sessionException != null && sessionException.requiresThrowing()) {
            throw sessionException;
        }
        return this.encryptOmemoMessage(omemoManager, receivers, message);
    }

    private Message decryptOmemoMessageElement(OmemoManager omemoManager, OmemoDevice from, OmemoElement message, OmemoMessageInformation information) throws CryptoFailedException, InterruptedException, CorruptedOmemoKeyException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, NoRawSessionException {
        CipherAndAuthTag transportedKey = this.decryptTransportedOmemoKey(omemoManager, from, message, information);
        return OmemoSession.decryptMessageElement(message, transportedKey);
    }

    private CipherAndAuthTag decryptTransportedOmemoKey(OmemoManager omemoManager, OmemoDevice sender, OmemoElement omemoMessage, OmemoMessageInformation messageInfo) throws CryptoFailedException, NoRawSessionException, InterruptedException, CorruptedOmemoKeyException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        int preKeyCountBefore = this.getOmemoStoreBackend().loadOmemoPreKeys(omemoManager).size();
        OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> session = this.getOmemoStoreBackend().getOmemoSessionOf(omemoManager, sender);
        CipherAndAuthTag cipherAndAuthTag = session.decryptTransportedKey(omemoMessage, omemoManager.getDeviceId());
        messageInfo.setSenderDevice(sender);
        messageInfo.setSenderIdentityKey(new IdentityKeyWrapper(session.getIdentityKey()));
        if (preKeyCountBefore != this.getOmemoStoreBackend().loadOmemoPreKeys(omemoManager).size()) {
            LOGGER.log(Level.INFO, "We used up a preKey. Publish new Bundle.");
            this.publishBundle(omemoManager);
        }
        return cipherAndAuthTag;
    }

    OmemoVAxolotlElement encryptOmemoMessage(OmemoManager omemoManager, HashMap<BareJid, ArrayList<OmemoDevice>> recipients, Message message) throws CryptoFailedException, UndecidedOmemoIdentityException {
        OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> builder;
        try {
            builder = new OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>(omemoManager, this.getOmemoStoreBackend(), message.getBody());
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoFailedException(e);
        }
        UndecidedOmemoIdentityException undecided = null;
        for (Map.Entry<BareJid, ArrayList<OmemoDevice>> entry : recipients.entrySet()) {
            for (OmemoDevice c : entry.getValue()) {
                try {
                    builder.addRecipient(c);
                }
                catch (CorruptedOmemoKeyException e) {
                    LOGGER.log(Level.SEVERE, "encryptOmemoMessage failed to establish a session with device " + c + ": " + e.getMessage());
                }
                catch (UndecidedOmemoIdentityException e) {
                    if (undecided == null) {
                        undecided = e;
                        continue;
                    }
                    undecided.join(e);
                }
            }
        }
        if (undecided != null) {
            throw undecided;
        }
        return builder.finish();
    }

    OmemoVAxolotlElement prepareOmemoKeyTransportElement(OmemoManager omemoManager, OmemoDevice ... recipients) throws CryptoFailedException, UndecidedOmemoIdentityException, CorruptedOmemoKeyException, CannotEstablishOmemoSessionException {
        OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> builder;
        try {
            builder = new OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>(omemoManager, this.getOmemoStoreBackend(), null);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoFailedException(e);
        }
        for (OmemoDevice r : recipients) {
            builder.addRecipient(r);
        }
        return builder.finish();
    }

    OmemoVAxolotlElement prepareOmemoKeyTransportElement(OmemoManager omemoManager, byte[] aesKey, byte[] iv, OmemoDevice ... recipients) throws CryptoFailedException, UndecidedOmemoIdentityException, CorruptedOmemoKeyException, CannotEstablishOmemoSessionException {
        OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> builder;
        try {
            builder = new OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>(omemoManager, this.getOmemoStoreBackend(), aesKey, iv);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoFailedException(e);
        }
        for (OmemoDevice r : recipients) {
            builder.addRecipient(r);
        }
        return builder.finish();
    }

    protected Message getOmemoRatchetUpdateMessage(OmemoManager omemoManager, OmemoDevice recipient, boolean preKeyMessage) throws CannotEstablishOmemoSessionException, CorruptedOmemoKeyException, CryptoFailedException, UndecidedOmemoIdentityException {
        if (preKeyMessage) {
            this.buildSessionFromOmemoBundle(omemoManager, recipient, true);
        }
        OmemoVAxolotlElement keyTransportElement = this.prepareOmemoKeyTransportElement(omemoManager, recipient);
        Message ratchetUpdateMessage = omemoManager.finishMessage(keyTransportElement);
        ratchetUpdateMessage.setTo((Jid)recipient.getJid());
        return ratchetUpdateMessage;
    }

    protected void sendOmemoRatchetUpdateMessage(OmemoManager omemoManager, OmemoDevice recipient, boolean preKeyMessage) throws UndecidedOmemoIdentityException, CorruptedOmemoKeyException, CryptoFailedException, CannotEstablishOmemoSessionException {
        Message ratchetUpdateMessage = this.getOmemoRatchetUpdateMessage(omemoManager, recipient, preKeyMessage);
        try {
            omemoManager.getConnection().sendStanza((Stanza)ratchetUpdateMessage);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            LOGGER.log(Level.WARNING, "sendOmemoRatchetUpdateMessage failed: " + e.getMessage());
        }
    }

    private void registerOmemoMessageStanzaListeners(OmemoManager omemoManager) {
        omemoManager.getConnection().removeAsyncStanzaListener((StanzaListener)omemoManager.getOmemoStanzaListener());
        omemoManager.getConnection().addAsyncStanzaListener((StanzaListener)omemoManager.getOmemoStanzaListener(), this.omemoStanzaFilter);
        CarbonManager.getInstanceFor((XMPPConnection)omemoManager.getConnection()).removeCarbonCopyReceivedListener((CarbonCopyReceivedListener)omemoManager.getOmemoCarbonCopyListener());
        CarbonManager.getInstanceFor((XMPPConnection)omemoManager.getConnection()).addCarbonCopyReceivedListener((CarbonCopyReceivedListener)omemoManager.getOmemoCarbonCopyListener());
    }

    List<ClearTextMessage> decryptMamQueryResult(OmemoManager omemoManager, MamManager.MamQueryResult mamQueryResult) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        ArrayList<ClearTextMessage> result = new ArrayList<ClearTextMessage>();
        for (Forwarded f : mamQueryResult.forwardedMessages) {
            if (OmemoManager.stanzaContainsOmemoElement(f.getForwardedStanza())) {
                try {
                    result.add(this.processLocalMessage(omemoManager, f.getForwardedStanza().getFrom().asBareJid(), (Message)f.getForwardedStanza()));
                }
                catch (CorruptedOmemoKeyException | CryptoFailedException | NoRawSessionException e) {
                    LOGGER.log(Level.WARNING, "decryptMamQueryResult failed to decrypt message from " + f.getForwardedStanza().getFrom() + " due to corrupted session/key: " + e.getMessage());
                }
                continue;
            }
            Message m = (Message)f.getForwardedStanza();
            result.add(new ClearTextMessage(m.getBody(), m, new OmemoMessageInformation(null, null, OmemoMessageInformation.CARBON.NONE, false)));
        }
        return result;
    }

    private static OmemoDevice getSender(OmemoManager omemoManager, Stanza stanza) {
        OmemoElement omemoElement = (OmemoElement)stanza.getExtension("encrypted", "eu.siacs.conversations.axolotl");
        Jid sender = stanza.getFrom();
        if (OmemoService.isMucMessage(omemoManager, stanza)) {
            MultiUserChatManager mucm = MultiUserChatManager.getInstanceFor((XMPPConnection)omemoManager.getConnection());
            MultiUserChat muc = mucm.getMultiUserChat(sender.asEntityBareJidIfPossible());
            sender = muc.getOccupant(sender.asEntityFullJidIfPossible()).getJid().asBareJid();
        }
        if (sender == null) {
            throw new AssertionError((Object)"Sender is null.");
        }
        return new OmemoDevice(sender.asBareJid(), omemoElement.getHeader().getSid());
    }

    private static boolean isMucMessage(OmemoManager omemoManager, Stanza stanza) {
        BareJid sender = stanza.getFrom().asBareJid();
        MultiUserChatManager mucm = MultiUserChatManager.getInstanceFor((XMPPConnection)omemoManager.getConnection());
        return mucm.getJoinedRooms().contains(sender.asEntityBareJidIfPossible());
    }

    OmemoStanzaListener createStanzaListener(OmemoManager omemoManager) {
        return new OmemoStanzaListener(omemoManager, this);
    }

    OmemoCarbonCopyListener createOmemoCarbonCopyListener(OmemoManager omemoManager) {
        return new OmemoCarbonCopyListener(omemoManager, this, this.omemoStanzaFilter);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        LOGGER = Logger.getLogger(OmemoService.class.getName());
    }

    class OmemoCarbonCopyListener
    implements CarbonCopyReceivedListener {
        private final OmemoManager omemoManager;
        private final OmemoService<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> service;
        private final StanzaFilter filter;

        public OmemoCarbonCopyListener(OmemoManager omemoManager, OmemoService<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> service, StanzaFilter filter) {
            this.omemoManager = omemoManager;
            this.service = service;
            this.filter = filter;
        }

        public void onCarbonCopyReceived(CarbonExtension.Direction direction, Message carbonCopy, Message wrappingMessage) {
            if (this.filter.accept((Stanza)carbonCopy)) {
                final OmemoDevice senderDevice = OmemoService.getSender(this.omemoManager, (Stanza)carbonCopy);
                MultiUserChatManager mucm = MultiUserChatManager.getInstanceFor((XMPPConnection)this.omemoManager.getConnection());
                OmemoElement omemoMessage = (OmemoElement)carbonCopy.getExtension("encrypted", "eu.siacs.conversations.axolotl");
                OmemoMessageInformation messageInfo = new OmemoMessageInformation();
                if (CarbonExtension.Direction.received.equals((Object)direction)) {
                    messageInfo.setCarbon(OmemoMessageInformation.CARBON.RECV);
                } else {
                    messageInfo.setCarbon(OmemoMessageInformation.CARBON.SENT);
                }
                try {
                    CipherAndAuthTag cipherAndAuthTag;
                    if (OmemoService.isMucMessage(this.omemoManager, (Stanza)carbonCopy)) {
                        CipherAndAuthTag cipherAndAuthTag2;
                        MultiUserChat muc = mucm.getMultiUserChat(carbonCopy.getFrom().asEntityBareJidIfPossible());
                        if (omemoMessage.isMessageElement()) {
                            Message decrypted = OmemoService.this.processReceivingMessage(this.omemoManager, senderDevice, omemoMessage, messageInfo);
                            if (decrypted != null) {
                                this.omemoManager.notifyOmemoMucMessageReceived(muc, senderDevice.getJid(), decrypted.getBody(), carbonCopy, wrappingMessage, messageInfo);
                            }
                        } else if (omemoMessage.isKeyTransportElement() && (cipherAndAuthTag2 = OmemoService.this.decryptTransportedOmemoKey(this.omemoManager, senderDevice, omemoMessage, messageInfo)) != null) {
                            this.omemoManager.notifyOmemoMucKeyTransportMessageReceived(muc, senderDevice.getJid(), cipherAndAuthTag2, carbonCopy, wrappingMessage, messageInfo);
                        }
                    } else if (omemoMessage.isMessageElement()) {
                        Message decrypted = this.service.processReceivingMessage(this.omemoManager, senderDevice, omemoMessage, messageInfo);
                        if (decrypted != null) {
                            this.omemoManager.notifyOmemoMessageReceived(decrypted.getBody(), carbonCopy, null, messageInfo);
                        }
                    } else if (omemoMessage.isKeyTransportElement() && (cipherAndAuthTag = OmemoService.this.decryptTransportedOmemoKey(this.omemoManager, senderDevice, omemoMessage, messageInfo)) != null) {
                        this.omemoManager.notifyOmemoKeyTransportMessageReceived(cipherAndAuthTag, carbonCopy, null, messageInfo);
                    }
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | CorruptedOmemoKeyException | CryptoFailedException e) {
                    LOGGER.log(Level.WARNING, "internal omemoMessageListener failed to decrypt incoming OMEMO carbon copy: " + e.getMessage());
                }
                catch (NoRawSessionException e) {
                    Async.go((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                LOGGER.log(Level.INFO, "Received OMEMO carbon copy message with invalid session from " + senderDevice + ". Send RatchetUpdateMessage.");
                                OmemoCarbonCopyListener.this.service.sendOmemoRatchetUpdateMessage(OmemoCarbonCopyListener.this.omemoManager, senderDevice, true);
                            }
                            catch (CannotEstablishOmemoSessionException | CorruptedOmemoKeyException | CryptoFailedException | UndecidedOmemoIdentityException e1) {
                                LOGGER.log(Level.WARNING, "internal omemoMessageListener failed to establish a session for incoming OMEMO carbon message: " + e.getMessage());
                            }
                        }
                    });
                }
            }
        }
    }

    class OmemoStanzaListener
    implements StanzaListener {
        private final OmemoManager omemoManager;
        private final OmemoService<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> service;

        OmemoStanzaListener(OmemoManager omemoManager, OmemoService<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> service) {
            this.omemoManager = omemoManager;
            this.service = service;
        }

        public void processStanza(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException {
            OmemoElement omemoMessage = (OmemoElement)stanza.getExtension("encrypted", "eu.siacs.conversations.axolotl");
            OmemoMessageInformation messageInfo = new OmemoMessageInformation();
            MultiUserChatManager mucm = MultiUserChatManager.getInstanceFor((XMPPConnection)this.omemoManager.getConnection());
            OmemoDevice senderDevice = OmemoService.getSender(this.omemoManager, stanza);
            try {
                CipherAndAuthTag cipherAndAuthTag;
                if (OmemoService.isMucMessage(this.omemoManager, stanza)) {
                    CipherAndAuthTag cipherAndAuthTag2;
                    MultiUserChat muc = mucm.getMultiUserChat(stanza.getFrom().asEntityBareJidIfPossible());
                    if (omemoMessage.isMessageElement()) {
                        Message decrypted = OmemoService.this.processReceivingMessage(this.omemoManager, senderDevice, omemoMessage, messageInfo);
                        if (decrypted != null) {
                            this.omemoManager.notifyOmemoMucMessageReceived(muc, senderDevice.getJid(), decrypted.getBody(), (Message)stanza, null, messageInfo);
                        }
                    } else if (omemoMessage.isKeyTransportElement() && (cipherAndAuthTag2 = OmemoService.this.decryptTransportedOmemoKey(this.omemoManager, senderDevice, omemoMessage, messageInfo)) != null) {
                        this.omemoManager.notifyOmemoMucKeyTransportMessageReceived(muc, senderDevice.getJid(), cipherAndAuthTag2, (Message)stanza, null, messageInfo);
                    }
                } else if (omemoMessage.isMessageElement()) {
                    Message decrypted = this.service.processReceivingMessage(this.omemoManager, senderDevice, omemoMessage, messageInfo);
                    if (decrypted != null) {
                        this.omemoManager.notifyOmemoMessageReceived(decrypted.getBody(), (Message)stanza, null, messageInfo);
                    }
                } else if (omemoMessage.isKeyTransportElement() && (cipherAndAuthTag = OmemoService.this.decryptTransportedOmemoKey(this.omemoManager, senderDevice, omemoMessage, messageInfo)) != null) {
                    this.omemoManager.notifyOmemoKeyTransportMessageReceived(cipherAndAuthTag, (Message)stanza, null, messageInfo);
                }
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | CorruptedOmemoKeyException | CryptoFailedException e) {
                LOGGER.log(Level.WARNING, "internal omemoMessageListener failed to decrypt incoming OMEMO message: " + e.getMessage());
            }
            catch (NoRawSessionException e) {
                try {
                    LOGGER.log(Level.INFO, "Received message with invalid session from " + senderDevice + ". Send RatchetUpdateMessage.");
                    this.service.sendOmemoRatchetUpdateMessage(this.omemoManager, senderDevice, true);
                }
                catch (CannotEstablishOmemoSessionException | CorruptedOmemoKeyException | CryptoFailedException | UndecidedOmemoIdentityException e1) {
                    LOGGER.log(Level.WARNING, "internal omemoMessageListener failed to establish a session for incoming OMEMO message: " + e.getMessage());
                }
            }
        }
    }
}

