/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class AbstractError {
    protected final String textNamespace;
    protected final Map<String, String> descriptiveTexts;
    protected final List<ExtensionElement> extensions;

    protected AbstractError(Map<String, String> descriptiveTexts) {
        this(descriptiveTexts, null);
    }

    protected AbstractError(Map<String, String> descriptiveTexts, List<ExtensionElement> extensions) {
        this(descriptiveTexts, null, extensions);
    }

    protected AbstractError(Map<String, String> descriptiveTexts, String textNamespace, List<ExtensionElement> extensions) {
        this.descriptiveTexts = descriptiveTexts != null ? descriptiveTexts : Collections.emptyMap();
        this.textNamespace = textNamespace;
        this.extensions = extensions != null ? extensions : Collections.emptyList();
    }

    public String getDescriptiveText() {
        String defaultLocale = Locale.getDefault().getLanguage();
        String descriptiveText = this.getDescriptiveText(defaultLocale);
        if (descriptiveText == null && (descriptiveText = this.getDescriptiveText("en")) == null) {
            descriptiveText = this.getDescriptiveText("");
        }
        return descriptiveText;
    }

    public String getDescriptiveText(String xmllang) {
        return this.descriptiveTexts.get(xmllang);
    }

    public <PE extends ExtensionElement> PE getExtension(String elementName, String namespace) {
        return PacketUtil.extensionElementFrom(this.extensions, elementName, namespace);
    }

    protected void addDescriptiveTextsAndExtensions(XmlStringBuilder xml) {
        for (Map.Entry<String, String> entry : this.descriptiveTexts.entrySet()) {
            String xmllang = entry.getKey();
            String text = entry.getValue();
            xml.halfOpenElement("text").xmlnsAttribute(this.textNamespace).xmllangAttribute(xmllang).rightAngleBracket();
            xml.escape(text);
            xml.closeElement("text");
        }
        for (ExtensionElement packetExtension : this.extensions) {
            xml.append(packetExtension.toXML());
        }
    }

    public static abstract class Builder<B extends Builder<B>> {
        protected String textNamespace;
        protected Map<String, String> descriptiveTexts;
        protected List<ExtensionElement> extensions;

        public B setDescriptiveTexts(Map<String, String> descriptiveTexts) {
            if (this.descriptiveTexts == null) {
                this.descriptiveTexts = descriptiveTexts;
            } else {
                this.descriptiveTexts.putAll(descriptiveTexts);
            }
            return this.getThis();
        }

        public B setDescriptiveEnText(String descriptiveEnText) {
            if (this.descriptiveTexts == null) {
                this.descriptiveTexts = new HashMap<String, String>();
            }
            this.descriptiveTexts.put("en", descriptiveEnText);
            return this.getThis();
        }

        public B setTextNamespace(String textNamespace) {
            this.textNamespace = textNamespace;
            return this.getThis();
        }

        public B setExtensions(List<ExtensionElement> extensions) {
            if (this.extensions == null) {
                this.extensions = extensions;
            } else {
                this.extensions.addAll(extensions);
            }
            return this.getThis();
        }

        public B addExtension(ExtensionElement extension) {
            if (this.extensions == null) {
                this.extensions = new ArrayList<ExtensionElement>();
            }
            this.extensions.add(extension);
            return this.getThis();
        }

        protected abstract B getThis();
    }
}

