/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.IQReplyFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.jivesoftware.smackx.mam.element.MamElements;
import org.jivesoftware.smackx.mam.element.MamFinIQ;
import org.jivesoftware.smackx.mam.element.MamPrefsIQ;
import org.jivesoftware.smackx.mam.element.MamQueryIQ;
import org.jivesoftware.smackx.mam.filter.MamResultFilter;
import org.jivesoftware.smackx.rsm.packet.RSMSet;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.util.XmppDateTime;

public final class MamManager
extends Manager {
    private static final Map<XMPPConnection, Map<Jid, MamManager>> INSTANCES;
    private final Jid archiveAddress;
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    public static MamManager getInstanceFor(XMPPConnection connection) {
        return MamManager.getInstanceFor(connection, null);
    }

    public static synchronized MamManager getInstanceFor(XMPPConnection connection, Jid archiveAddress) {
        MamManager mamManager;
        Map<Jid, MamManager> managers = INSTANCES.get(connection);
        if (managers == null) {
            managers = new HashMap<Jid, MamManager>();
            INSTANCES.put(connection, managers);
        }
        if ((mamManager = managers.get(archiveAddress)) == null) {
            mamManager = new MamManager(connection, archiveAddress);
            managers.put(archiveAddress, mamManager);
        }
        return mamManager;
    }

    private MamManager(XMPPConnection connection, Jid archiveAddress) {
        super(connection);
        this.archiveAddress = archiveAddress;
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
    }

    public MamQueryResult queryArchive(Integer max) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        return this.queryArchive(null, max, null, null, null, null);
    }

    public MamQueryResult queryArchive(Jid withJid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        return this.queryArchive(null, null, null, null, withJid, null);
    }

    public MamQueryResult queryArchive(Date start, Date end) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        return this.queryArchive(null, null, start, end, null, null);
    }

    public MamQueryResult queryArchive(List<FormField> additionalFields) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        return this.queryArchive(null, null, null, null, null, additionalFields);
    }

    public MamQueryResult queryArchiveWithStartDate(Date start) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        return this.queryArchive(null, null, start, null, null, null);
    }

    public MamQueryResult queryArchiveWithEndDate(Date end) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        return this.queryArchive(null, null, null, end, null, null);
    }

    public MamQueryResult queryArchive(Integer max, Date start, Date end, Jid withJid, List<FormField> additionalFields) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        return this.queryArchive(null, max, start, end, withJid, additionalFields);
    }

    public MamQueryResult queryArchive(String node, Integer max, Date start, Date end, Jid withJid, List<FormField> additionalFields) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        DataForm dataForm = null;
        String queryId = UUID.randomUUID().toString();
        if (start != null || end != null || withJid != null || additionalFields != null) {
            dataForm = MamManager.getNewMamForm();
            MamManager.addStart(start, dataForm);
            MamManager.addEnd(end, dataForm);
            MamManager.addWithJid(withJid, dataForm);
            MamManager.addAdditionalFields(additionalFields, dataForm);
        }
        MamQueryIQ mamQueryIQ = new MamQueryIQ(queryId, node, dataForm);
        mamQueryIQ.setType(IQ.Type.set);
        mamQueryIQ.setTo(this.archiveAddress);
        MamManager.addResultsLimit(max, mamQueryIQ);
        return this.queryArchive(mamQueryIQ);
    }

    private static void addAdditionalFields(List<FormField> additionalFields, DataForm dataForm) {
        if (additionalFields == null) {
            return;
        }
        for (FormField formField : additionalFields) {
            dataForm.addField(formField);
        }
    }

    private static void addResultsLimit(Integer max, MamQueryIQ mamQueryIQ) {
        if (max == null) {
            return;
        }
        RSMSet rsmSet = new RSMSet(max.intValue());
        mamQueryIQ.addExtension((ExtensionElement)rsmSet);
    }

    private static void addWithJid(Jid withJid, DataForm dataForm) {
        if (withJid == null) {
            return;
        }
        FormField formField = new FormField("with");
        formField.addValue(withJid.toString());
        dataForm.addField(formField);
    }

    private static void addEnd(Date end, DataForm dataForm) {
        if (end == null) {
            return;
        }
        FormField formField = new FormField("end");
        formField.addValue(XmppDateTime.formatXEP0082Date((Date)end));
        dataForm.addField(formField);
    }

    private static void addStart(Date start, DataForm dataForm) {
        if (start == null) {
            return;
        }
        FormField formField = new FormField("start");
        formField.addValue(XmppDateTime.formatXEP0082Date((Date)start));
        dataForm.addField(formField);
    }

    public MamQueryResult page(DataForm dataForm, RSMSet rsmSet) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        return this.page(null, dataForm, rsmSet);
    }

    public MamQueryResult page(String node, DataForm dataForm, RSMSet rsmSet) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        MamQueryIQ mamQueryIQ = new MamQueryIQ(UUID.randomUUID().toString(), node, dataForm);
        mamQueryIQ.setType(IQ.Type.set);
        mamQueryIQ.setTo(this.archiveAddress);
        mamQueryIQ.addExtension((ExtensionElement)rsmSet);
        return this.queryArchive(mamQueryIQ);
    }

    public MamQueryResult pageNext(MamQueryResult mamQueryResult, int count) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        RSMSet previousResultRsmSet = mamQueryResult.mamFin.getRSMSet();
        RSMSet requestRsmSet = new RSMSet(count, previousResultRsmSet.getLast(), RSMSet.PageDirection.after);
        return this.page(mamQueryResult, requestRsmSet);
    }

    public MamQueryResult pagePrevious(MamQueryResult mamQueryResult, int count) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        RSMSet previousResultRsmSet = mamQueryResult.mamFin.getRSMSet();
        RSMSet requestRsmSet = new RSMSet(count, previousResultRsmSet.getFirst(), RSMSet.PageDirection.before);
        return this.page(mamQueryResult, requestRsmSet);
    }

    private MamQueryResult page(MamQueryResult mamQueryResult, RSMSet requestRsmSet) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException {
        this.ensureMamQueryResultMatchesThisManager(mamQueryResult);
        return this.page(mamQueryResult.node, mamQueryResult.form, requestRsmSet);
    }

    public MamQueryResult pageBefore(Jid chatJid, String messageUid, int max) throws XMPPException.XMPPErrorException, SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        RSMSet rsmSet = new RSMSet(null, messageUid, -1, -1, null, max, null, -1);
        DataForm dataForm = MamManager.getNewMamForm();
        MamManager.addWithJid(chatJid, dataForm);
        return this.page(null, dataForm, rsmSet);
    }

    public MamQueryResult pageAfter(Jid chatJid, String messageUid, int max) throws XMPPException.XMPPErrorException, SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        RSMSet rsmSet = new RSMSet(messageUid, null, -1, -1, null, max, null, -1);
        DataForm dataForm = MamManager.getNewMamForm();
        MamManager.addWithJid(chatJid, dataForm);
        return this.page(null, dataForm, rsmSet);
    }

    public MamQueryResult mostRecentPage(Jid chatJid, int max) throws XMPPException.XMPPErrorException, SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return this.pageBefore(chatJid, "", max);
    }

    public List<FormField> retrieveFormFields() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        return this.retrieveFormFields(null);
    }

    public List<FormField> retrieveFormFields(String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        String queryId = UUID.randomUUID().toString();
        MamQueryIQ mamQueryIq = new MamQueryIQ(queryId, node, null);
        mamQueryIq.setTo(this.archiveAddress);
        MamQueryIQ mamResponseQueryIq = (MamQueryIQ)this.connection().createStanzaCollectorAndSend((IQ)mamQueryIq).nextResultOrThrow();
        return mamResponseQueryIq.getDataForm().getFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MamQueryResult queryArchive(MamQueryIQ mamQueryIq) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        MamFinIQ mamFinIQ = null;
        StanzaCollector mamFinIQCollector = connection.createStanzaCollector((StanzaFilter)new IQReplyFilter((IQ)mamQueryIq, connection));
        StanzaCollector.Configuration resultCollectorConfiguration = StanzaCollector.newConfiguration().setStanzaFilter((StanzaFilter)new MamResultFilter(mamQueryIq)).setCollectorToReset(mamFinIQCollector);
        StanzaCollector resultCollector = connection.createStanzaCollector(resultCollectorConfiguration);
        try {
            connection.sendStanza((Stanza)mamQueryIq);
            mamFinIQ = (MamFinIQ)mamFinIQCollector.nextResultOrThrow();
        }
        finally {
            mamFinIQCollector.cancel();
            resultCollector.cancel();
        }
        ArrayList<Forwarded> forwardedMessages = new ArrayList<Forwarded>(resultCollector.getCollectedCount());
        Message resultMessage = (Message)resultCollector.pollResult();
        while (resultMessage != null) {
            MamElements.MamResultExtension mamResultExtension = MamElements.MamResultExtension.from(resultMessage);
            forwardedMessages.add(mamResultExtension.getForwarded());
            resultMessage = (Message)resultCollector.pollResult();
        }
        return new MamQueryResult(forwardedMessages, mamFinIQ, mamQueryIq.getNode(), DataForm.from((Stanza)mamQueryIq));
    }

    private void ensureMamQueryResultMatchesThisManager(MamQueryResult mamQueryResult) {
        EntityFullJid localAddress = this.connection().getUser();
        EntityBareJid localBareAddress = null;
        if (localAddress != null) {
            localBareAddress = localAddress.asEntityBareJid();
        }
        boolean isLocalUserArchive = this.archiveAddress == null || this.archiveAddress.equals((CharSequence)localBareAddress);
        Jid finIqFrom = mamQueryResult.mamFin.getFrom();
        if (finIqFrom != null) {
            if (finIqFrom.equals((CharSequence)this.archiveAddress) || isLocalUserArchive && finIqFrom.equals((CharSequence)localBareAddress)) {
                return;
            }
            throw new IllegalArgumentException("The given MamQueryResult is from the MAM archive '" + finIqFrom + "' whereas this MamManager is responsible for '" + this.archiveAddress + '\'');
        }
        if (!isLocalUserArchive) {
            throw new IllegalArgumentException("The given MamQueryResult is from the local entity (user) MAM archive, whereas this MamManager is responsible for '" + this.archiveAddress + '\'');
        }
    }

    public boolean isSupported() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        BareJid myBareJid = this.connection().getUser().asBareJid();
        return this.serviceDiscoveryManager.supportsFeature((Jid)myBareJid, (CharSequence)"urn:xmpp:mam:1");
    }

    @Deprecated
    public boolean isSupportedByServer() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).serverSupportsFeature((CharSequence)"urn:xmpp:mam:1");
    }

    private static DataForm getNewMamForm() {
        FormField field = new FormField("FORM_TYPE");
        field.setType(FormField.Type.hidden);
        field.addValue("urn:xmpp:mam:1");
        DataForm form = new DataForm(DataForm.Type.submit);
        form.addField(field);
        return form;
    }

    public MamPrefsResult retrieveArchivingPreferences() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        MamPrefsIQ mamPrefIQ = new MamPrefsIQ();
        return this.queryMamPrefs(mamPrefIQ);
    }

    public MamPrefsResult updateArchivingPreferences(List<Jid> alwaysJids, List<Jid> neverJids, MamPrefsIQ.DefaultBehavior defaultBehavior) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        Objects.requireNonNull((Object)((Object)defaultBehavior), (String)"Default behavior must be set");
        MamPrefsIQ mamPrefIQ = new MamPrefsIQ(alwaysJids, neverJids, defaultBehavior);
        return this.queryMamPrefs(mamPrefIQ);
    }

    private MamPrefsResult queryMamPrefs(MamPrefsIQ mamPrefsIQ) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        MamPrefsIQ mamPrefsResultIQ = (MamPrefsIQ)connection.createStanzaCollectorAndSend((IQ)mamPrefsIQ).nextResultOrThrow();
        return new MamPrefsResult(mamPrefsResultIQ, DataForm.from((Stanza)mamPrefsIQ));
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                MamManager.getInstanceFor(connection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, Map<Jid, MamManager>>();
    }

    public static final class MamPrefsResult {
        public final MamPrefsIQ mamPrefs;
        public final DataForm form;

        private MamPrefsResult(MamPrefsIQ mamPrefs, DataForm form) {
            this.mamPrefs = mamPrefs;
            this.form = form;
        }
    }

    public static final class MamQueryResult {
        public final List<Forwarded> forwardedMessages;
        public final MamFinIQ mamFin;
        private final String node;
        private final DataForm form;

        private MamQueryResult(List<Forwarded> forwardedMessages, MamFinIQ mamFin, String node, DataForm form) {
            this.forwardedMessages = forwardedMessages;
            this.mamFin = mamFin;
            this.node = node;
            this.form = form;
        }
    }
}

