/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.roster.RosterIntegrationTest;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.iot.Thing;
import org.jivesoftware.smackx.iot.data.IoTDataManager;
import org.jivesoftware.smackx.iot.data.ThingMomentaryReadOutRequest;
import org.jivesoftware.smackx.iot.data.ThingMomentaryReadOutResult;
import org.jivesoftware.smackx.iot.data.element.IoTDataField;
import org.jivesoftware.smackx.iot.data.element.IoTFieldsExtension;
import org.jivesoftware.smackx.iot.data.element.NodeElement;
import org.jivesoftware.smackx.iot.data.element.TimestampElement;
import org.junit.Assert;

public class IoTDataIntegrationTest
extends AbstractSmackIntegrationTest {
    private final IoTDataManager iotDataManagerOne;
    private final IoTDataManager iotDataManagerTwo;

    public IoTDataIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.iotDataManagerOne = IoTDataManager.getInstanceFor((XMPPConnection)this.conOne);
        this.iotDataManagerTwo = IoTDataManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void dataTest() throws TimeoutException, Exception {
        List values;
        String key = StringUtils.randomString((int)12);
        String sn = StringUtils.randomString((int)12);
        final int value = INSECURE_RANDOM.nextInt();
        Thing dataThing = Thing.builder().setKey(key).setSerialNumber(sn).setMomentaryReadOutRequestHandler(new ThingMomentaryReadOutRequest(){

            public void momentaryReadOutRequest(ThingMomentaryReadOutResult callback) {
                IoTDataField.IntField field = new IoTDataField.IntField(IoTDataIntegrationTest.this.testRunId, value);
                callback.momentaryReadOut(Collections.singletonList(field));
            }
        }).build();
        this.iotDataManagerOne.installThing(dataThing);
        try {
            RosterIntegrationTest.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
            values = this.iotDataManagerTwo.requestMomentaryValuesReadOut(this.conOne.getUser());
        }
        finally {
            this.iotDataManagerOne.uninstallThing(dataThing);
            RosterIntegrationTest.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        }
        Assert.assertEquals((long)1L, (long)values.size());
        IoTFieldsExtension iotFieldsExtension = (IoTFieldsExtension)values.get(0);
        List nodes = iotFieldsExtension.getNodes();
        Assert.assertEquals((long)1L, (long)nodes.size());
        NodeElement node = (NodeElement)nodes.get(0);
        List timestamps = node.getTimestampElements();
        Assert.assertEquals((long)1L, (long)timestamps.size());
        TimestampElement timestamp = (TimestampElement)timestamps.get(0);
        List fields = timestamp.getDataFields();
        Assert.assertEquals((long)1L, (long)fields.size());
        IoTDataField dataField = (IoTDataField)fields.get(0);
        Assert.assertTrue((boolean)(dataField instanceof IoTDataField.IntField));
        IoTDataField.IntField intDataField = (IoTDataField.IntField)dataField;
        Assert.assertEquals((Object)this.testRunId, (Object)intDataField.getName());
        Assert.assertEquals((long)value, (long)intDataField.getValue());
    }
}

