/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot;

import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.iot.Thing;
import org.jivesoftware.smackx.iot.discovery.IoTClaimedException;
import org.jivesoftware.smackx.iot.discovery.IoTDiscoveryManager;
import org.jivesoftware.smackx.iot.discovery.ThingState;
import org.jivesoftware.smackx.iot.discovery.element.IoTClaimed;
import org.junit.Assert;
import org.jxmpp.jid.Jid;

public class IoTDiscoveryIntegrationTest
extends AbstractSmackIntegrationTest {
    private final IoTDiscoveryManager discoveryManagerOne;
    private final IoTDiscoveryManager discoveryManagerTwo;

    public IoTDiscoveryIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        super(environment);
        this.discoveryManagerOne = IoTDiscoveryManager.getInstanceFor((XMPPConnection)this.conOne);
        this.discoveryManagerTwo = IoTDiscoveryManager.getInstanceFor((XMPPConnection)this.conTwo);
        IoTDiscoveryIntegrationTest.checkPrerequisites(this.conOne);
    }

    @SmackIntegrationTest
    public void registerClaimAndUnregisterThing() throws XMPPException.XMPPErrorException, InterruptedException, SmackException {
        String key = StringUtils.randomString((int)12);
        String sn = StringUtils.randomString((int)12);
        Thing thing = Thing.builder().setKey(key).setSerialNumber(sn).setManufacturer("Ignite Realtime").setModel("Smack").setVersion("0.1").build();
        IoTDiscoveryIntegrationTest.registerThing(this.discoveryManagerOne, thing);
        IoTClaimed iotClaimed = this.discoveryManagerTwo.claimThing(thing.getMetaTags());
        Assert.assertEquals((Object)this.conOne.getUser().asBareJid(), (Object)iotClaimed.getJid());
        this.discoveryManagerTwo.disownThing(iotClaimed.getJid());
        this.discoveryManagerOne.unregister();
    }

    static void checkPrerequisites(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        IoTDiscoveryManager discoveryManager = IoTDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        Jid registry = discoveryManager.findRegistry();
        if (registry == null) {
            throw new TestNotPossibleException("Could not find IoT Registry");
        }
    }

    public static ThingState registerThing(IoTDiscoveryManager iotDiscoveryManager, Thing thing) throws XMPPException.XMPPErrorException, InterruptedException, SmackException {
        int attempts = 0;
        while (true) {
            try {
                return iotDiscoveryManager.registerThing(thing);
            }
            catch (IoTClaimedException e) {
                iotDiscoveryManager.unregister();
                if (attempts++ <= 3) continue;
                throw new SmackException("Could no register thing");
            }
            break;
        }
    }
}

