/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.stringprep.simple;

import java.util.Locale;
import org.jxmpp.stringprep.XmppStringPrepUtil;
import org.jxmpp.stringprep.XmppStringprep;
import org.jxmpp.stringprep.XmppStringprepException;

public final class SimpleXmppStringprep
implements XmppStringprep {
    private static SimpleXmppStringprep instance;
    private static final char[] LOCALPART_FURTHER_EXCLUDED_CHARACTERS;

    public static void setup() {
        XmppStringPrepUtil.setXmppStringprep(SimpleXmppStringprep.getInstance());
    }

    public static SimpleXmppStringprep getInstance() {
        if (instance == null) {
            instance = new SimpleXmppStringprep();
        }
        return instance;
    }

    private SimpleXmppStringprep() {
    }

    @Override
    public String localprep(String string) throws XmppStringprepException {
        string = SimpleXmppStringprep.simpleStringprep(string);
        for (char charFromString : string.toCharArray()) {
            for (char forbiddenChar : LOCALPART_FURTHER_EXCLUDED_CHARACTERS) {
                if (charFromString != forbiddenChar) continue;
                throw new XmppStringprepException(string, "Localpart must not contain '" + forbiddenChar + "'");
            }
        }
        return string;
    }

    @Override
    public String domainprep(String string) throws XmppStringprepException {
        return SimpleXmppStringprep.simpleStringprep(string);
    }

    @Override
    public String resourceprep(String string) throws XmppStringprepException {
        return string;
    }

    private static String simpleStringprep(String string) {
        String res = string.toLowerCase(Locale.US);
        return res;
    }

    static {
        LOCALPART_FURTHER_EXCLUDED_CHARACTERS = new char[]{'\"', '&', '\'', '/', ',', '<', '>', '@', ' '};
    }
}

