/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.provisioning;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.AbstractPresenceEventListener;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.SubscribeListener;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.iot.IoTManager;
import org.jivesoftware.smackx.iot.discovery.IoTDiscoveryManager;
import org.jivesoftware.smackx.iot.provisioning.BecameFriendListener;
import org.jivesoftware.smackx.iot.provisioning.WasUnfriendedListener;
import org.jivesoftware.smackx.iot.provisioning.element.ClearCache;
import org.jivesoftware.smackx.iot.provisioning.element.ClearCacheResponse;
import org.jivesoftware.smackx.iot.provisioning.element.Friend;
import org.jivesoftware.smackx.iot.provisioning.element.IoTIsFriend;
import org.jivesoftware.smackx.iot.provisioning.element.IoTIsFriendResponse;
import org.jivesoftware.smackx.iot.provisioning.element.Unfriend;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.util.cache.LruCache;

public final class IoTProvisioningManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(IoTProvisioningManager.class.getName());
    private static final StanzaFilter FRIEND_MESSAGE = new AndFilter(new StanzaFilter[]{StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter("friend", "urn:xmpp:iot:provisioning")});
    private static final StanzaFilter UNFRIEND_MESSAGE = new AndFilter(new StanzaFilter[]{StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter("UNFRIEND", "urn:xmpp:iot:provisioning")});
    private static final Map<XMPPConnection, IoTProvisioningManager> INSTANCES = new WeakHashMap<XMPPConnection, IoTProvisioningManager>();
    private final Roster roster;
    private final LruCache<Jid, LruCache<BareJid, Void>> negativeFriendshipRequestCache = new LruCache(8);
    private final LruCache<BareJid, Void> friendshipDeniedCache = new LruCache(16);
    private final LruCache<BareJid, Void> friendshipRequestedCache = new LruCache(16);
    private final Set<BecameFriendListener> becameFriendListeners = new CopyOnWriteArraySet<BecameFriendListener>();
    private final Set<WasUnfriendedListener> wasUnfriendedListeners = new CopyOnWriteArraySet<WasUnfriendedListener>();
    private Jid configuredProvisioningServer;

    public static synchronized IoTProvisioningManager getInstanceFor(XMPPConnection connection) {
        IoTProvisioningManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new IoTProvisioningManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    private IoTProvisioningManager(XMPPConnection connection) {
        super(connection);
        connection.addAsyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException {
                if (!IoTProvisioningManager.this.isFromProvisioningService(stanza, true)) {
                    return;
                }
                Message message = (Message)stanza;
                Unfriend unfriend = Unfriend.from(message);
                BareJid unfriendJid = unfriend.getJid();
                XMPPConnection connection = IoTProvisioningManager.this.connection();
                Roster roster = Roster.getInstanceFor((XMPPConnection)connection);
                if (!roster.isSubscribedToMyPresence((Jid)unfriendJid)) {
                    LOGGER.warning("Ignoring <unfriend/> request '" + stanza + "' because " + unfriendJid + " is already not subscribed to our presence.");
                    return;
                }
                Presence unsubscribed = new Presence(Presence.Type.unsubscribed);
                unsubscribed.setTo((Jid)unfriendJid);
                connection.sendStanza((Stanza)unsubscribed);
            }
        }, UNFRIEND_MESSAGE);
        connection.addAsyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException {
                Message friendMessage = (Message)stanza;
                Friend friend = Friend.from(friendMessage);
                BareJid friendJid = friend.getFriend();
                if (IoTProvisioningManager.this.isFromProvisioningService((Stanza)friendMessage, false)) {
                    XMPPConnection connection = IoTProvisioningManager.this.connection();
                    Friend friendNotifiacation = new Friend(connection.getUser().asBareJid());
                    Message notificationMessage = new Message((Jid)friendJid, (ExtensionElement)friendNotifiacation);
                    connection.sendStanza((Stanza)notificationMessage);
                } else {
                    BareJid bareFrom = friendMessage.getFrom().asBareJid();
                    if (!IoTProvisioningManager.this.friendshipDeniedCache.containsKey((Object)bareFrom)) {
                        LOGGER.log(Level.WARNING, "Ignoring friendship recommendation " + friendMessage + " because friendship to this JID was not previously denied.");
                        return;
                    }
                    if (!bareFrom.equals((CharSequence)friendJid)) {
                        LOGGER.log(Level.WARNING, "Ignoring friendship recommendation " + friendMessage + " because it does not recommend itself, but " + friendJid + '.');
                        return;
                    }
                    IoTProvisioningManager.this.sendFriendshipRequest(friendJid);
                }
            }
        }, FRIEND_MESSAGE);
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("clearCache", "urn:xmpp:iot:provisioning", IQ.Type.set, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                if (!IoTProvisioningManager.this.isFromProvisioningService((Stanza)iqRequest, true)) {
                    return null;
                }
                ClearCache clearCache = (ClearCache)iqRequest;
                Jid from = iqRequest.getFrom();
                LruCache cache = (LruCache)IoTProvisioningManager.this.negativeFriendshipRequestCache.lookup((Object)from);
                if (cache != null) {
                    cache.clear();
                }
                return new ClearCacheResponse(clearCache);
            }
        });
        this.roster = Roster.getInstanceFor((XMPPConnection)connection);
        this.roster.addSubscribeListener(new SubscribeListener(){

            public SubscribeListener.SubscribeAnswer processSubscribe(Jid from, Presence subscribeRequest) {
                boolean isFriend;
                try {
                    if (IoTDiscoveryManager.getInstanceFor(IoTProvisioningManager.this.connection()).isRegistry(from.asBareJid())) {
                        return SubscribeListener.SubscribeAnswer.Approve;
                    }
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                    LOGGER.log(Level.WARNING, "Could not determine if " + from + " is a registry", e);
                }
                Jid provisioningServer = null;
                try {
                    provisioningServer = IoTProvisioningManager.this.getConfiguredProvisioningServer();
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                    LOGGER.log(Level.WARNING, "Could not determine privisioning server. Ignoring friend request from " + from, e);
                }
                if (provisioningServer == null) {
                    return null;
                }
                try {
                    isFriend = IoTProvisioningManager.this.isFriend(provisioningServer, from.asBareJid());
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                    LOGGER.log(Level.WARNING, "Could not determine if " + from + " is a friend.", e);
                    return null;
                }
                if (isFriend) {
                    return SubscribeListener.SubscribeAnswer.Approve;
                }
                return SubscribeListener.SubscribeAnswer.Deny;
            }
        });
        this.roster.addPresenceEventListener((PresenceEventListener)new AbstractPresenceEventListener(){

            public void presenceSubscribed(BareJid address, Presence subscribedPresence) {
                IoTProvisioningManager.this.friendshipRequestedCache.remove((Object)address);
                for (BecameFriendListener becameFriendListener : IoTProvisioningManager.this.becameFriendListeners) {
                    becameFriendListener.becameFriend(address, subscribedPresence);
                }
            }

            public void presenceUnsubscribed(BareJid address, Presence unsubscribedPresence) {
                if (IoTProvisioningManager.this.friendshipRequestedCache.containsKey((Object)address)) {
                    IoTProvisioningManager.this.friendshipDeniedCache.put((Object)address, null);
                }
                for (WasUnfriendedListener wasUnfriendedListener : IoTProvisioningManager.this.wasUnfriendedListeners) {
                    wasUnfriendedListener.wasUnfriendedListener(address, unsubscribedPresence);
                }
            }
        });
    }

    public void setConfiguredProvisioningServer(Jid provisioningServer) {
        this.configuredProvisioningServer = provisioningServer;
    }

    public Jid getConfiguredProvisioningServer() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.configuredProvisioningServer == null) {
            this.configuredProvisioningServer = this.findProvisioningServerComponent();
        }
        return this.configuredProvisioningServer;
    }

    public DomainBareJid findProvisioningServerComponent() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        List discoverInfos = sdm.findServicesDiscoverInfo("urn:xmpp:iot:provisioning", true, true);
        if (discoverInfos.isEmpty()) {
            return null;
        }
        Jid jid = ((DiscoverInfo)discoverInfos.get(0)).getFrom();
        assert (jid.isDomainBareJid());
        return jid.asDomainBareJid();
    }

    public boolean isFriend(Jid provisioningServer, BareJid friendInQuestion) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        LruCache cache = (LruCache)this.negativeFriendshipRequestCache.lookup((Object)provisioningServer);
        if (cache != null && cache.containsKey((Object)friendInQuestion)) {
            return false;
        }
        IoTIsFriend iotIsFriend = new IoTIsFriend((Jid)friendInQuestion);
        iotIsFriend.setTo(provisioningServer);
        IoTIsFriendResponse response = (IoTIsFriendResponse)this.connection().createStanzaCollectorAndSend((IQ)iotIsFriend).nextResultOrThrow();
        assert (response.getJid().equals((CharSequence)friendInQuestion));
        boolean isFriend = response.getIsFriendResult();
        if (!isFriend) {
            if (cache == null) {
                cache = new LruCache(1024);
                this.negativeFriendshipRequestCache.put((Object)provisioningServer, (Object)cache);
            }
            cache.put((Object)friendInQuestion, null);
        }
        return isFriend;
    }

    public boolean iAmFriendOf(BareJid otherJid) {
        return this.roster.iAmSubscribedTo((Jid)otherJid);
    }

    public void sendFriendshipRequest(BareJid bareJid) throws SmackException.NotConnectedException, InterruptedException {
        Presence presence = new Presence(Presence.Type.subscribe);
        presence.setTo((Jid)bareJid);
        this.friendshipRequestedCache.put((Object)bareJid, null);
        this.connection().sendStanza((Stanza)presence);
    }

    public void sendFriendshipRequestIfRequired(BareJid jid) throws SmackException.NotConnectedException, InterruptedException {
        if (this.iAmFriendOf(jid)) {
            return;
        }
        this.sendFriendshipRequest(jid);
    }

    public boolean isMyFriend(Jid friendInQuestion) {
        return this.roster.isSubscribedToMyPresence(friendInQuestion);
    }

    public void unfriend(Jid friend) throws SmackException.NotConnectedException, InterruptedException {
        if (this.isMyFriend(friend)) {
            Presence presence = new Presence(Presence.Type.unsubscribed);
            presence.setTo(friend);
            this.connection().sendStanza((Stanza)presence);
        }
    }

    public boolean addBecameFriendListener(BecameFriendListener becameFriendListener) {
        return this.becameFriendListeners.add(becameFriendListener);
    }

    public boolean removeBecameFriendListener(BecameFriendListener becameFriendListener) {
        return this.becameFriendListeners.remove(becameFriendListener);
    }

    public boolean addWasUnfriendedListener(WasUnfriendedListener wasUnfriendedListener) {
        return this.wasUnfriendedListeners.add(wasUnfriendedListener);
    }

    public boolean removeWasUnfriendedListener(WasUnfriendedListener wasUnfriendedListener) {
        return this.wasUnfriendedListeners.remove(wasUnfriendedListener);
    }

    private boolean isFromProvisioningService(Stanza stanza, boolean log) {
        Jid provisioningServer;
        try {
            provisioningServer = this.getConfiguredProvisioningServer();
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
            LOGGER.log(Level.WARNING, "Could determine provisioning server", e);
            return false;
        }
        if (provisioningServer == null) {
            if (log) {
                LOGGER.warning("Ignoring request '" + stanza + "' because no provisioning server configured.");
            }
            return false;
        }
        if (!provisioningServer.equals((CharSequence)stanza.getFrom())) {
            if (log) {
                LOGGER.warning("Ignoring  request '" + stanza + "' because not from provising server '" + provisioningServer + "'.");
            }
            return false;
        }
        return true;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                if (!IoTManager.isAutoEnableActive()) {
                    return;
                }
                IoTProvisioningManager.getInstanceFor(connection);
            }
        });
    }
}

