/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smackx.carbons.CarbonCopyReceivedListener;
import org.jivesoftware.smackx.carbons.CarbonManager;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.eme.element.ExplicitMessageEncryptionElement;
import org.jivesoftware.smackx.hints.element.StoreHint;
import org.jivesoftware.smackx.mam.MamManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.omemo.OmemoConfiguration;
import org.jivesoftware.smackx.omemo.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.element.OmemoDeviceListVAxolotlElement;
import org.jivesoftware.smackx.omemo.element.OmemoVAxolotlElement;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.NoOmemoSupportException;
import org.jivesoftware.smackx.omemo.exceptions.NoRawSessionException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.internal.CachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.CipherAndAuthTag;
import org.jivesoftware.smackx.omemo.internal.ClearTextMessage;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.internal.OmemoMessageInformation;
import org.jivesoftware.smackx.omemo.listener.OmemoMessageListener;
import org.jivesoftware.smackx.omemo.listener.OmemoMucMessageListener;
import org.jivesoftware.smackx.pep.PEPListener;
import org.jivesoftware.smackx.pep.PEPManager;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public final class OmemoManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(OmemoManager.class.getName());
    private static final WeakHashMap<XMPPConnection, WeakHashMap<Integer, OmemoManager>> INSTANCES = new WeakHashMap();
    private final OmemoService<?, ?, ?, ?, ?, ?, ?, ?, ?> service;
    private final HashSet<OmemoMessageListener> omemoMessageListeners = new HashSet();
    private final HashSet<OmemoMucMessageListener> omemoMucMessageListeners = new HashSet();
    private OmemoService.OmemoStanzaListener omemoStanzaListener;
    private OmemoService.OmemoCarbonCopyListener omemoCarbonCopyListener;
    private int deviceId;
    PEPListener deviceListUpdateListener = new PEPListener(){

        public void eventReceived(EntityBareJid from, EventElement event, Message message) {
            for (ExtensionElement items : event.getExtensions()) {
                if (!(items instanceof ItemsExtension)) continue;
                for (ExtensionElement item : ((ItemsExtension)items).getItems()) {
                    PayloadItem payloadItem;
                    if (!(item instanceof PayloadItem) || !((payloadItem = (PayloadItem)item).getPayload() instanceof OmemoDeviceListVAxolotlElement)) continue;
                    OmemoDeviceListVAxolotlElement omemoDeviceListElement = (OmemoDeviceListVAxolotlElement)payloadItem.getPayload();
                    int ourDeviceId = OmemoManager.this.getDeviceId();
                    OmemoManager.this.getOmemoService().getOmemoStoreBackend().mergeCachedDeviceList(OmemoManager.this, (BareJid)from, omemoDeviceListElement);
                    if (from == null || !from.equals((CharSequence)OmemoManager.this.getOwnJid()) || omemoDeviceListElement.getDeviceIds().contains(ourDeviceId)) continue;
                    LOGGER.log(Level.INFO, "Our deviceId was not on the list!");
                    Set<Integer> deviceListIds = omemoDeviceListElement.copyDeviceIds();
                    deviceListIds.add(ourDeviceId);
                    omemoDeviceListElement = new OmemoDeviceListVAxolotlElement(deviceListIds);
                    try {
                        OmemoService.publishDeviceIds(OmemoManager.this, omemoDeviceListElement);
                    }
                    catch (InterruptedException | SmackException | XMPPException.XMPPErrorException e) {
                        LOGGER.log(Level.SEVERE, "Could not publish our device list after an update without our id was received: " + e.getMessage());
                    }
                }
            }
        }
    };

    private OmemoManager(XMPPConnection connection, int deviceId) {
        super(connection);
        this.deviceId = deviceId;
        connection.addConnectionListener((ConnectionListener)new AbstractConnectionListener(){

            public void authenticated(XMPPConnection connection, boolean resumed) {
                if (resumed) {
                    return;
                }
                Async.go((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            OmemoManager.this.initialize();
                        }
                        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | SmackException.NotLoggedInException | XMPPException.XMPPErrorException | CorruptedOmemoKeyException | PubSubException.NotALeafNodeException e) {
                            LOGGER.log(Level.SEVERE, "connectionListener.authenticated() failed to initialize OmemoManager: " + e.getMessage());
                        }
                    }
                });
            }
        });
        this.service = OmemoService.getInstance();
    }

    public static synchronized OmemoManager getInstanceFor(XMPPConnection connection, Integer deviceId) {
        OmemoManager manager;
        WeakHashMap<Integer, OmemoManager> managersOfConnection = INSTANCES.get(connection);
        if (managersOfConnection == null) {
            managersOfConnection = new WeakHashMap();
            INSTANCES.put(connection, managersOfConnection);
        }
        if (deviceId == null || deviceId < 1) {
            deviceId = OmemoManager.randomDeviceId();
        }
        if ((manager = managersOfConnection.get(deviceId)) == null) {
            manager = new OmemoManager(connection, deviceId);
            managersOfConnection.put(deviceId, manager);
        }
        return manager;
    }

    public static synchronized OmemoManager getInstanceFor(XMPPConnection connection) {
        BareJid user;
        if (connection.getUser() != null) {
            user = connection.getUser().asBareJid();
        } else {
            try {
                user = JidCreate.bareFrom((CharSequence)((AbstractXMPPConnection)connection).getConfiguration().getUsername());
            }
            catch (XmppStringprepException e) {
                throw new AssertionError((Object)"Username is not a valid Jid. Use OmemoManager.gerInstanceFor(Connection, deviceId) instead.");
            }
        }
        int defaultDeviceId = OmemoService.getInstance().getOmemoStoreBackend().getDefaultDeviceId(user);
        if (defaultDeviceId < 1) {
            defaultDeviceId = OmemoManager.randomDeviceId();
            OmemoService.getInstance().getOmemoStoreBackend().setDefaultDeviceId(user, defaultDeviceId);
        }
        return OmemoManager.getInstanceFor(connection, defaultDeviceId);
    }

    public void initialize() throws CorruptedOmemoKeyException, InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, SmackException.NotLoggedInException, PubSubException.NotALeafNodeException {
        this.getOmemoService().initialize(this);
    }

    public Message encrypt(BareJid to, String message) throws CryptoFailedException, UndecidedOmemoIdentityException, NoSuchAlgorithmException, InterruptedException, CannotEstablishOmemoSessionException, SmackException.NotConnectedException, SmackException.NoResponseException {
        Message m = new Message();
        m.setBody(message);
        OmemoVAxolotlElement encrypted = this.getOmemoService().processSendingMessage(this, to, m);
        return this.finishMessage(encrypted);
    }

    public Message encrypt(ArrayList<BareJid> recipients, String message) throws CryptoFailedException, UndecidedOmemoIdentityException, NoSuchAlgorithmException, InterruptedException, CannotEstablishOmemoSessionException, SmackException.NotConnectedException, SmackException.NoResponseException {
        Message m = new Message();
        m.setBody(message);
        OmemoVAxolotlElement encrypted = this.getOmemoService().processSendingMessage(this, recipients, m);
        return this.finishMessage(encrypted);
    }

    public Message encrypt(MultiUserChat muc, String message) throws UndecidedOmemoIdentityException, NoSuchAlgorithmException, CryptoFailedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, NoOmemoSupportException, CannotEstablishOmemoSessionException {
        if (!this.multiUserChatSupportsOmemo(muc.getRoom())) {
            throw new NoOmemoSupportException();
        }
        Message m = new Message();
        m.setBody(message);
        ArrayList<BareJid> recipients = new ArrayList<BareJid>();
        for (EntityFullJid e : muc.getOccupants()) {
            recipients.add(muc.getOccupant(e).getJid().asBareJid());
        }
        return this.encrypt(recipients, message);
    }

    public Message encryptForExistingSessions(CannotEstablishOmemoSessionException exception, String message) throws CryptoFailedException, UndecidedOmemoIdentityException {
        Message m = new Message();
        m.setBody(message);
        OmemoVAxolotlElement encrypted = this.getOmemoService().encryptOmemoMessage(this, exception.getSuccesses(), m);
        return this.finishMessage(encrypted);
    }

    public ClearTextMessage decrypt(BareJid sender, Message omemoMessage) throws InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, CryptoFailedException, XMPPException.XMPPErrorException, CorruptedOmemoKeyException, NoRawSessionException {
        return this.getOmemoService().processLocalMessage(this, sender, omemoMessage);
    }

    public List<ClearTextMessage> decryptMamQueryResult(MamManager.MamQueryResult mamQueryResult) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        ArrayList<ClearTextMessage> l = new ArrayList<ClearTextMessage>();
        l.addAll(this.getOmemoService().decryptMamQueryResult(this, mamQueryResult));
        return l;
    }

    public void trustOmemoIdentity(OmemoDevice device, OmemoFingerprint fingerprint) {
        this.getOmemoService().getOmemoStoreBackend().trustOmemoIdentity(this, device, fingerprint);
    }

    public void distrustOmemoIdentity(OmemoDevice device, OmemoFingerprint fingerprint) {
        this.getOmemoService().getOmemoStoreBackend().distrustOmemoIdentity(this, device, fingerprint);
    }

    public boolean isTrustedOmemoIdentity(OmemoDevice device, OmemoFingerprint fingerprint) {
        return this.getOmemoService().getOmemoStoreBackend().isTrustedOmemoIdentity(this, device, fingerprint);
    }

    public boolean isDecidedOmemoIdentity(OmemoDevice device, OmemoFingerprint fingerprint) {
        return this.getOmemoService().getOmemoStoreBackend().isDecidedOmemoIdentity(this, device, fingerprint);
    }

    public void purgeDevices() throws SmackException, InterruptedException, XMPPException.XMPPErrorException, CorruptedOmemoKeyException {
        this.getOmemoService().publishDeviceIdIfNeeded(this, true);
        this.getOmemoService().publishBundle(this);
    }

    public void regenerate() throws SmackException, InterruptedException, XMPPException.XMPPErrorException, CorruptedOmemoKeyException {
        this.getOmemoService().regenerate(this, null);
        this.getOmemoService().publishDeviceIdIfNeeded(this, false);
        this.getOmemoService().publishBundle(this);
    }

    public void sendRatchetUpdateMessage(OmemoDevice recipient) throws CorruptedOmemoKeyException, UndecidedOmemoIdentityException, CryptoFailedException, CannotEstablishOmemoSessionException {
        this.getOmemoService().sendOmemoRatchetUpdateMessage(this, recipient, false);
    }

    public OmemoVAxolotlElement createKeyTransportElement(byte[] aesKey, byte[] iv, OmemoDevice ... to) throws UndecidedOmemoIdentityException, CorruptedOmemoKeyException, CryptoFailedException, CannotEstablishOmemoSessionException {
        return this.getOmemoService().prepareOmemoKeyTransportElement(this, aesKey, iv, to);
    }

    Message finishMessage(OmemoVAxolotlElement encrypted) {
        if (encrypted == null) {
            return null;
        }
        Message chatMessage = new Message();
        chatMessage.setFrom((Jid)this.connection().getUser().asBareJid());
        chatMessage.addExtension((ExtensionElement)encrypted);
        if (OmemoConfiguration.getAddOmemoHintBody()) {
            chatMessage.setBody("I sent you an OMEMO encrypted message but your client doesn\u2019t seem to support that. Find more information on https://conversations.im/omemo");
        }
        if (OmemoConfiguration.getAddMAMStorageProcessingHint()) {
            StoreHint.set((Message)chatMessage);
        }
        if (OmemoConfiguration.getAddEmeEncryptionHint()) {
            chatMessage.addExtension((ExtensionElement)new ExplicitMessageEncryptionElement("eu.siacs.conversations.axolotl", "OMEMO"));
        }
        return chatMessage;
    }

    public boolean contactSupportsOmemo(BareJid contact) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        this.getOmemoService().refreshDeviceList(this, contact);
        return !this.getOmemoService().getOmemoStoreBackend().loadCachedDeviceList(this, contact).getActiveDevices().isEmpty();
    }

    public boolean multiUserChatSupportsOmemo(EntityBareJid multiUserChat) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        RoomInfo roomInfo = MultiUserChatManager.getInstanceFor((XMPPConnection)this.connection()).getRoomInfo(multiUserChat);
        return roomInfo.isNonanonymous() && roomInfo.isMembersOnly();
    }

    public static boolean serverSupportsOmemo(XMPPConnection connection, DomainBareJid server) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).discoverInfo((Jid)server).containsFeature((CharSequence)"http://jabber.org/protocol/pubsub");
    }

    public OmemoFingerprint getOurFingerprint() {
        return this.getOmemoService().getOmemoStoreBackend().getFingerprint(this);
    }

    public OmemoFingerprint getFingerprint(OmemoDevice device) throws CannotEstablishOmemoSessionException {
        if (device.equals(this.getOwnDevice())) {
            return this.getOurFingerprint();
        }
        return this.getOmemoService().getOmemoStoreBackend().getFingerprint(this, device);
    }

    public HashMap<OmemoDevice, OmemoFingerprint> getActiveFingerprints(BareJid contact) {
        HashMap<OmemoDevice, OmemoFingerprint> fingerprints = new HashMap<OmemoDevice, OmemoFingerprint>();
        CachedDeviceList deviceList = this.getOmemoService().getOmemoStoreBackend().loadCachedDeviceList(this, contact);
        for (int id : deviceList.getActiveDevices()) {
            OmemoDevice device = new OmemoDevice(contact, id);
            OmemoFingerprint fingerprint = null;
            try {
                fingerprint = this.getFingerprint(device);
            }
            catch (CannotEstablishOmemoSessionException e) {
                LOGGER.log(Level.WARNING, "Could not build session with device " + id + " of user " + contact + ": " + e.getMessage());
            }
            if (fingerprint == null) continue;
            fingerprints.put(device, fingerprint);
        }
        return fingerprints;
    }

    public void addOmemoMessageListener(OmemoMessageListener listener) {
        this.omemoMessageListeners.add(listener);
    }

    public void removeOmemoMessageListener(OmemoMessageListener listener) {
        this.omemoMessageListeners.remove(listener);
    }

    public void addOmemoMucMessageListener(OmemoMucMessageListener listener) {
        this.omemoMucMessageListeners.add(listener);
    }

    public void removeOmemoMucMessageListener(OmemoMucMessageListener listener) {
        this.omemoMucMessageListeners.remove(listener);
    }

    public void buildSessionsWith(BareJid contact) throws InterruptedException, CannotEstablishOmemoSessionException, SmackException.NotConnectedException, SmackException.NoResponseException {
        this.getOmemoService().buildOrCreateOmemoSessionsFromBundles(this, contact);
    }

    public void requestDeviceListUpdateFor(BareJid contact) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        this.getOmemoService().refreshDeviceList(this, contact);
    }

    public void rotateSignedPreKey() throws CorruptedOmemoKeyException, InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, PubSubException.NotALeafNodeException {
        this.getOmemoService().getOmemoStoreBackend().changeSignedPreKey(this);
        this.getOmemoService().publishDeviceIdIfNeeded(this, false);
        this.getOmemoService().publishBundle(this);
    }

    public static boolean stanzaContainsOmemoElement(Stanza stanza) {
        return stanza.hasExtension("encrypted", "eu.siacs.conversations.axolotl");
    }

    private void throwIfNoServiceSet() {
        if (this.service == null) {
            throw new IllegalStateException("No OmemoService set in OmemoManager.");
        }
    }

    public static int randomDeviceId() {
        int i = new Random().nextInt(Integer.MAX_VALUE);
        if (i == 0) {
            return OmemoManager.randomDeviceId();
        }
        return Math.abs(i);
    }

    public BareJid getOwnJid() {
        EntityFullJid fullJid = this.connection().getUser();
        if (fullJid == null) {
            return null;
        }
        return fullJid.asBareJid();
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public OmemoDevice getOwnDevice() {
        return new OmemoDevice(this.getOwnJid(), this.getDeviceId());
    }

    void setDeviceId(int nDeviceId) {
        INSTANCES.get(this.connection()).remove(this.getDeviceId());
        INSTANCES.get(this.connection()).put(nDeviceId, this);
        this.deviceId = nDeviceId;
    }

    void notifyOmemoMessageReceived(String decryptedBody, Message encryptedMessage, Message wrappingMessage, OmemoMessageInformation messageInformation) {
        for (OmemoMessageListener l : this.omemoMessageListeners) {
            l.onOmemoMessageReceived(decryptedBody, encryptedMessage, wrappingMessage, messageInformation);
        }
    }

    void notifyOmemoKeyTransportMessageReceived(CipherAndAuthTag cipherAndAuthTag, Message transportingMessage, Message wrappingMessage, OmemoMessageInformation information) {
        for (OmemoMessageListener l : this.omemoMessageListeners) {
            l.onOmemoKeyTransportReceived(cipherAndAuthTag, transportingMessage, wrappingMessage, information);
        }
    }

    void notifyOmemoMucMessageReceived(MultiUserChat muc, BareJid from, String decryptedBody, Message message, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
        for (OmemoMucMessageListener l : this.omemoMucMessageListeners) {
            l.onOmemoMucMessageReceived(muc, from, decryptedBody, message, wrappingMessage, omemoInformation);
        }
    }

    void notifyOmemoMucKeyTransportMessageReceived(MultiUserChat muc, BareJid from, CipherAndAuthTag cipherAndAuthTag, Message transportingMessage, Message wrappingMessage, OmemoMessageInformation messageInformation) {
        for (OmemoMucMessageListener l : this.omemoMucMessageListeners) {
            l.onOmemoKeyTransportReceived(muc, from, cipherAndAuthTag, transportingMessage, wrappingMessage, messageInformation);
        }
    }

    public void shutdown() {
        PEPManager.getInstanceFor((XMPPConnection)this.connection()).removePEPListener(this.deviceListUpdateListener);
        this.connection().removeAsyncStanzaListener((StanzaListener)this.omemoStanzaListener);
        CarbonManager.getInstanceFor((XMPPConnection)this.connection()).removeCarbonCopyReceivedListener((CarbonCopyReceivedListener)this.omemoCarbonCopyListener);
    }

    XMPPConnection getConnection() {
        return this.connection();
    }

    OmemoService<?, ?, ?, ?, ?, ?, ?, ?, ?> getOmemoService() {
        this.throwIfNoServiceSet();
        return this.service;
    }

    OmemoService.OmemoStanzaListener getOmemoStanzaListener() {
        if (this.omemoStanzaListener == null) {
            this.omemoStanzaListener = this.getOmemoService().createStanzaListener(this);
        }
        return this.omemoStanzaListener;
    }

    OmemoService.OmemoCarbonCopyListener getOmemoCarbonCopyListener() {
        if (this.omemoCarbonCopyListener == null) {
            this.omemoCarbonCopyListener = this.getOmemoService().createOmemoCarbonCopyListener(this);
        }
        return this.omemoCarbonCopyListener;
    }
}

