/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smackx.omemo.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.element.OmemoBundleVAxolotlElement;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.internal.OmemoSession;
import org.jxmpp.stringprep.XmppStringprepException;

public abstract class OmemoKeyUtil<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    private static final Logger LOGGER = Logger.getLogger(OmemoKeyUtil.class.getName());
    public final Bundle BUNDLE = new Bundle();

    public abstract T_IdKeyPair identityKeyPairFromBytes(byte[] var1) throws CorruptedOmemoKeyException;

    public abstract T_IdKey identityKeyFromBytes(byte[] var1) throws CorruptedOmemoKeyException;

    public abstract byte[] identityKeyToBytes(T_IdKey var1);

    public abstract T_ECPub ellipticCurvePublicKeyFromBytes(byte[] var1) throws CorruptedOmemoKeyException;

    public T_ECPub preKeyPublicFromBytes(byte[] data) throws CorruptedOmemoKeyException {
        return this.ellipticCurvePublicKeyFromBytes(data);
    }

    public abstract byte[] preKeyToBytes(T_PreKey var1);

    public abstract T_PreKey preKeyFromBytes(byte[] var1) throws IOException;

    public abstract HashMap<Integer, T_PreKey> generateOmemoPreKeys(int var1, int var2);

    public abstract T_SigPreKey generateOmemoSignedPreKey(T_IdKeyPair var1, int var2) throws CorruptedOmemoKeyException;

    public T_ECPub signedPreKeyPublicFromBytes(byte[] data) throws CorruptedOmemoKeyException {
        return this.ellipticCurvePublicKeyFromBytes(data);
    }

    public abstract T_SigPreKey signedPreKeyFromBytes(byte[] var1) throws IOException;

    public abstract byte[] signedPreKeyToBytes(T_SigPreKey var1);

    public abstract T_Bundle bundleFromOmemoBundle(OmemoBundleVAxolotlElement var1, OmemoDevice var2, int var3) throws CorruptedOmemoKeyException;

    public abstract byte[] signedPreKeySignatureFromKey(T_SigPreKey var1);

    public abstract T_IdKeyPair generateOmemoIdentityKeyPair();

    public abstract int signedPreKeyIdFromKey(T_SigPreKey var1);

    public abstract byte[] identityKeyPairToBytes(T_IdKeyPair var1);

    public abstract T_IdKey identityKeyFromPair(T_IdKeyPair var1);

    public abstract byte[] identityKeyForBundle(T_IdKey var1);

    public abstract byte[] preKeyPublicKeyForBundle(T_ECPub var1);

    public abstract byte[] preKeyForBundle(T_PreKey var1);

    public HashMap<Integer, byte[]> preKeyPublisKeysForBundle(HashMap<Integer, T_PreKey> preKeyHashMap) {
        HashMap<Integer, byte[]> out = new HashMap<Integer, byte[]>();
        for (Map.Entry<Integer, T_PreKey> e : preKeyHashMap.entrySet()) {
            out.put(e.getKey(), this.preKeyForBundle(e.getValue()));
        }
        return out;
    }

    public abstract byte[] signedPreKeyPublicForBundle(T_SigPreKey var1);

    public abstract OmemoFingerprint getFingerprint(T_IdKey var1);

    public abstract OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> createOmemoSession(OmemoManager var1, OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> var2, OmemoDevice var3);

    public abstract OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> createOmemoSession(OmemoManager var1, OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> var2, OmemoDevice var3, T_IdKey var4);

    public abstract T_Sess rawSessionFromBytes(byte[] var1) throws IOException;

    public abstract byte[] rawSessionToBytes(T_Sess var1);

    public abstract T_Addr omemoDeviceAsAddress(OmemoDevice var1);

    public abstract OmemoDevice addressAsOmemoDevice(T_Addr var1) throws XmppStringprepException;

    public static String prettyFingerprint(OmemoFingerprint fingerprint) {
        return OmemoKeyUtil.prettyFingerprint(fingerprint.toString());
    }

    public static String prettyFingerprint(String ugly) {
        if (ugly == null) {
            return null;
        }
        String pretty = "";
        for (int i = 0; i < 8; ++i) {
            if (i != 0) {
                pretty = pretty + " ";
            }
            pretty = pretty + ugly.substring(8 * i, 8 * (i + 1));
        }
        return pretty;
    }

    public static int addInBounds(int value, int added) {
        int avail = Integer.MAX_VALUE - value;
        if (avail < added) {
            return added - avail;
        }
        return value + added;
    }

    public class Bundle {
        public T_IdKey identityKey(OmemoBundleVAxolotlElement bundle) throws CorruptedOmemoKeyException {
            return OmemoKeyUtil.this.identityKeyFromBytes(bundle.getIdentityKey());
        }

        public T_ECPub signedPreKeyPublic(OmemoBundleVAxolotlElement bundle) throws CorruptedOmemoKeyException {
            return OmemoKeyUtil.this.signedPreKeyPublicFromBytes(bundle.getSignedPreKey());
        }

        public int signedPreKeyId(OmemoBundleVAxolotlElement bundle) {
            return bundle.getSignedPreKeyId();
        }

        public byte[] signedPreKeySignature(OmemoBundleVAxolotlElement bundle) {
            return bundle.getSignedPreKeySignature();
        }

        public T_ECPub preKeyPublic(OmemoBundleVAxolotlElement bundle, int keyId) throws CorruptedOmemoKeyException {
            return OmemoKeyUtil.this.preKeyPublicFromBytes(bundle.getPreKey(keyId));
        }

        public HashMap<Integer, T_Bundle> bundles(OmemoBundleVAxolotlElement bundle, OmemoDevice contact) throws CorruptedOmemoKeyException {
            HashMap bundles = new HashMap();
            for (int deviceId : bundle.getPreKeys().keySet()) {
                try {
                    bundles.put(deviceId, OmemoKeyUtil.this.bundleFromOmemoBundle(bundle, contact, deviceId));
                }
                catch (CorruptedOmemoKeyException e) {
                    LOGGER.log(Level.INFO, "Cannot parse PreKeyBundle: " + e.getMessage());
                }
            }
            if (bundles.size() == 0) {
                throw new CorruptedOmemoKeyException("Bundle contained no valid preKeys.");
            }
            return bundles;
        }
    }
}

