/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.httpfileupload.element;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.jivesoftware.smack.packet.IQ;

public class Slot
extends IQ {
    public static final String ELEMENT = "slot";
    public static final String NAMESPACE = "urn:xmpp:http:upload:0";
    private final URL putUrl;
    private final URL getUrl;
    private final Map<String, String> headers;

    public Slot(URL putUrl, URL getUrl) {
        this(putUrl, getUrl, null);
    }

    public Slot(URL putUrl, URL getUrl, Map<String, String> headers) {
        this(putUrl, getUrl, headers, NAMESPACE);
    }

    protected Slot(URL putUrl, URL getUrl, Map<String, String> headers, String namespace) {
        super(ELEMENT, namespace);
        this.setType(IQ.Type.result);
        this.putUrl = putUrl;
        this.getUrl = getUrl;
        this.headers = headers == null ? Collections.emptyMap() : Collections.unmodifiableMap(headers);
    }

    public URL getPutUrl() {
        return this.putUrl;
    }

    public URL getGetUrl() {
        return this.getUrl;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.rightAngleBracket();
        xml.element("put", this.putUrl.toString());
        xml.element("get", this.getUrl.toString());
        for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
            xml.openElement("header").attribute(entry.getKey(), entry.getValue());
        }
        return xml;
    }
}

