/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.util.logging.Level;
import junit.framework.TestCase;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.omemo.AbstractOmemoIntegrationTest;
import org.jivesoftware.smackx.omemo.OmemoIntegrationTestHelper;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.internal.CipherAndAuthTag;
import org.jivesoftware.smackx.omemo.internal.OmemoMessageInformation;
import org.jivesoftware.smackx.omemo.listener.OmemoMessageListener;

public class OmemoSessionRenegotiationTest
extends AbstractOmemoIntegrationTest {
    private OmemoManager alice;
    private OmemoManager bob;
    private OmemoStore<?, ?, ?, ?, ?, ?, ?, ?, ?> store;

    public OmemoSessionRenegotiationTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, TestNotPossibleException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        super(environment);
    }

    @Override
    public void before() {
        this.alice = OmemoManager.getInstanceFor((XMPPConnection)this.conOne, (Integer)1337);
        this.bob = OmemoManager.getInstanceFor((XMPPConnection)this.conTwo, (Integer)1009);
        this.store = OmemoService.getInstance().getOmemoStoreBackend();
    }

    @SmackIntegrationTest
    public void sessionRenegotiationTest() throws Exception {
        boolean[] phaseTwo = new boolean[1];
        final SimpleResultSyncPoint sp1 = new SimpleResultSyncPoint();
        final SimpleResultSyncPoint sp2 = new SimpleResultSyncPoint();
        final SimpleResultSyncPoint sp3 = new SimpleResultSyncPoint();
        final SimpleResultSyncPoint sp4 = new SimpleResultSyncPoint();
        String m1 = "1: Alice says hello to bob.";
        String m2 = "2: Bob replies to Alice.";
        String m3 = "3. This message will arrive but Bob cannot decrypt it.";
        String m4 = "4. This message is readable by Bob again.";
        OmemoIntegrationTestHelper.subscribe(this.alice, this.bob, "Bob");
        OmemoIntegrationTestHelper.subscribe(this.bob, this.alice, "Alice");
        OmemoIntegrationTestHelper.setUpOmemoManager(this.alice);
        OmemoIntegrationTestHelper.setUpOmemoManager(this.bob);
        OmemoIntegrationTestHelper.unidirectionalTrust(this.alice, this.bob);
        OmemoIntegrationTestHelper.unidirectionalTrust(this.bob, this.alice);
        OmemoMessageListener first = new OmemoMessageListener(){

            public void onOmemoMessageReceived(String decryptedBody, Message encryptedMessage, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
                LOGGER.log(Level.INFO, "Bob received OMEMO message: " + decryptedBody);
                TestCase.assertEquals((String)"Received message MUST match the one we sent.", (String)decryptedBody, (String)"1: Alice says hello to bob.");
                sp1.signal();
            }

            public void onOmemoKeyTransportReceived(CipherAndAuthTag cipherAndAuthTag, Message message, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
            }
        };
        this.bob.addOmemoMessageListener(first);
        ChatManager.getInstanceFor((XMPPConnection)this.alice.getConnection()).chatWith(this.bob.getOwnJid().asEntityBareJidIfPossible()).send(this.alice.encrypt(this.bob.getOwnJid(), "1: Alice says hello to bob."));
        sp1.waitForResult(10000L);
        this.bob.removeOmemoMessageListener(first);
        OmemoMessageListener second = new OmemoMessageListener(){

            public void onOmemoMessageReceived(String decryptedBody, Message encryptedMessage, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
                LOGGER.log(Level.INFO, "Alice received OMEMO message: " + decryptedBody);
                TestCase.assertEquals((String)"Reply must match the messagewe sent.", (String)decryptedBody, (String)"2: Bob replies to Alice.");
                sp2.signal();
            }

            public void onOmemoKeyTransportReceived(CipherAndAuthTag cipherAndAuthTag, Message message, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
            }
        };
        this.alice.addOmemoMessageListener(second);
        ChatManager.getInstanceFor((XMPPConnection)this.bob.getConnection()).chatWith(this.alice.getOwnJid().asEntityBareJidIfPossible()).send(this.bob.encrypt(this.alice.getOwnJid(), "2: Bob replies to Alice."));
        sp2.waitForResult(10000L);
        this.alice.removeOmemoMessageListener(second);
        this.store.forgetOmemoSessions(this.bob);
        this.store.removeAllRawSessionsOf(this.bob, this.alice.getOwnJid());
        OmemoMessageListener third = new OmemoMessageListener(){

            public void onOmemoMessageReceived(String decryptedBody, Message encryptedMessage, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
                TestCase.fail((String)("Bob should not have received a decipherable message: " + decryptedBody));
            }

            public void onOmemoKeyTransportReceived(CipherAndAuthTag cipherAndAuthTag, Message message, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
            }
        };
        this.bob.addOmemoMessageListener(third);
        OmemoMessageListener fourth = new OmemoMessageListener(){

            public void onOmemoMessageReceived(String decryptedBody, Message encryptedMessage, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
            }

            public void onOmemoKeyTransportReceived(CipherAndAuthTag cipherAndAuthTag, Message message, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
                LOGGER.log(Level.INFO, "Alice received preKeyMessage.");
                sp3.signal();
            }
        };
        this.alice.addOmemoMessageListener(fourth);
        ChatManager.getInstanceFor((XMPPConnection)this.alice.getConnection()).chatWith(this.bob.getOwnJid().asEntityBareJidIfPossible()).send(this.alice.encrypt(this.bob.getOwnJid(), "3. This message will arrive but Bob cannot decrypt it."));
        sp3.waitForResult(10000L);
        this.bob.removeOmemoMessageListener(third);
        this.alice.removeOmemoMessageListener(fourth);
        OmemoMessageListener fifth = new OmemoMessageListener(){

            public void onOmemoMessageReceived(String decryptedBody, Message encryptedMessage, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
                LOGGER.log(Level.INFO, "Bob received an OMEMO message: " + decryptedBody);
                TestCase.assertEquals((String)"The received message must match the one we sent.", (String)decryptedBody, (String)"4. This message is readable by Bob again.");
                sp4.signal();
            }

            public void onOmemoKeyTransportReceived(CipherAndAuthTag cipherAndAuthTag, Message message, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
            }
        };
        this.bob.addOmemoMessageListener(fifth);
        ChatManager.getInstanceFor((XMPPConnection)this.alice.getConnection()).chatWith(this.bob.getOwnJid().asEntityBareJidIfPossible()).send(this.alice.encrypt(this.bob.getOwnJid(), "4. This message is readable by Bob again."));
        sp4.waitForResult(10000L);
    }

    @Override
    public void after() {
        this.alice.shutdown();
        this.bob.shutdown();
        OmemoIntegrationTestHelper.cleanServerSideTraces(this.alice);
        OmemoIntegrationTestHelper.cleanServerSideTraces(this.bob);
    }
}

