/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;

class CloseListener
extends AbstractIqRequestHandler {
    private final InBandBytestreamManager manager;

    protected CloseListener(InBandBytestreamManager manager) {
        super("close", "http://jabber.org/protocol/ibb", IQ.Type.set, IQRequestHandler.Mode.async);
        this.manager = manager;
    }

    public IQ handleIQRequest(IQ iqRequest) {
        Close closeRequest = (Close)iqRequest;
        InBandBytestreamSession ibbSession = this.manager.getSessions().get(closeRequest.getSessionID());
        if (ibbSession == null) {
            try {
                this.manager.replyItemNotFoundPacket(closeRequest);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                return null;
            }
        }
        try {
            ibbSession.closeByPeer(closeRequest);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            return null;
        }
        this.manager.getSessions().remove(closeRequest.getSessionID());
        return null;
    }
}

