/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.igniterealtime.smack.inttest.Configuration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;

public abstract class AbstractSmackIntTest {
    protected static final Logger LOGGER = Logger.getLogger(AbstractSmackIntTest.class.getName());
    protected static final Random INSECURE_RANDOM = new Random();
    protected final String testRunId;
    protected final long timeout;
    protected final Configuration sinttestConfiguration;

    protected AbstractSmackIntTest(String testRunId, Configuration configuration) {
        this.testRunId = testRunId;
        this.sinttestConfiguration = configuration;
        this.timeout = configuration.replyTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performActionAndWaitUntilStanzaReceived(Runnable action, XMPPConnection connection, StanzaFilter filter) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        StanzaCollector.Configuration configuration = StanzaCollector.newConfiguration().setStanzaFilter(filter).setSize(1);
        StanzaCollector collector = connection.createStanzaCollector(configuration);
        try {
            action.run();
            collector.nextResultOrThrow(this.timeout);
        }
        finally {
            collector.cancel();
        }
    }

    protected void waitUntilTrue(Condition condition) throws TimeoutException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        long deadline = System.currentTimeMillis() + this.timeout;
        do {
            if (condition.evaluate()) {
                return;
            }
            Thread.yield();
        } while (System.currentTimeMillis() <= deadline);
        throw new TimeoutException("Timeout waiting for condition to become true. Timeout was " + this.timeout + " ms.");
    }

    protected File createNewTempFile() throws IOException {
        File file = File.createTempFile("smack-integration-test-" + this.testRunId + "-temp-file", null);
        file.deleteOnExit();
        return file;
    }

    protected HttpURLConnection getHttpUrlConnectionFor(URL url) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        if (this.sinttestConfiguration.tlsContext != null && urlConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsUrlConnection = (HttpsURLConnection)urlConnection;
            httpsUrlConnection.setSSLSocketFactory(this.sinttestConfiguration.tlsContext.getSocketFactory());
        }
        return urlConnection;
    }

    protected static interface Condition {
        public boolean evaluate() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException;
    }
}

