/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import junit.framework.TestCase;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.omemo.AbstractOmemoIntegrationTest;
import org.jivesoftware.smackx.omemo.OmemoIntegrationTestHelper;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.element.OmemoBundleVAxolotlElement;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.internal.CipherAndAuthTag;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.internal.OmemoMessageInformation;
import org.jivesoftware.smackx.omemo.listener.OmemoMessageListener;
import org.jivesoftware.smackx.pubsub.PubSubException;

public class OmemoMessageSendingTest
extends AbstractOmemoIntegrationTest {
    private OmemoManager alice;
    private OmemoManager bob;
    private OmemoStore<?, ?, ?, ?, ?, ?, ?, ?, ?> store;

    public OmemoMessageSendingTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, TestNotPossibleException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        super(environment);
    }

    @Override
    public void before() {
        this.alice = OmemoManager.getInstanceFor((XMPPConnection)this.conOne, (Integer)123);
        this.bob = OmemoManager.getInstanceFor((XMPPConnection)this.conTwo, (Integer)345);
        this.store = OmemoService.getInstance().getOmemoStoreBackend();
    }

    @SmackIntegrationTest
    public void messageSendingTest() throws CorruptedOmemoKeyException, InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, SmackException.NotLoggedInException, PubSubException.NotALeafNodeException, CannotEstablishOmemoSessionException, UndecidedOmemoIdentityException, NoSuchAlgorithmException, CryptoFailedException, PubSubException.NotAPubSubNodeException {
        String alicesSecret = "Hey Bob! I love you!";
        String bobsSecret = "I love you too, Alice.";
        final SimpleResultSyncPoint messageOneSyncPoint = new SimpleResultSyncPoint();
        final SimpleResultSyncPoint messageTwoSyncPoint = new SimpleResultSyncPoint();
        OmemoIntegrationTestHelper.subscribe(this.alice, this.bob, "Bob");
        OmemoIntegrationTestHelper.subscribe(this.bob, this.alice, "Alice");
        OmemoIntegrationTestHelper.setUpOmemoManager(this.alice);
        OmemoIntegrationTestHelper.setUpOmemoManager(this.bob);
        OmemoBundleVAxolotlElement aliceBundle = this.store.packOmemoBundle(this.alice);
        OmemoBundleVAxolotlElement bobsBundle = this.store.packOmemoBundle(this.bob);
        OmemoIntegrationTestHelper.unidirectionalTrust(this.alice, this.bob);
        OmemoIntegrationTestHelper.unidirectionalTrust(this.bob, this.alice);
        this.bob.addOmemoMessageListener(new OmemoMessageListener(){

            public void onOmemoMessageReceived(String decryptedBody, Message encryptedMessage, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
                LOGGER.log(Level.INFO, "Bob received message: " + decryptedBody);
                if (decryptedBody.trim().equals("Hey Bob! I love you!".trim())) {
                    messageOneSyncPoint.signal();
                } else {
                    messageOneSyncPoint.signal(new Exception("Received message must equal sent message."));
                }
            }

            public void onOmemoKeyTransportReceived(CipherAndAuthTag cipherAndAuthTag, Message message, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
            }
        });
        this.alice.addOmemoMessageListener(new OmemoMessageListener(){

            public void onOmemoMessageReceived(String decryptedBody, Message encryptedMessage, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
                LOGGER.log(Level.INFO, "Alice received message: " + decryptedBody);
                if (decryptedBody.trim().equals("I love you too, Alice.".trim())) {
                    messageTwoSyncPoint.signal();
                } else {
                    messageTwoSyncPoint.signal(new Exception("Received message must equal sent message."));
                }
            }

            public void onOmemoKeyTransportReceived(CipherAndAuthTag cipherAndAuthTag, Message message, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
            }
        });
        Message encryptedA = this.alice.encrypt(this.bob.getOwnJid(), "Hey Bob! I love you!");
        ChatManager.getInstanceFor((XMPPConnection)this.alice.getConnection()).chatWith(this.bob.getOwnJid().asEntityBareJidIfPossible()).send(encryptedA);
        try {
            messageOneSyncPoint.waitForResult(10000L);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while waiting for message: " + e, e);
            TestCase.fail((String)"Bob must have received Alice message.");
        }
        TestCase.assertNotSame((String)"Bob must have published another bundle at this point, since we used a PreKeyMessage.", (Object)bobsBundle, (Object)OmemoService.fetchBundle((OmemoManager)this.alice, (OmemoDevice)this.bob.getOwnDevice()));
        Message encryptedB = this.bob.encrypt(this.alice.getOwnJid(), "I love you too, Alice.");
        ChatManager.getInstanceFor((XMPPConnection)this.bob.getConnection()).chatWith(this.alice.getOwnJid().asEntityBareJidIfPossible()).send(encryptedB);
        try {
            messageTwoSyncPoint.waitForResult(10000L);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while waiting for response: " + e, e);
            TestCase.fail((String)"Alice must have received a response from Bob.");
        }
        TestCase.assertEquals((String)"Alice must not have published a new bundle, since we built the session using Bobs bundle.", (Object)aliceBundle, (Object)OmemoService.fetchBundle((OmemoManager)this.bob, (OmemoDevice)this.alice.getOwnDevice()));
    }

    @Override
    public void after() {
        this.alice.shutdown();
        this.bob.shutdown();
        OmemoIntegrationTestHelper.cleanServerSideTraces(this.alice);
        OmemoIntegrationTestHelper.cleanServerSideTraces(this.bob);
    }
}

