/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps.provider;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smackx.caps.packet.CapsExtension;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class CapsExtensionProvider
extends ExtensionElementProvider<CapsExtension> {
    public CapsExtension parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        if (parser.getEventType() != 2 || !parser.getName().equalsIgnoreCase("c")) {
            throw new SmackException("Malformed Caps element");
        }
        String hash = parser.getAttributeValue(null, "hash");
        String version = parser.getAttributeValue(null, "ver");
        String node = parser.getAttributeValue(null, "node");
        parser.next();
        if (parser.getEventType() != 3 || !parser.getName().equalsIgnoreCase("c")) {
            throw new SmackException("Malformed nested Caps element");
        }
        if (hash != null && version != null && node != null) {
            return new CapsExtension(node, version, hash);
        }
        throw new SmackException("Caps element with missing attributes. Attributes: hash=" + hash + " version=" + version + " node=" + node);
    }
}

