/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.internal;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;

public class CipherAndAuthTag {
    private final byte[] key;
    private final byte[] iv;
    private final byte[] authTag;

    public CipherAndAuthTag(byte[] key, byte[] iv, byte[] authTag) throws CryptoFailedException {
        this.authTag = authTag;
        this.key = key;
        this.iv = iv;
    }

    public Cipher getCipher() throws CryptoFailedException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
            SecretKeySpec keySpec = new SecretKeySpec(this.key, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(this.iv);
            cipher.init(2, (Key)keySpec, ivSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new CryptoFailedException(e);
        }
        return cipher;
    }

    public byte[] getAuthTag() {
        if (this.authTag != null) {
            return (byte[])this.authTag.clone();
        }
        return null;
    }

    public byte[] getKey() {
        if (this.key != null) {
            return (byte[])this.key.clone();
        }
        return null;
    }

    public byte[] getIv() {
        if (this.iv != null) {
            return (byte[])this.iv.clone();
        }
        return null;
    }
}

