/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.LocalCommand;
import org.jivesoftware.smackx.commands.LocalCommandFactory;
import org.jivesoftware.smackx.commands.RemoteCommand;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.Form;
import org.jxmpp.jid.Jid;

public final class AdHocCommandManager
extends Manager {
    public static final String NAMESPACE = "http://jabber.org/protocol/commands";
    private static final Logger LOGGER = Logger.getLogger(AdHocCommandManager.class.getName());
    private static final int SESSION_TIMEOUT = 120;
    private static Map<XMPPConnection, AdHocCommandManager> instances = new WeakHashMap<XMPPConnection, AdHocCommandManager>();
    private final Map<String, AdHocCommandInfo> commands = new ConcurrentHashMap<String, AdHocCommandInfo>();
    private final Map<String, LocalCommand> executingCommands = new ConcurrentHashMap<String, LocalCommand>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private Thread sessionsSweeper;

    public static synchronized AdHocCommandManager getAddHocCommandsManager(XMPPConnection connection) {
        AdHocCommandManager ahcm = instances.get(connection);
        if (ahcm == null) {
            ahcm = new AdHocCommandManager(connection);
            instances.put(connection, ahcm);
        }
        return ahcm;
    }

    private AdHocCommandManager(XMPPConnection connection) {
        super(connection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        ServiceDiscoveryManager.getInstanceFor(connection).addFeature(NAMESPACE);
        ServiceDiscoveryManager.getInstanceFor(connection).setNodeInformationProvider(NAMESPACE, new AbstractNodeInformationProvider(){

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                ArrayList<DiscoverItems.Item> answer = new ArrayList<DiscoverItems.Item>();
                Collection commandsList = AdHocCommandManager.this.getRegisteredCommands();
                for (AdHocCommandInfo info : commandsList) {
                    DiscoverItems.Item item = new DiscoverItems.Item(info.getOwnerJID());
                    item.setName(info.getName());
                    item.setNode(info.getNode());
                    answer.add(item);
                }
                return answer;
            }
        });
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("command", NAMESPACE, IQ.Type.set, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                AdHocCommandData requestData = (AdHocCommandData)iqRequest;
                try {
                    return AdHocCommandManager.this.processAdHocCommand(requestData);
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
                    LOGGER.log(Level.INFO, "processAdHocCommand threw exceptino", e);
                    return null;
                }
            }
        });
        this.sessionsSweeper = null;
    }

    public void registerCommand(String node, String name, final Class<? extends LocalCommand> clazz) {
        this.registerCommand(node, name, new LocalCommandFactory(){

            @Override
            public LocalCommand getInstance() throws InstantiationException, IllegalAccessException {
                try {
                    return (LocalCommand)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    public void registerCommand(String node, final String name, LocalCommandFactory factory) {
        AdHocCommandInfo commandInfo = new AdHocCommandInfo(node, name, (Jid)this.connection().getUser(), factory);
        this.commands.put(node, commandInfo);
        this.serviceDiscoveryManager.setNodeInformationProvider(node, new AbstractNodeInformationProvider(){

            @Override
            public List<String> getNodeFeatures() {
                ArrayList<String> answer = new ArrayList<String>();
                answer.add(AdHocCommandManager.NAMESPACE);
                answer.add("jabber:x:data");
                return answer;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                ArrayList<DiscoverInfo.Identity> answer = new ArrayList<DiscoverInfo.Identity>();
                DiscoverInfo.Identity identity = new DiscoverInfo.Identity("automation", name, "command-node");
                answer.add(identity);
                return answer;
            }
        });
    }

    public DiscoverItems discoverCommands(Jid jid) throws XMPPException, SmackException, InterruptedException {
        return this.serviceDiscoveryManager.discoverItems(jid, NAMESPACE);
    }

    @Deprecated
    public void publishCommands(Jid jid) throws XMPPException, SmackException, InterruptedException {
        DiscoverItems discoverItems = new DiscoverItems();
        Collection<AdHocCommandInfo> xCommandsList = this.getRegisteredCommands();
        for (AdHocCommandInfo info : xCommandsList) {
            DiscoverItems.Item item = new DiscoverItems.Item(info.getOwnerJID());
            item.setName(info.getName());
            item.setNode(info.getNode());
            discoverItems.addItem(item);
        }
        this.serviceDiscoveryManager.publishItems(jid, NAMESPACE, discoverItems);
    }

    public RemoteCommand getRemoteCommand(Jid jid, String node) {
        return new RemoteCommand(this.connection(), node, jid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQ processAdHocCommand(AdHocCommandData requestData) throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        AdHocCommandData response = new AdHocCommandData();
        response.setTo(requestData.getFrom());
        response.setStanzaId(requestData.getStanzaId());
        response.setNode(requestData.getNode());
        response.setId(requestData.getTo());
        String sessionId = requestData.getSessionID();
        String commandNode = requestData.getNode();
        if (sessionId == null) {
            if (!this.commands.containsKey(commandNode)) {
                return AdHocCommandManager.respondError(response, XMPPError.Condition.item_not_found);
            }
            sessionId = StringUtils.randomString((int)15);
            try {
                LocalCommand command = this.newInstanceOfCmd(commandNode, sessionId);
                response.setType(IQ.Type.result);
                command.setData(response);
                if (!command.hasPermission(requestData.getFrom())) {
                    return AdHocCommandManager.respondError(response, XMPPError.Condition.forbidden);
                }
                AdHocCommand.Action action = requestData.getAction();
                if (action != null && action.equals((Object)AdHocCommand.Action.unknown)) {
                    return AdHocCommandManager.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.malformedAction);
                }
                if (action != null && !action.equals((Object)AdHocCommand.Action.execute)) {
                    return AdHocCommandManager.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badAction);
                }
                command.incrementStage();
                command.execute();
                if (command.isLastStage()) {
                    response.setStatus(AdHocCommand.Status.completed);
                } else {
                    response.setStatus(AdHocCommand.Status.executing);
                    this.executingCommands.put(sessionId, command);
                    if (this.sessionsSweeper == null) {
                        this.sessionsSweeper = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                while (true) {
                                    for (String sessionId : AdHocCommandManager.this.executingCommands.keySet()) {
                                        LocalCommand command = (LocalCommand)AdHocCommandManager.this.executingCommands.get(sessionId);
                                        if (command == null) continue;
                                        long creationStamp = command.getCreationDate();
                                        if (System.currentTimeMillis() - creationStamp <= 240000L) continue;
                                        AdHocCommandManager.this.executingCommands.remove(sessionId);
                                    }
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                    }
                                }
                            }
                        });
                        this.sessionsSweeper.setDaemon(true);
                        this.sessionsSweeper.start();
                    }
                }
                return response;
            }
            catch (XMPPException.XMPPErrorException e) {
                XMPPError error = e.getXMPPError();
                if (XMPPError.Type.CANCEL.equals((Object)error.getType())) {
                    response.setStatus(AdHocCommand.Status.canceled);
                    this.executingCommands.remove(sessionId);
                }
                return AdHocCommandManager.respondError(response, XMPPError.getBuilder((XMPPError)error));
            }
        }
        LocalCommand command = this.executingCommands.get(sessionId);
        if (command == null) {
            return AdHocCommandManager.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badSessionid);
        }
        long creationStamp = command.getCreationDate();
        if (System.currentTimeMillis() - creationStamp > 120000L) {
            this.executingCommands.remove(sessionId);
            return AdHocCommandManager.respondError(response, XMPPError.Condition.not_allowed, AdHocCommand.SpecificErrorCondition.sessionExpired);
        }
        LocalCommand localCommand = command;
        synchronized (localCommand) {
            AdHocCommand.Action action = requestData.getAction();
            if (action != null && action.equals((Object)AdHocCommand.Action.unknown)) {
                return AdHocCommandManager.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.malformedAction);
            }
            if (action == null || AdHocCommand.Action.execute.equals((Object)action)) {
                action = command.getExecuteAction();
            }
            if (!command.isValidAction(action)) {
                return AdHocCommandManager.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badAction);
            }
            try {
                response.setType(IQ.Type.result);
                command.setData(response);
                if (AdHocCommand.Action.next.equals((Object)action)) {
                    command.incrementStage();
                    command.next(new Form(requestData.getForm()));
                    if (command.isLastStage()) {
                        response.setStatus(AdHocCommand.Status.completed);
                    } else {
                        response.setStatus(AdHocCommand.Status.executing);
                    }
                } else if (AdHocCommand.Action.complete.equals((Object)action)) {
                    command.incrementStage();
                    command.complete(new Form(requestData.getForm()));
                    response.setStatus(AdHocCommand.Status.completed);
                    this.executingCommands.remove(sessionId);
                } else if (AdHocCommand.Action.prev.equals((Object)action)) {
                    command.decrementStage();
                    command.prev();
                } else if (AdHocCommand.Action.cancel.equals((Object)action)) {
                    command.cancel();
                    response.setStatus(AdHocCommand.Status.canceled);
                    this.executingCommands.remove(sessionId);
                }
                return response;
            }
            catch (XMPPException.XMPPErrorException e) {
                XMPPError error = e.getXMPPError();
                if (XMPPError.Type.CANCEL.equals((Object)error.getType())) {
                    response.setStatus(AdHocCommand.Status.canceled);
                    this.executingCommands.remove(sessionId);
                }
                return AdHocCommandManager.respondError(response, XMPPError.getBuilder((XMPPError)error));
            }
        }
    }

    private static IQ respondError(AdHocCommandData response, XMPPError.Condition condition) {
        return AdHocCommandManager.respondError(response, XMPPError.getBuilder((XMPPError.Condition)condition));
    }

    private static IQ respondError(AdHocCommandData response, XMPPError.Condition condition, AdHocCommand.SpecificErrorCondition specificCondition) {
        XMPPError.Builder error = (XMPPError.Builder)XMPPError.getBuilder((XMPPError.Condition)condition).addExtension((ExtensionElement)new AdHocCommandData.SpecificError(specificCondition));
        return AdHocCommandManager.respondError(response, error);
    }

    private static IQ respondError(AdHocCommandData response, XMPPError.Builder error) {
        response.setType(IQ.Type.error);
        response.setError(error);
        return response;
    }

    private LocalCommand newInstanceOfCmd(String commandNode, String sessionID) throws XMPPException.XMPPErrorException {
        LocalCommand command;
        AdHocCommandInfo commandInfo = this.commands.get(commandNode);
        try {
            command = commandInfo.getCommandInstance();
            command.setSessionID(sessionID);
            command.setName(commandInfo.getName());
            command.setNode(commandInfo.getNode());
        }
        catch (InstantiationException e) {
            throw new XMPPException.XMPPErrorException(XMPPError.getBuilder((XMPPError.Condition)XMPPError.Condition.internal_server_error));
        }
        catch (IllegalAccessException e) {
            throw new XMPPException.XMPPErrorException(XMPPError.getBuilder((XMPPError.Condition)XMPPError.Condition.internal_server_error));
        }
        return command;
    }

    private Collection<AdHocCommandInfo> getRegisteredCommands() {
        return this.commands.values();
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                AdHocCommandManager.getAddHocCommandsManager(connection);
            }
        });
    }

    private static class AdHocCommandInfo {
        private String node;
        private String name;
        private final Jid ownerJID;
        private LocalCommandFactory factory;

        public AdHocCommandInfo(String node, String name, Jid ownerJID, LocalCommandFactory factory) {
            this.node = node;
            this.name = name;
            this.ownerJID = ownerJID;
            this.factory = factory;
        }

        public LocalCommand getCommandInstance() throws InstantiationException, IllegalAccessException {
            return this.factory.getInstance();
        }

        public String getName() {
            return this.name;
        }

        public String getNode() {
            return this.node;
        }

        public Jid getOwnerJID() {
            return this.ownerJID;
        }
    }
}

