/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements;

import java.util.logging.Logger;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.element.JingleContentTransportCandidate;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public final class JingleS5BTransportCandidate
extends JingleContentTransportCandidate {
    private static final Logger LOGGER = Logger.getLogger(JingleS5BTransportCandidate.class.getName());
    public static final String ATTR_CID = "cid";
    public static final String ATTR_HOST = "host";
    public static final String ATTR_JID = "jid";
    public static final String ATTR_PORT = "port";
    public static final String ATTR_PRIORITY = "priority";
    public static final String ATTR_TYPE = "type";
    private final String cid;
    private final String host;
    private final Jid jid;
    private final int port;
    private final int priority;
    private final Type type;

    public JingleS5BTransportCandidate(String candidateId, String host, Jid jid, int port, int priority, Type type) {
        Objects.requireNonNull((Object)candidateId);
        Objects.requireNonNull((Object)host);
        Objects.requireNonNull((Object)jid);
        if (priority < 0) {
            throw new IllegalArgumentException("Priority MUST NOT be less than 0.");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Port MUST NOT be less than 0.");
        }
        this.cid = candidateId;
        this.host = host;
        this.jid = jid;
        this.port = port;
        this.priority = priority;
        this.type = type;
    }

    public JingleS5BTransportCandidate(Bytestream.StreamHost streamHost, int priority, Type type) {
        this(StringUtils.randomString((int)24), streamHost.getAddress(), streamHost.getJID(), streamHost.getPort(), priority, type);
    }

    public String getCandidateId() {
        return this.cid;
    }

    public String getHost() {
        return this.host;
    }

    public Jid getJid() {
        return this.jid;
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public Type getType() {
        return this.type;
    }

    public Bytestream.StreamHost getStreamHost() {
        return new Bytestream.StreamHost(this.jid, this.host, this.port);
    }

    public CharSequence toXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        xml.halfOpenElement((NamedElement)this);
        xml.attribute(ATTR_CID, this.cid);
        xml.attribute(ATTR_HOST, this.host);
        xml.attribute(ATTR_JID, (CharSequence)this.jid);
        if (this.port >= 0) {
            xml.attribute(ATTR_PORT, this.port);
        }
        xml.attribute(ATTR_PRIORITY, this.priority);
        xml.optAttribute(ATTR_TYPE, (Enum)this.type);
        xml.closeEmptyElement();
        return xml;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String cid;
        private String host;
        private Jid jid;
        private int port = -1;
        private int priority = -1;
        private Type type;

        private Builder() {
        }

        public Builder setCandidateId(String cid) {
            this.cid = cid;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setJid(String jid) throws XmppStringprepException {
            this.jid = JidCreate.from((String)jid);
            return this;
        }

        public Builder setPort(int port) {
            if (port < 0) {
                throw new IllegalArgumentException("Port MUST NOT be less than 0.");
            }
            this.port = port;
            return this;
        }

        public Builder setPriority(int priority) {
            if (priority < 0) {
                throw new IllegalArgumentException("Priority MUST NOT be less than 0.");
            }
            this.priority = priority;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public JingleS5BTransportCandidate build() {
            return new JingleS5BTransportCandidate(this.cid, this.host, this.jid, this.port, this.priority, this.type);
        }
    }

    public static enum Type {
        assisted(120),
        direct(126),
        proxy(10),
        tunnel(110);

        private final int weight;

        public int getWeight() {
            return this.weight;
        }

        private Type(int weight) {
            this.weight = weight;
        }

        public static Type fromString(String name) {
            for (Type t : Type.values()) {
                if (!t.toString().equals(name)) continue;
                return t;
            }
            throw new IllegalArgumentException("Illegal type: " + name);
        }
    }
}

