/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hashes.element;

import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.hashes.HashManager;

public class HashElement
implements ExtensionElement {
    public static final String ELEMENT = "hash";
    public static final String ATTR_ALGO = "algo";
    private final HashManager.ALGORITHM algorithm;
    private final byte[] hash;
    private final String hashB64;

    public HashElement(HashManager.ALGORITHM algorithm, byte[] hash) {
        this.algorithm = (HashManager.ALGORITHM)((Object)Objects.requireNonNull((Object)((Object)algorithm)));
        this.hash = (byte[])Objects.requireNonNull((Object)hash);
        this.hashB64 = Base64.encodeToString((byte[])hash);
    }

    public HashElement(HashManager.ALGORITHM algorithm, String hashB64) {
        this.algorithm = algorithm;
        this.hash = Base64.decode((String)hashB64);
        this.hashB64 = hashB64;
    }

    public HashManager.ALGORITHM getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String getHashB64() {
        return this.hashB64;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public CharSequence toXML() {
        XmlStringBuilder sb = new XmlStringBuilder((ExtensionElement)this);
        sb.attribute(ATTR_ALGO, this.algorithm.toString());
        sb.rightAngleBracket();
        sb.append((CharSequence)this.hashB64);
        sb.closeElement((NamedElement)this);
        return sb;
    }

    public String getNamespace() {
        return HashManager.NAMESPACE.V2.toString();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof HashElement)) {
            return false;
        }
        return this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        return this.toXML().toString().hashCode();
    }
}

