/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smackx.omemo.OmemoConfiguration;
import org.jivesoftware.smackx.omemo.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.element.OmemoBundleVAxolotlElement;
import org.jivesoftware.smackx.omemo.element.OmemoDeviceListElement;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.CachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.internal.OmemoSession;
import org.jivesoftware.smackx.omemo.util.OmemoKeyUtil;
import org.jxmpp.jid.BareJid;

public abstract class OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    private static final Logger LOGGER = Logger.getLogger(OmemoStore.class.getName());
    private final WeakHashMap<OmemoManager, HashMap<OmemoDevice, OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>>> omemoSessions = new WeakHashMap();

    public abstract boolean isFreshInstallation(OmemoManager var1);

    boolean isAvailableDeviceId(OmemoManager omemoManager, int id) {
        LOGGER.log(Level.INFO, "Check if id " + id + " is available...");
        BareJid ownJid = omemoManager.getOwnJid();
        CachedDeviceList cachedDeviceList = this.loadCachedDeviceList(omemoManager, ownJid);
        if (cachedDeviceList == null) {
            cachedDeviceList = new CachedDeviceList();
        }
        return !cachedDeviceList.contains(id);
    }

    void regenerate(OmemoManager omemoManager) throws CorruptedOmemoKeyException {
        LOGGER.log(Level.INFO, "Regenerating with deviceId " + omemoManager.getDeviceId() + "...");
        int nextPreKeyId = 1;
        this.storeOmemoIdentityKeyPair(omemoManager, this.generateOmemoIdentityKeyPair());
        this.storeOmemoPreKeys(omemoManager, this.generateOmemoPreKeys(nextPreKeyId, 100));
        this.storeLastPreKeyId(omemoManager, OmemoKeyUtil.addInBounds(nextPreKeyId, 100));
        this.storeCurrentSignedPreKeyId(omemoManager, -1);
        this.changeSignedPreKey(omemoManager);
        this.initializeOmemoSessions(omemoManager);
    }

    void mergeCachedDeviceList(OmemoManager omemoManager, BareJid contact, OmemoDeviceListElement list) {
        CachedDeviceList cached = this.loadCachedDeviceList(omemoManager, contact);
        if (cached == null) {
            cached = new CachedDeviceList();
        }
        if (list != null) {
            cached.merge(list.getDeviceIds());
        }
        this.storeCachedDeviceList(omemoManager, contact, cached);
    }

    void changeSignedPreKey(OmemoManager omemoManager) throws CorruptedOmemoKeyException {
        int lastSignedPreKeyId = this.loadCurrentSignedPreKeyId(omemoManager);
        if (lastSignedPreKeyId == -1) {
            lastSignedPreKeyId = 0;
        }
        try {
            T_SigPreKey newSignedPreKey = this.generateOmemoSignedPreKey(this.loadOmemoIdentityKeyPair(omemoManager), lastSignedPreKeyId + 1);
            this.storeOmemoSignedPreKey(omemoManager, lastSignedPreKeyId + 1, newSignedPreKey);
            this.storeCurrentSignedPreKeyId(omemoManager, lastSignedPreKeyId + 1);
            this.setDateOfLastSignedPreKeyRenewal(omemoManager);
            this.removeOldSignedPreKeys(omemoManager);
        }
        catch (CorruptedOmemoKeyException e) {
            LOGGER.log(Level.INFO, "Couldn't change SignedPreKey: " + e.getMessage());
            throw e;
        }
    }

    private void removeOldSignedPreKeys(OmemoManager omemoManager) {
        if (OmemoConfiguration.getMaxNumberOfStoredSignedPreKeys() <= 0) {
            return;
        }
        int currentId = this.loadCurrentSignedPreKeyId(omemoManager);
        if (currentId == -1) {
            currentId = 0;
        }
        HashMap<Integer, T_SigPreKey> signedPreKeys = this.loadOmemoSignedPreKeys(omemoManager);
        for (int i : signedPreKeys.keySet()) {
            if (i > currentId - OmemoConfiguration.getMaxNumberOfStoredSignedPreKeys()) continue;
            LOGGER.log(Level.INFO, "Remove signedPreKey " + i + ".");
            this.removeOmemoSignedPreKey(omemoManager, i);
        }
    }

    OmemoBundleVAxolotlElement packOmemoBundle(OmemoManager omemoManager) throws CorruptedOmemoKeyException {
        int currentSignedPreKeyId = this.loadCurrentSignedPreKeyId(omemoManager);
        if (currentSignedPreKeyId == -1) {
            currentSignedPreKeyId = 0;
        }
        T_SigPreKey currentSignedPreKey = this.loadOmemoSignedPreKey(omemoManager, currentSignedPreKeyId);
        T_IdKeyPair identityKeyPair = this.loadOmemoIdentityKeyPair(omemoManager);
        HashMap<Integer, T_PreKey> preKeys = this.loadOmemoPreKeys(omemoManager);
        int newKeysCount = 100 - preKeys.size();
        if (newKeysCount > 0) {
            int lastPreKeyId = this.loadLastPreKeyId(omemoManager);
            if (lastPreKeyId == -1) {
                lastPreKeyId = 0;
            }
            HashMap<Integer, T_PreKey> newKeys = this.generateOmemoPreKeys(lastPreKeyId + 1, newKeysCount);
            this.storeOmemoPreKeys(omemoManager, newKeys);
            preKeys.putAll(newKeys);
            this.storeLastPreKeyId(omemoManager, lastPreKeyId + newKeysCount);
        }
        return new OmemoBundleVAxolotlElement(currentSignedPreKeyId, this.keyUtil().signedPreKeyPublicForBundle(currentSignedPreKey), this.keyUtil().signedPreKeySignatureFromKey(currentSignedPreKey), this.keyUtil().identityKeyForBundle(this.keyUtil().identityKeyFromPair(identityKeyPair)), this.keyUtil().preKeyPublisKeysForBundle(preKeys));
    }

    void initializeOmemoSessions(OmemoManager omemoManager) {
        HashMap<OmemoDevice, OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>> sessions = this.omemoSessions.get((Object)omemoManager);
        if (sessions == null) {
            sessions = new HashMap();
            this.omemoSessions.put(omemoManager, sessions);
        }
        HashMap<Integer, T_Sess> ourRawSessions = this.loadAllRawSessionsOf(omemoManager, omemoManager.getOwnJid());
        ourRawSessions.remove(omemoManager.getDeviceId());
        sessions.putAll(this.createOmemoSessionsFromRawSessions(omemoManager, omemoManager.getOwnJid(), ourRawSessions));
        for (RosterEntry rosterEntry : Roster.getInstanceFor((XMPPConnection)omemoManager.getConnection()).getEntries()) {
            HashMap<Integer, T_Sess> contactDevices = this.loadAllRawSessionsOf(omemoManager, rosterEntry.getJid().asBareJid());
            sessions.putAll(this.createOmemoSessionsFromRawSessions(omemoManager, rosterEntry.getJid().asBareJid(), contactDevices));
        }
    }

    void forgetOmemoSessions(OmemoManager omemoManager) {
        this.omemoSessions.remove((Object)omemoManager);
    }

    private OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> createOmemoSession(OmemoManager omemoManager, OmemoDevice device, T_IdKey identityKey) {
        return this.keyUtil().createOmemoSession(omemoManager, this, device, identityKey);
    }

    public OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> getOmemoSessionOf(OmemoManager omemoManager, OmemoDevice device) {
        OmemoSession<T_IdKeyPair, Object, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> session;
        HashMap<OmemoDevice, OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>> sessions = this.omemoSessions.get((Object)omemoManager);
        if (sessions == null) {
            sessions = new HashMap();
            this.omemoSessions.put(omemoManager, sessions);
        }
        if ((session = sessions.get(device)) == null) {
            T_IdKey identityKey = null;
            try {
                identityKey = this.loadOmemoIdentityKey(omemoManager, device);
            }
            catch (CorruptedOmemoKeyException e) {
                LOGGER.log(Level.WARNING, "getOmemoSessionOf could not load identityKey of " + device + ": " + e.getMessage());
            }
            if (identityKey != null) {
                session = this.createOmemoSession(omemoManager, device, identityKey);
            } else {
                LOGGER.log(Level.INFO, "getOmemoSessionOf couldn't find an identityKey for " + device + ". Initiate session without.");
                session = this.createOmemoSession(omemoManager, device, null);
            }
            sessions.put(device, session);
        }
        if (session.getIdentityKey() == null) {
            try {
                session.setIdentityKey(this.loadOmemoIdentityKey(omemoManager, device));
            }
            catch (CorruptedOmemoKeyException e) {
                LOGGER.log(Level.WARNING, "Can't update IdentityKey of " + device + ": " + e.getMessage());
            }
        }
        return session;
    }

    private HashMap<OmemoDevice, OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>> createOmemoSessionsFromRawSessions(OmemoManager omemoManager, BareJid contact, HashMap<Integer, T_Sess> rawSessions) {
        HashMap<OmemoDevice, OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>> sessions = new HashMap<OmemoDevice, OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>>();
        for (Map.Entry<Integer, T_Sess> sessionEntry : rawSessions.entrySet()) {
            OmemoDevice omemoDevice = new OmemoDevice(contact, sessionEntry.getKey());
            try {
                T_IdKey identityKey = this.loadOmemoIdentityKey(omemoManager, omemoDevice);
                if (identityKey != null) {
                    sessions.put(omemoDevice, this.createOmemoSession(omemoManager, omemoDevice, identityKey));
                    continue;
                }
                LOGGER.log(Level.WARNING, "IdentityKey of " + omemoDevice + " is null. Is this even possible at this point?");
            }
            catch (CorruptedOmemoKeyException e1) {
                LOGGER.log(Level.WARNING, "buildOmemoSessionFor could not create a session for " + omemoDevice + ": " + e1.getMessage());
            }
        }
        return sessions;
    }

    public abstract int loadLastPreKeyId(OmemoManager var1);

    public abstract void storeLastPreKeyId(OmemoManager var1, int var2);

    public T_IdKeyPair generateOmemoIdentityKeyPair() {
        return this.keyUtil().generateOmemoIdentityKeyPair();
    }

    public abstract T_IdKeyPair loadOmemoIdentityKeyPair(OmemoManager var1) throws CorruptedOmemoKeyException;

    public abstract void storeOmemoIdentityKeyPair(OmemoManager var1, T_IdKeyPair var2);

    public abstract T_IdKey loadOmemoIdentityKey(OmemoManager var1, OmemoDevice var2) throws CorruptedOmemoKeyException;

    public abstract void storeOmemoIdentityKey(OmemoManager var1, OmemoDevice var2, T_IdKey var3);

    public boolean isTrustedOmemoIdentity(OmemoManager omemoManager, OmemoDevice device, T_IdKey identityKey) {
        return this.isTrustedOmemoIdentity(omemoManager, device, this.keyUtil().getFingerprint(identityKey));
    }

    public abstract boolean isTrustedOmemoIdentity(OmemoManager var1, OmemoDevice var2, OmemoFingerprint var3);

    public boolean isDecidedOmemoIdentity(OmemoManager omemoManager, OmemoDevice device, T_IdKey identityKey) {
        return this.isDecidedOmemoIdentity(omemoManager, device, this.keyUtil().getFingerprint(identityKey));
    }

    public abstract boolean isDecidedOmemoIdentity(OmemoManager var1, OmemoDevice var2, OmemoFingerprint var3);

    public void trustOmemoIdentity(OmemoManager omemoManager, OmemoDevice device, T_IdKey identityKey) {
        this.trustOmemoIdentity(omemoManager, device, this.keyUtil().getFingerprint(identityKey));
    }

    public abstract void trustOmemoIdentity(OmemoManager var1, OmemoDevice var2, OmemoFingerprint var3);

    public void distrustOmemoIdentity(OmemoManager omemoManager, OmemoDevice device, T_IdKey identityKey) {
        this.distrustOmemoIdentity(omemoManager, device, this.keyUtil().getFingerprint(identityKey));
    }

    public abstract void distrustOmemoIdentity(OmemoManager var1, OmemoDevice var2, OmemoFingerprint var3);

    public abstract void setDateOfLastReceivedMessage(OmemoManager var1, OmemoDevice var2, Date var3);

    public void setDateOfLastReceivedMessage(OmemoManager omemoManager, OmemoDevice from) {
        this.setDateOfLastReceivedMessage(omemoManager, from, new Date());
    }

    public abstract Date getDateOfLastReceivedMessage(OmemoManager var1, OmemoDevice var2);

    public abstract void setDateOfLastSignedPreKeyRenewal(OmemoManager var1, Date var2);

    public void setDateOfLastSignedPreKeyRenewal(OmemoManager omemoManager) {
        this.setDateOfLastSignedPreKeyRenewal(omemoManager, new Date());
    }

    public abstract Date getDateOfLastSignedPreKeyRenewal(OmemoManager var1);

    public HashMap<Integer, T_PreKey> generateOmemoPreKeys(int startId, int count) {
        return this.keyUtil().generateOmemoPreKeys(startId, count);
    }

    public abstract T_PreKey loadOmemoPreKey(OmemoManager var1, int var2);

    public abstract void storeOmemoPreKey(OmemoManager var1, int var2, T_PreKey var3);

    public void storeOmemoPreKeys(OmemoManager omemoManager, HashMap<Integer, T_PreKey> preKeyHashMap) {
        for (Map.Entry<Integer, T_PreKey> e : preKeyHashMap.entrySet()) {
            this.storeOmemoPreKey(omemoManager, e.getKey(), e.getValue());
        }
    }

    public abstract void removeOmemoPreKey(OmemoManager var1, int var2);

    public abstract int loadCurrentSignedPreKeyId(OmemoManager var1);

    public abstract void storeCurrentSignedPreKeyId(OmemoManager var1, int var2);

    public abstract HashMap<Integer, T_PreKey> loadOmemoPreKeys(OmemoManager var1);

    public abstract T_SigPreKey loadOmemoSignedPreKey(OmemoManager var1, int var2);

    public abstract HashMap<Integer, T_SigPreKey> loadOmemoSignedPreKeys(OmemoManager var1);

    public T_SigPreKey generateOmemoSignedPreKey(T_IdKeyPair identityKeyPair, int signedPreKeyId) throws CorruptedOmemoKeyException {
        return this.keyUtil().generateOmemoSignedPreKey(identityKeyPair, signedPreKeyId);
    }

    public abstract void storeOmemoSignedPreKey(OmemoManager var1, int var2, T_SigPreKey var3);

    public abstract void removeOmemoSignedPreKey(OmemoManager var1, int var2);

    public abstract T_Sess loadRawSession(OmemoManager var1, OmemoDevice var2);

    public abstract HashMap<Integer, T_Sess> loadAllRawSessionsOf(OmemoManager var1, BareJid var2);

    public abstract void storeRawSession(OmemoManager var1, OmemoDevice var2, T_Sess var3);

    public abstract void removeRawSession(OmemoManager var1, OmemoDevice var2);

    public abstract void removeAllRawSessionsOf(OmemoManager var1, BareJid var2);

    public abstract boolean containsRawSession(OmemoManager var1, OmemoDevice var2);

    public abstract CachedDeviceList loadCachedDeviceList(OmemoManager var1, BareJid var2);

    public abstract void storeCachedDeviceList(OmemoManager var1, BareJid var2, CachedDeviceList var3);

    public abstract void purgeOwnDeviceKeys(OmemoManager var1);

    public abstract OmemoKeyUtil<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> keyUtil();

    public OmemoFingerprint getFingerprint(OmemoManager omemoManager) {
        try {
            return this.keyUtil().getFingerprint(this.keyUtil().identityKeyFromPair(this.loadOmemoIdentityKeyPair(omemoManager)));
        }
        catch (CorruptedOmemoKeyException e) {
            LOGGER.log(Level.WARNING, "getFingerprint failed due to corrupted identityKeyPair: " + e.getMessage());
            return null;
        }
    }

    public abstract int getDefaultDeviceId(BareJid var1);

    public abstract void setDefaultDeviceId(BareJid var1, int var2);

    public OmemoFingerprint getFingerprint(OmemoManager omemoManager, OmemoDevice device) throws CannotEstablishOmemoSessionException {
        T_IdKey idKey;
        try {
            idKey = this.loadOmemoIdentityKey(omemoManager, device);
            if (idKey == null) {
                OmemoService.getInstance().buildSessionFromOmemoBundle(omemoManager, device, true);
            }
            idKey = this.loadOmemoIdentityKey(omemoManager, device);
        }
        catch (CorruptedOmemoKeyException e) {
            LOGGER.log(Level.WARNING, "getFingerprint failed due to corrupted identityKey: " + e.getMessage());
            return null;
        }
        return this.keyUtil().getFingerprint(idKey);
    }
}

