/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlUtil {
    private static final Logger LOGGER = Logger.getLogger(XmlUtil.class.getName());
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public static String prettyFormatXml(String xml) {
        StreamSource source = new StreamSource(new StringReader(xml));
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (IllegalArgumentException | TransformerException e) {
            LOGGER.log(Level.SEVERE, "Transformer error", e);
            return xml;
        }
        return stringWriter.toString();
    }

    static {
        transformerFactory.setAttribute("indent-number", 2);
    }
}

