/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jivesoftware.smack.util.dns.SRVRecord;
import org.jivesoftware.smack.util.dns.SmackDaneProvider;
import org.minidns.dnsname.DnsName;

public class DNSUtil {
    public static final String XMPP_CLIENT_DNS_SRV_PREFIX = "_xmpp-client._tcp";
    public static final String XMPP_SERVER_DNS_SRV_PREFIX = "_xmpp-server._tcp";
    private static final Logger LOGGER = Logger.getLogger(DNSUtil.class.getName());
    private static DNSResolver dnsResolver = null;
    private static SmackDaneProvider daneProvider;

    public static void setDNSResolver(DNSResolver resolver) {
        dnsResolver = Objects.requireNonNull(resolver);
    }

    public static DNSResolver getDNSResolver() {
        return dnsResolver;
    }

    public static void setDaneProvider(SmackDaneProvider daneProvider) {
        daneProvider = Objects.requireNonNull(daneProvider);
    }

    public static SmackDaneProvider getDaneProvider() {
        return daneProvider;
    }

    public static List<HostAddress> resolveXMPPServiceDomain(DnsName domain, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        return DNSUtil.resolveDomain(domain, DomainType.client, failedAddresses, dnssecMode);
    }

    public static List<HostAddress> resolveXMPPServerDomain(DnsName domain, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        return DNSUtil.resolveDomain(domain, DomainType.server, failedAddresses, dnssecMode);
    }

    private static List<HostAddress> resolveDomain(DnsName domain, DomainType domainType, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        if (dnsResolver == null) {
            throw new IllegalStateException("No DNS Resolver active in Smack");
        }
        ArrayList<HostAddress> addresses = new ArrayList<HostAddress>();
        DnsName srvDomain = DnsName.from((DnsName)domainType.srvPrefix, (DnsName)domain);
        List<SRVRecord> srvRecords = dnsResolver.lookupSRVRecords(srvDomain, failedAddresses, dnssecMode);
        if (srvRecords != null && !srvRecords.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                String logMessage = "Resolved SRV RR for " + srvDomain + ":";
                for (SRVRecord r : srvRecords) {
                    logMessage = logMessage + " " + r;
                }
                LOGGER.fine(logMessage);
            }
            List<HostAddress> sortedRecords = DNSUtil.sortSRVRecords(srvRecords);
            addresses.addAll(sortedRecords);
        } else {
            LOGGER.info("Could not resolve DNS SRV resource records for " + srvDomain + ". Consider adding those.");
        }
        int defaultPort = -1;
        switch (domainType) {
            case client: {
                defaultPort = 5222;
                break;
            }
            case server: {
                defaultPort = 5269;
            }
        }
        HostAddress hostAddress = dnsResolver.lookupHostAddress(domain, defaultPort, failedAddresses, dnssecMode);
        if (hostAddress != null) {
            addresses.add(hostAddress);
        }
        return addresses;
    }

    private static List<HostAddress> sortSRVRecords(List<SRVRecord> records) {
        List bucket;
        if (records.size() == 1 && records.get(0).getFQDN().isRootLabel()) {
            return Collections.emptyList();
        }
        Collections.sort(records);
        TreeMap<Integer, LinkedList<SRVRecord>> buckets = new TreeMap<Integer, LinkedList<SRVRecord>>();
        for (SRVRecord r : records) {
            Integer priority = r.getPriority();
            bucket = (LinkedList<SRVRecord>)buckets.get(priority);
            if (bucket == null) {
                bucket = new LinkedList<SRVRecord>();
                buckets.put(priority, (LinkedList<SRVRecord>)bucket);
            }
            bucket.add(r);
        }
        ArrayList<HostAddress> res = new ArrayList<HostAddress>(records.size());
        for (Integer priority : buckets.keySet()) {
            int bucketSize;
            bucket = (List)buckets.get(priority);
            while ((bucketSize = bucket.size()) > 0) {
                int selectedPos;
                int[] totals = new int[bucketSize];
                int running_total = 0;
                int count = 0;
                int zeroWeight = 1;
                for (SRVRecord r : bucket) {
                    if (r.getWeight() <= 0) continue;
                    zeroWeight = 0;
                    break;
                }
                for (SRVRecord r : bucket) {
                    totals[count] = running_total += r.getWeight() + zeroWeight;
                    ++count;
                }
                if (running_total == 0) {
                    selectedPos = (int)(Math.random() * (double)bucketSize);
                } else {
                    double rnd = Math.random() * (double)running_total;
                    selectedPos = DNSUtil.bisect(totals, rnd);
                }
                SRVRecord chosenSRVRecord = (SRVRecord)bucket.remove(selectedPos);
                res.add(chosenSRVRecord);
            }
        }
        return res;
    }

    private static int bisect(int[] array, double value) {
        int pos = 0;
        for (int element : array) {
            if (value < (double)element) break;
            ++pos;
        }
        return pos;
    }

    static enum DomainType {
        server("_xmpp-server._tcp"),
        client("_xmpp-client._tcp");

        public final DnsName srvPrefix;

        private DomainType(String srvPrefixString) {
            this.srvPrefix = DnsName.from((String)srvPrefixString);
        }
    }
}

