/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.element;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.omemo.element.OmemoBundleElement;

public class OmemoBundleVAxolotlElement
extends OmemoBundleElement {
    private final int signedPreKeyId;
    private final String signedPreKeyB64;
    private byte[] signedPreKey;
    private final String signedPreKeySignatureB64;
    private byte[] signedPreKeySignature;
    private final String identityKeyB64;
    private byte[] identityKey;
    private final HashMap<Integer, String> preKeysB64;
    private HashMap<Integer, byte[]> preKeys;

    public OmemoBundleVAxolotlElement(int signedPreKeyId, String signedPreKeyB64, String signedPreKeySigB64, String identityKeyB64, HashMap<Integer, String> preKeysB64) {
        this.signedPreKeyId = signedPreKeyId;
        this.signedPreKeyB64 = signedPreKeyB64;
        this.signedPreKeySignatureB64 = signedPreKeySigB64;
        this.identityKeyB64 = identityKeyB64;
        this.preKeysB64 = preKeysB64;
    }

    public OmemoBundleVAxolotlElement(int signedPreKeyId, byte[] signedPreKey, byte[] signedPreKeySig, byte[] identityKey, HashMap<Integer, byte[]> preKeys) {
        this.signedPreKeyId = signedPreKeyId;
        this.signedPreKey = signedPreKey;
        this.signedPreKeyB64 = Base64.encodeToString((byte[])signedPreKey);
        this.signedPreKeySignature = signedPreKeySig;
        this.signedPreKeySignatureB64 = Base64.encodeToString((byte[])this.signedPreKeySignature);
        this.identityKey = identityKey;
        this.identityKeyB64 = Base64.encodeToString((byte[])identityKey);
        this.preKeys = preKeys;
        this.preKeysB64 = new HashMap();
        for (int id : preKeys.keySet()) {
            this.preKeysB64.put(id, Base64.encodeToString((byte[])preKeys.get(id)));
        }
    }

    public byte[] getSignedPreKey() {
        if (this.signedPreKey == null) {
            this.signedPreKey = Base64.decode((String)this.signedPreKeyB64);
        }
        return (byte[])this.signedPreKey.clone();
    }

    public int getSignedPreKeyId() {
        return this.signedPreKeyId;
    }

    public byte[] getSignedPreKeySignature() {
        if (this.signedPreKeySignature == null) {
            this.signedPreKeySignature = Base64.decode((String)this.signedPreKeySignatureB64);
        }
        return (byte[])this.signedPreKeySignature.clone();
    }

    public byte[] getIdentityKey() {
        if (this.identityKey == null) {
            this.identityKey = Base64.decode((String)this.identityKeyB64);
        }
        return (byte[])this.identityKey.clone();
    }

    public HashMap<Integer, byte[]> getPreKeys() {
        if (this.preKeys == null) {
            this.preKeys = new HashMap();
            for (int id : this.preKeysB64.keySet()) {
                this.preKeys.put(id, Base64.decode((String)this.preKeysB64.get(id)));
            }
        }
        return this.preKeys;
    }

    public byte[] getPreKey(int id) {
        return this.getPreKeys().get(id);
    }

    public String getElementName() {
        return "bundle";
    }

    @Override
    public XmlStringBuilder toXML(String enclosingNamespace) {
        XmlStringBuilder sb = new XmlStringBuilder((ExtensionElement)this).rightAngleBracket();
        sb.halfOpenElement("signedPreKeyPublic").attribute("signedPreKeyId", this.signedPreKeyId).rightAngleBracket().append((CharSequence)this.signedPreKeyB64).closeElement("signedPreKeyPublic");
        sb.openElement("signedPreKeySignature").append((CharSequence)this.signedPreKeySignatureB64).closeElement("signedPreKeySignature");
        sb.openElement("identityKey").append((CharSequence)this.identityKeyB64).closeElement("identityKey");
        sb.openElement("prekeys");
        for (Map.Entry<Integer, String> p : this.preKeysB64.entrySet()) {
            sb.halfOpenElement("preKeyPublic").attribute("preKeyId", p.getKey().intValue()).rightAngleBracket().append((CharSequence)p.getValue()).closeElement("preKeyPublic");
        }
        sb.closeElement("prekeys");
        sb.closeElement((NamedElement)this);
        return sb;
    }

    public String getNamespace() {
        return "eu.siacs.conversations.axolotl";
    }

    public String toString() {
        String out = "OmemoBundleElement[\n";
        out = out + "signedPreKeyPublic signedPreKeyId=" + this.signedPreKeyId + ": " + this.signedPreKeyB64 + "\n";
        out = out + "signedPreKeySignature: " + this.signedPreKeySignatureB64 + "\n";
        out = out + "identityKey: " + this.identityKeyB64 + "\n";
        out = out + "prekeys (" + this.preKeysB64.size() + ")\n";
        for (Map.Entry<Integer, String> e : this.preKeysB64.entrySet()) {
            out = out + "preKeyPublic preKeyId=" + e.getKey() + ": " + e.getValue() + "\n";
        }
        return out;
    }
}

