/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.BareJid;

public class RosterPacket
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:roster";
    private final List<Item> rosterItems = new ArrayList<Item>();
    private String rosterVersion;

    public RosterPacket() {
        super(ELEMENT, NAMESPACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterItem(Item item) {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            this.rosterItems.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRosterItemCount() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return this.rosterItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Item> getRosterItems() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return new ArrayList<Item>(this.rosterItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.optAttribute("ver", this.rosterVersion);
        buf.rightAngleBracket();
        List<Item> list = this.rosterItems;
        synchronized (list) {
            for (Item entry : this.rosterItems) {
                buf.append(entry.toXML(null));
            }
        }
        return buf;
    }

    public String getVersion() {
        return this.rosterVersion;
    }

    public void setVersion(String version) {
        this.rosterVersion = version;
    }

    public static enum ItemType {
        none('\u22a5'),
        to('\u2190'),
        from('\u2192'),
        both('\u2194'),
        remove('\u26a1');

        private static final char ME = '\u25cf';
        private final String symbol;

        private ItemType(char secondSymbolChar) {
            StringBuilder sb = new StringBuilder(2);
            sb.append('\u25cf').append(secondSymbolChar);
            this.symbol = sb.toString();
        }

        public static ItemType fromString(String string) {
            if (StringUtils.isNullOrEmpty((CharSequence)string)) {
                return none;
            }
            return ItemType.valueOf(string.toLowerCase(Locale.US));
        }

        public String asSymbol() {
            return this.symbol;
        }
    }

    public static class Item
    implements NamedElement {
        public static final String ELEMENT = "item";
        public static final String GROUP = "group";
        private final BareJid jid;
        private boolean subscriptionPending;
        private String name;
        private ItemType itemType = ItemType.none;
        private boolean approved;
        private final Set<String> groupNames;

        public Item(BareJid jid, String name) {
            this(jid, name, false);
        }

        public Item(BareJid jid, String name, boolean subscriptionPending) {
            this.jid = (BareJid)Objects.requireNonNull((Object)jid);
            this.name = name;
            this.subscriptionPending = subscriptionPending;
            this.groupNames = new CopyOnWriteArraySet<String>();
        }

        public String getElementName() {
            return ELEMENT;
        }

        @Deprecated
        public String getUser() {
            return this.jid.toString();
        }

        public BareJid getJid() {
            return this.jid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ItemType getItemType() {
            return this.itemType;
        }

        public void setItemType(ItemType itemType) {
            this.itemType = (ItemType)((Object)Objects.requireNonNull((Object)((Object)itemType), (String)"itemType must not be null"));
        }

        public void setSubscriptionPending(boolean subscriptionPending) {
            this.subscriptionPending = subscriptionPending;
        }

        public boolean isSubscriptionPending() {
            return this.subscriptionPending;
        }

        public boolean isApproved() {
            return this.approved;
        }

        public void setApproved(boolean approved) {
            this.approved = approved;
        }

        public Set<String> getGroupNames() {
            return Collections.unmodifiableSet(this.groupNames);
        }

        public void addGroupName(String groupName) {
            this.groupNames.add(groupName);
        }

        public void removeGroupName(String groupName) {
            this.groupNames.remove(groupName);
        }

        public XmlStringBuilder toXML(String enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.attribute("jid", (CharSequence)this.jid);
            xml.optAttribute("name", this.name);
            xml.optAttribute("subscription", (Enum)this.itemType);
            if (this.subscriptionPending) {
                xml.append((CharSequence)" ask='subscribe'");
            }
            xml.optBooleanAttribute("approved", this.approved);
            xml.rightAngleBracket();
            for (String groupName : this.groupNames) {
                xml.openElement(GROUP).escape(groupName).closeElement(GROUP);
            }
            xml.closeElement((NamedElement)this);
            return xml;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.groupNames == null ? 0 : this.groupNames.hashCode());
            result = 31 * result + (this.subscriptionPending ? 0 : 1);
            result = 31 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.jid == null ? 0 : this.jid.hashCode());
            result = 31 * result + (!this.approved ? 0 : 1);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (this.groupNames == null ? other.groupNames != null : !this.groupNames.equals(other.groupNames)) {
                return false;
            }
            if (this.subscriptionPending != other.subscriptionPending) {
                return false;
            }
            if (this.itemType != other.itemType) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.jid == null ? other.jid != null : !this.jid.equals((CharSequence)other.jid)) {
                return false;
            }
            return this.approved == other.approved;
        }
    }
}

