/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.util.Arrays;
import java.util.logging.Level;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.omemo.AbstractOmemoIntegrationTest;
import org.jivesoftware.smackx.omemo.OmemoIntegrationTestHelper;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.element.OmemoVAxolotlElement;
import org.jivesoftware.smackx.omemo.internal.CipherAndAuthTag;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.internal.OmemoMessageInformation;
import org.jivesoftware.smackx.omemo.listener.OmemoMessageListener;
import org.jivesoftware.smackx.omemo.util.OmemoMessageBuilder;
import org.junit.Assert;
import org.jxmpp.jid.Jid;

public class OmemoKeyTransportTest
extends AbstractOmemoIntegrationTest {
    private OmemoManager alice;
    private OmemoManager bob;

    public OmemoKeyTransportTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, TestNotPossibleException {
        super(environment);
    }

    @Override
    public void before() {
        this.alice = OmemoManager.getInstanceFor((XMPPConnection)this.conOne, (Integer)11111);
        this.bob = OmemoManager.getInstanceFor((XMPPConnection)this.conTwo, (Integer)222222);
    }

    @SmackIntegrationTest
    public void keyTransportTest() throws Exception {
        final SimpleResultSyncPoint syncPoint = new SimpleResultSyncPoint();
        OmemoIntegrationTestHelper.subscribe(this.alice, this.bob, "Bob");
        OmemoIntegrationTestHelper.subscribe(this.bob, this.alice, "Alice");
        OmemoIntegrationTestHelper.setUpOmemoManager(this.alice);
        OmemoIntegrationTestHelper.setUpOmemoManager(this.bob);
        OmemoIntegrationTestHelper.unidirectionalTrust(this.alice, this.bob);
        OmemoIntegrationTestHelper.unidirectionalTrust(this.bob, this.alice);
        final byte[] key = OmemoMessageBuilder.generateKey();
        final byte[] iv = OmemoMessageBuilder.generateIv();
        this.bob.addOmemoMessageListener(new OmemoMessageListener(){

            public void onOmemoMessageReceived(String decryptedBody, Message encryptedMessage, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
            }

            public void onOmemoKeyTransportReceived(CipherAndAuthTag cipherAndAuthTag, Message message, Message wrappingMessage, OmemoMessageInformation omemoInformation) {
                LOGGER.log(Level.INFO, "Received a keyTransportMessage.");
                Assert.assertTrue((String)"Key must match the one we sent.", (boolean)Arrays.equals(key, cipherAndAuthTag.getKey()));
                Assert.assertTrue((String)"IV must match the one we sent.", (boolean)Arrays.equals(iv, cipherAndAuthTag.getIv()));
                syncPoint.signal();
            }
        });
        OmemoVAxolotlElement keyTransportElement = this.alice.createKeyTransportElement(key, iv, new OmemoDevice[]{this.bob.getOwnDevice()});
        Message message = new Message((Jid)this.bob.getOwnJid());
        message.addExtension((ExtensionElement)keyTransportElement);
        ChatManager.getInstanceFor((XMPPConnection)this.alice.getConnection()).chatWith(this.bob.getOwnJid().asEntityBareJidIfPossible()).send(message);
        syncPoint.waitForResult(10000L);
    }

    @Override
    public void after() {
        this.alice.shutdown();
        this.bob.shutdown();
        OmemoIntegrationTestHelper.cleanServerSideTraces(this.alice);
        OmemoIntegrationTestHelper.cleanServerSideTraces(this.bob);
    }
}

