/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.AbstractSmackLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.roster.AbstractPresenceEventListener;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterIntegrationTest;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jxmpp.jid.FullJid;

public class LowLevelRosterIntegrationTest
extends AbstractSmackLowLevelIntegrationTest {
    public LowLevelRosterIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
    }

    @SmackIntegrationTest
    public void testPresenceEventListenersOffline(XMPPTCPConnection conOne, final XMPPTCPConnection conTwo) throws TimeoutException, Exception {
        RosterIntegrationTest.ensureBothAccountsAreNotInEachOthersRoster((XMPPConnection)conOne, (XMPPConnection)conTwo);
        Roster rosterOne = Roster.getInstanceFor((XMPPConnection)conOne);
        Roster rosterTwo = Roster.getInstanceFor((XMPPConnection)conTwo);
        rosterOne.createEntry(conTwo.getUser().asBareJid(), "Con Two", null);
        rosterTwo.createEntry(conOne.getUser().asBareJid(), "Con One", null);
        long timeout = 5000L;
        RosterIntegrationTest.ensureBothAccountsAreSubscribedToEachOther((XMPPConnection)conOne, (XMPPConnection)conTwo, 5000L);
        final SimpleResultSyncPoint offlineTriggered = new SimpleResultSyncPoint();
        rosterOne.addPresenceEventListener((PresenceEventListener)new AbstractPresenceEventListener(){

            public void presenceUnavailable(FullJid jid, Presence presence) {
                if (!jid.equals((CharSequence)conTwo.getUser())) {
                    return;
                }
                offlineTriggered.signal();
            }
        });
        conTwo.disconnect();
        Boolean result = (Boolean)offlineTriggered.waitForResult(5000L);
        if (!result.booleanValue()) {
            throw new Exception("presenceUnavailable() was not called");
        }
    }
}

