/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.element.OmemoElement;
import org.jivesoftware.smackx.omemo.element.OmemoVAxolotlElement;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.internal.CiphertextTuple;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.internal.OmemoSession;

public class OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    private final OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> omemoStore;
    private final OmemoManager omemoManager;
    private byte[] messageKey = OmemoMessageBuilder.generateKey();
    private byte[] initializationVector = OmemoMessageBuilder.generateIv();
    private byte[] ciphertextMessage;
    private final ArrayList<OmemoElement.OmemoHeader.Key> keys = new ArrayList();

    public OmemoMessageBuilder(OmemoManager omemoManager, OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> omemoStore, byte[] aesKey, byte[] iv) throws NoSuchPaddingException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, UnsupportedEncodingException, NoSuchProviderException, InvalidAlgorithmParameterException {
        this.omemoStore = omemoStore;
        this.omemoManager = omemoManager;
        this.messageKey = aesKey;
        this.initializationVector = iv;
    }

    public OmemoMessageBuilder(OmemoManager omemoManager, OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> omemoStore, String message) throws NoSuchPaddingException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, UnsupportedEncodingException, NoSuchProviderException, InvalidAlgorithmParameterException {
        this.omemoManager = omemoManager;
        this.omemoStore = omemoStore;
        this.setMessage(message);
    }

    public void setMessage(String message) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException {
        if (message == null) {
            return;
        }
        SecretKeySpec secretKey = new SecretKeySpec(this.messageKey, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(this.initializationVector);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        cipher.init(1, (Key)secretKey, ivSpec);
        byte[] body = message.getBytes("UTF-8");
        byte[] ciphertext = cipher.doFinal(body);
        byte[] clearKeyWithAuthTag = new byte[this.messageKey.length + 16];
        byte[] cipherTextWithoutAuthTag = new byte[ciphertext.length - 16];
        System.arraycopy(this.messageKey, 0, clearKeyWithAuthTag, 0, 16);
        System.arraycopy(ciphertext, 0, cipherTextWithoutAuthTag, 0, cipherTextWithoutAuthTag.length);
        System.arraycopy(ciphertext, ciphertext.length - 16, clearKeyWithAuthTag, 16, 16);
        this.ciphertextMessage = cipherTextWithoutAuthTag;
        this.messageKey = clearKeyWithAuthTag;
    }

    public void addRecipient(OmemoDevice device) throws CryptoFailedException, UndecidedOmemoIdentityException, CorruptedOmemoKeyException {
        this.addRecipient(device, false);
    }

    public void addRecipient(OmemoDevice device, boolean ignoreTrust) throws CryptoFailedException, UndecidedOmemoIdentityException, CorruptedOmemoKeyException {
        OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> session = this.omemoStore.getOmemoSessionOf(this.omemoManager, device);
        if (session != null) {
            if (!ignoreTrust && !this.omemoStore.isDecidedOmemoIdentity(this.omemoManager, device, session.getIdentityKey())) {
                throw new UndecidedOmemoIdentityException(device);
            }
            if (!ignoreTrust && this.omemoStore.isTrustedOmemoIdentity(this.omemoManager, device, session.getIdentityKey())) {
                CiphertextTuple encryptedKey = session.encryptMessageKey(this.messageKey);
                this.keys.add(new OmemoElement.OmemoHeader.Key(encryptedKey.getCiphertext(), device.getDeviceId(), encryptedKey.isPreKeyMessage()));
            }
        }
    }

    public OmemoVAxolotlElement finish() {
        OmemoElement.OmemoHeader header = new OmemoElement.OmemoHeader(this.omemoManager.getDeviceId(), this.keys, this.initializationVector);
        return new OmemoVAxolotlElement(header, this.ciphertextMessage);
    }

    public static byte[] generateKey() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(128);
        return generator.generateKey().getEncoded();
    }

    public static byte[] generateIv() {
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        return iv;
    }

    public byte[] getCiphertextMessage() {
        return this.ciphertextMessage;
    }

    public byte[] getMessageKey() {
        return this.messageKey;
    }
}

