/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smackx.omemo.OmemoConfiguration;
import org.jivesoftware.smackx.omemo.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.CachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jxmpp.jid.BareJid;

public abstract class FileBasedOmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>
extends OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    private static final Logger LOGGER = Logger.getLogger(FileBasedOmemoStore.class.getSimpleName());
    private final FileHierarchy hierarchy;

    public FileBasedOmemoStore() {
        this(OmemoConfiguration.getFileBasedOmemoStoreDefaultPath());
    }

    public FileBasedOmemoStore(File basePath) {
        if (basePath == null) {
            throw new IllegalStateException("No FileBasedOmemoStoreDefaultPath set in OmemoConfiguration.");
        }
        this.hierarchy = new FileHierarchy(basePath);
    }

    @Override
    public boolean isFreshInstallation(OmemoManager omemoManager) {
        File userDirectory = this.hierarchy.getUserDeviceDirectory(omemoManager);
        File[] files = userDirectory.listFiles();
        return files == null || files.length == 0;
    }

    @Override
    public int getDefaultDeviceId(BareJid user) {
        try {
            return this.readInt(this.hierarchy.getDefaultDeviceIdPath(user));
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public void setDefaultDeviceId(BareJid user, int defaultDeviceId) {
        File defaultDeviceIdPath = this.hierarchy.getDefaultDeviceIdPath(user);
        if (defaultDeviceIdPath == null) {
            LOGGER.log(Level.SEVERE, "defaultDeviceIdPath is null!");
        }
        try {
            this.writeInt(defaultDeviceIdPath, defaultDeviceId);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write defaultDeviceId: " + e, e);
        }
    }

    @Override
    public int loadLastPreKeyId(OmemoManager omemoManager) {
        try {
            int l = this.readInt(this.hierarchy.getLastPreKeyIdPath(omemoManager));
            return l == -1 ? 0 : l;
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public void storeLastPreKeyId(OmemoManager omemoManager, int currentPreKeyId) {
        try {
            this.writeInt(this.hierarchy.getLastPreKeyIdPath(omemoManager), currentPreKeyId);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write lastPreKeyId: " + e, e);
        }
    }

    @Override
    public T_IdKeyPair loadOmemoIdentityKeyPair(OmemoManager omemoManager) throws CorruptedOmemoKeyException {
        File identityKeyPairPath = this.hierarchy.getIdentityKeyPairPath(omemoManager);
        try {
            byte[] bytes = this.readBytes(identityKeyPairPath);
            return bytes != null ? (T_IdKeyPair)this.keyUtil().identityKeyPairFromBytes(bytes) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void storeOmemoIdentityKeyPair(OmemoManager omemoManager, T_IdKeyPair identityKeyPair) {
        File identityKeyPairPath = this.hierarchy.getIdentityKeyPairPath(omemoManager);
        try {
            this.writeBytes(identityKeyPairPath, this.keyUtil().identityKeyPairToBytes(identityKeyPair));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write omemoIdentityKeyPair: " + e, e);
        }
    }

    @Override
    public T_IdKey loadOmemoIdentityKey(OmemoManager omemoManager, OmemoDevice device) throws CorruptedOmemoKeyException {
        File identityKeyPath = this.hierarchy.getContactsIdentityKeyPath(omemoManager, device);
        try {
            byte[] bytes = this.readBytes(identityKeyPath);
            return bytes != null ? (T_IdKey)this.keyUtil().identityKeyFromBytes(bytes) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void storeOmemoIdentityKey(OmemoManager omemoManager, OmemoDevice device, T_IdKey t_idKey) {
        File identityKeyPath = this.hierarchy.getContactsIdentityKeyPath(omemoManager, device);
        try {
            this.writeBytes(identityKeyPath, this.keyUtil().identityKeyToBytes(t_idKey));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write omemoIdentityKey of " + device + ": " + e, e);
        }
    }

    @Override
    public boolean isTrustedOmemoIdentity(OmemoManager omemoManager, OmemoDevice device, OmemoFingerprint fingerprint) {
        File trustPath = this.hierarchy.getContactsTrustPath(omemoManager, device);
        try {
            String depositedFingerprint = new String(this.readBytes(trustPath), "UTF-8");
            return depositedFingerprint.length() > 2 && depositedFingerprint.charAt(0) == '1' && new OmemoFingerprint(depositedFingerprint.substring(2)).equals(fingerprint);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isDecidedOmemoIdentity(OmemoManager omemoManager, OmemoDevice device, OmemoFingerprint fingerprint) {
        File trustPath = this.hierarchy.getContactsTrustPath(omemoManager, device);
        try {
            String depositedFingerprint = new String(this.readBytes(trustPath), "UTF-8");
            return depositedFingerprint.length() > 2 && (depositedFingerprint.charAt(0) == '1' || depositedFingerprint.charAt(0) == '2') && new OmemoFingerprint(depositedFingerprint.substring(2)).equals(fingerprint);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void trustOmemoIdentity(OmemoManager omemoManager, OmemoDevice device, OmemoFingerprint fingerprint) {
        File trustPath = this.hierarchy.getContactsTrustPath(omemoManager, device);
        try {
            this.writeBytes(trustPath, ("1 " + fingerprint.toString()).getBytes("UTF-8"));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not trust " + device + ": " + e, e);
        }
    }

    @Override
    public void distrustOmemoIdentity(OmemoManager omemoManager, OmemoDevice device, OmemoFingerprint fingerprint) {
        File trustPath = this.hierarchy.getContactsTrustPath(omemoManager, device);
        try {
            this.writeBytes(trustPath, ("2 " + fingerprint.toString()).getBytes("UTF-8"));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not distrust " + device + ": " + e, e);
        }
    }

    @Override
    public void setDateOfLastReceivedMessage(OmemoManager omemoManager, OmemoDevice from, Date date) {
        File lastMessageReceived = this.hierarchy.getLastMessageReceivedDatePath(omemoManager, from);
        try {
            this.writeLong(lastMessageReceived, date.getTime());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write date of last received message from " + from + ": " + e, e);
        }
    }

    @Override
    public Date getDateOfLastReceivedMessage(OmemoManager omemoManager, OmemoDevice from) {
        File lastMessageReceived = this.hierarchy.getLastMessageReceivedDatePath(omemoManager, from);
        try {
            long date = this.readLong(lastMessageReceived);
            return date != -1L ? new Date(date) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void setDateOfLastSignedPreKeyRenewal(OmemoManager omemoManager, Date date) {
        File lastSignedPreKeyRenewal = this.hierarchy.getLastSignedPreKeyRenewal(omemoManager);
        try {
            this.writeLong(lastSignedPreKeyRenewal, date.getTime());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write date of last singedPreKey renewal for " + omemoManager.getOwnDevice() + ": " + e, e);
        }
    }

    @Override
    public Date getDateOfLastSignedPreKeyRenewal(OmemoManager omemoManager) {
        File lastSignedPreKeyRenewal = this.hierarchy.getLastSignedPreKeyRenewal(omemoManager);
        try {
            long date = this.readLong(lastSignedPreKeyRenewal);
            return date != -1L ? new Date(date) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public T_PreKey loadOmemoPreKey(OmemoManager omemoManager, int preKeyId) {
        File preKeyPath = this.hierarchy.getPreKeyPath(omemoManager, preKeyId);
        try {
            byte[] bytes = this.readBytes(preKeyPath);
            return bytes != null ? (T_PreKey)this.keyUtil().preKeyFromBytes(bytes) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void storeOmemoPreKey(OmemoManager omemoManager, int preKeyId, T_PreKey t_preKey) {
        File preKeyPath = this.hierarchy.getPreKeyPath(omemoManager, preKeyId);
        try {
            this.writeBytes(preKeyPath, this.keyUtil().preKeyToBytes(t_preKey));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write preKey with id " + preKeyId + ": " + e, e);
        }
    }

    @Override
    public void removeOmemoPreKey(OmemoManager omemoManager, int preKeyId) {
        File preKeyPath = this.hierarchy.getPreKeyPath(omemoManager, preKeyId);
        preKeyPath.delete();
    }

    @Override
    public int loadCurrentSignedPreKeyId(OmemoManager omemoManager) {
        File currentSignedPreKeyIdPath = this.hierarchy.getCurrentSignedPreKeyIdPath(omemoManager);
        try {
            int i = this.readInt(currentSignedPreKeyIdPath);
            return i == -1 ? 0 : i;
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public void storeCurrentSignedPreKeyId(OmemoManager omemoManager, int currentSignedPreKeyId) {
        File currentSignedPreKeyIdPath = this.hierarchy.getCurrentSignedPreKeyIdPath(omemoManager);
        try {
            this.writeInt(currentSignedPreKeyIdPath, currentSignedPreKeyId);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write currentSignedPreKeyId " + currentSignedPreKeyId + " for " + omemoManager.getOwnDevice() + ": " + e, e);
        }
    }

    @Override
    public HashMap<Integer, T_PreKey> loadOmemoPreKeys(OmemoManager omemoManager) {
        File preKeyDirectory = this.hierarchy.getPreKeysDirectory(omemoManager);
        HashMap preKeys = new HashMap();
        if (preKeyDirectory == null) {
            return preKeys;
        }
        File[] keys = preKeyDirectory.listFiles();
        for (File f : keys != null ? keys : new File[]{}) {
            try {
                byte[] bytes = this.readBytes(f);
                if (bytes == null) continue;
                Object p = this.keyUtil().preKeyFromBytes(bytes);
                preKeys.put(Integer.parseInt(f.getName()), p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return preKeys;
    }

    @Override
    public T_SigPreKey loadOmemoSignedPreKey(OmemoManager omemoManager, int signedPreKeyId) {
        File signedPreKeyPath = new File(this.hierarchy.getSignedPreKeysDirectory(omemoManager), Integer.toString(signedPreKeyId));
        try {
            byte[] bytes = this.readBytes(signedPreKeyPath);
            return bytes != null ? (T_SigPreKey)this.keyUtil().signedPreKeyFromBytes(bytes) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public HashMap<Integer, T_SigPreKey> loadOmemoSignedPreKeys(OmemoManager omemoManager) {
        File signedPreKeysDirectory = this.hierarchy.getSignedPreKeysDirectory(omemoManager);
        HashMap signedPreKeys = new HashMap();
        if (signedPreKeysDirectory == null) {
            return signedPreKeys;
        }
        File[] keys = signedPreKeysDirectory.listFiles();
        for (File f : keys != null ? keys : new File[]{}) {
            try {
                byte[] bytes = this.readBytes(f);
                if (bytes == null) continue;
                Object p = this.keyUtil().signedPreKeyFromBytes(bytes);
                signedPreKeys.put(Integer.parseInt(f.getName()), p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return signedPreKeys;
    }

    @Override
    public void storeOmemoSignedPreKey(OmemoManager omemoManager, int signedPreKeyId, T_SigPreKey signedPreKey) {
        File signedPreKeyPath = new File(this.hierarchy.getSignedPreKeysDirectory(omemoManager), Integer.toString(signedPreKeyId));
        try {
            this.writeBytes(signedPreKeyPath, this.keyUtil().signedPreKeyToBytes(signedPreKey));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write signedPreKey " + signedPreKey + " for " + omemoManager.getOwnDevice() + ": " + e, e);
        }
    }

    @Override
    public void removeOmemoSignedPreKey(OmemoManager omemoManager, int signedPreKeyId) {
        File signedPreKeyPath = new File(this.hierarchy.getSignedPreKeysDirectory(omemoManager), Integer.toString(signedPreKeyId));
        signedPreKeyPath.delete();
    }

    @Override
    public T_Sess loadRawSession(OmemoManager omemoManager, OmemoDevice device) {
        File sessionPath = this.hierarchy.getContactsSessionPath(omemoManager, device);
        try {
            byte[] bytes = this.readBytes(sessionPath);
            return bytes != null ? (T_Sess)this.keyUtil().rawSessionFromBytes(bytes) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public HashMap<Integer, T_Sess> loadAllRawSessionsOf(OmemoManager omemoManager, BareJid contact) {
        File contactsDirectory = this.hierarchy.getContactsDir(omemoManager, contact);
        HashMap sessions = new HashMap();
        String[] devices = contactsDirectory.list();
        for (String deviceId : devices != null ? devices : new String[]{}) {
            int id;
            try {
                id = Integer.parseInt(deviceId);
            }
            catch (NumberFormatException e) {
                continue;
            }
            OmemoDevice device = new OmemoDevice(contact, id);
            File session = this.hierarchy.getContactsSessionPath(omemoManager, device);
            try {
                byte[] bytes = this.readBytes(session);
                if (bytes == null) continue;
                Object s = this.keyUtil().rawSessionFromBytes(bytes);
                sessions.put(id, s);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sessions;
    }

    @Override
    public void storeRawSession(OmemoManager omemoManager, OmemoDevice device, T_Sess session) {
        File sessionPath = this.hierarchy.getContactsSessionPath(omemoManager, device);
        try {
            this.writeBytes(sessionPath, this.keyUtil().rawSessionToBytes(session));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write session between our device " + omemoManager.getOwnDevice() + " and their device " + device + ": " + e.getMessage());
        }
    }

    @Override
    public void removeRawSession(OmemoManager omemoManager, OmemoDevice device) {
        File sessionPath = this.hierarchy.getContactsSessionPath(omemoManager, device);
        sessionPath.delete();
    }

    @Override
    public void removeAllRawSessionsOf(OmemoManager omemoManager, BareJid contact) {
        File contactsDirectory = this.hierarchy.getContactsDir(omemoManager, contact);
        String[] devices = contactsDirectory.list();
        for (String deviceId : devices != null ? devices : new String[]{}) {
            int id;
            try {
                id = Integer.parseInt(deviceId);
            }
            catch (NumberFormatException e) {
                continue;
            }
            OmemoDevice device = new OmemoDevice(contact, id);
            File session = this.hierarchy.getContactsSessionPath(omemoManager, device);
            session.delete();
        }
    }

    @Override
    public boolean containsRawSession(OmemoManager omemoManager, OmemoDevice device) {
        File session = this.hierarchy.getContactsSessionPath(omemoManager, device);
        return session.exists();
    }

    @Override
    public CachedDeviceList loadCachedDeviceList(OmemoManager omemoManager, BareJid contact) {
        CachedDeviceList cachedDeviceList = new CachedDeviceList();
        if (contact == null) {
            return null;
        }
        File activeDevicesPath = this.hierarchy.getContactsActiveDevicesPath(omemoManager, contact);
        try {
            cachedDeviceList.getActiveDevices().addAll(this.readIntegers(activeDevicesPath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File inactiveDevicesPath = this.hierarchy.getContactsInactiveDevicesPath(omemoManager, contact);
        try {
            cachedDeviceList.getInactiveDevices().addAll(this.readIntegers(inactiveDevicesPath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cachedDeviceList;
    }

    @Override
    public void storeCachedDeviceList(OmemoManager omemoManager, BareJid contact, CachedDeviceList deviceList) {
        if (contact == null) {
            return;
        }
        File activeDevices = this.hierarchy.getContactsActiveDevicesPath(omemoManager, contact);
        try {
            this.writeIntegers(activeDevices, deviceList.getActiveDevices());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write active devices of deviceList of " + contact + ": " + e.getMessage());
        }
        File inactiveDevices = this.hierarchy.getContactsInactiveDevicesPath(omemoManager, contact);
        try {
            this.writeIntegers(inactiveDevices, deviceList.getInactiveDevices());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write inactive devices of deviceList of " + contact + ": " + e.getMessage());
        }
    }

    @Override
    public void purgeOwnDeviceKeys(OmemoManager omemoManager) {
        File deviceDirectory = this.hierarchy.getUserDeviceDirectory(omemoManager);
        FileBasedOmemoStore.deleteDirectory(deviceDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInt(File target, int i) throws IOException {
        if (target == null) {
            throw new IOException("Could not write integer to null-path.");
        }
        FileHierarchy.createFile(target);
        IOException io = null;
        try (FilterOutputStream out = null;){
            out = new DataOutputStream(new FileOutputStream(target));
            ((DataOutputStream)out).writeInt(i);
        }
        if (io != null) {
            throw io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readInt(File target) throws IOException {
        if (target == null) {
            throw new IOException("Could not read integer from null-path.");
        }
        IOException io = null;
        int i = -1;
        try (FilterInputStream in = null;){
            in = new DataInputStream(new FileInputStream(target));
            i = ((DataInputStream)in).readInt();
        }
        if (io != null) {
            throw io;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLong(File target, long i) throws IOException {
        if (target == null) {
            throw new IOException("Could not write long to null-path.");
        }
        FileHierarchy.createFile(target);
        IOException io = null;
        try (FilterOutputStream out = null;){
            out = new DataOutputStream(new FileOutputStream(target));
            ((DataOutputStream)out).writeLong(i);
        }
        if (io != null) {
            throw io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readLong(File target) throws IOException {
        if (target == null) {
            throw new IOException("Could not read long from null-path.");
        }
        IOException io = null;
        long l = -1L;
        try (FilterInputStream in = null;){
            in = new DataInputStream(new FileInputStream(target));
            l = ((DataInputStream)in).readLong();
        }
        if (io != null) {
            throw io;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBytes(File target, byte[] bytes) throws IOException {
        if (target == null) {
            throw new IOException("Could not write bytes to null-path.");
        }
        FileHierarchy.createFile(target);
        IOException io = null;
        try (FilterOutputStream out = null;){
            out = new DataOutputStream(new FileOutputStream(target));
            out.write(bytes);
        }
        if (io != null) {
            throw io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(File target) throws IOException {
        if (target == null) {
            throw new IOException("Could not read bytes from null-path.");
        }
        byte[] b = null;
        IOException io = null;
        try (FilterInputStream in = null;){
            in = new DataInputStream(new FileInputStream(target));
            b = new byte[in.available()];
            ((DataInputStream)in).read(b);
        }
        if (io != null) {
            throw io;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIntegers(File target, Set<Integer> integers) throws IOException {
        if (target == null) {
            throw new IOException("Could not write integers to null-path.");
        }
        IOException io = null;
        try (FilterOutputStream out = null;){
            out = new DataOutputStream(new FileOutputStream(target));
            for (int i : integers) {
                ((DataOutputStream)out).writeInt(i);
            }
        }
        if (io != null) {
            throw io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Integer> readIntegers(File target) throws IOException {
        if (target == null) {
            throw new IOException("Could not write integers to null-path.");
        }
        HashSet<Integer> integers = new HashSet<Integer>();
        IOException io = null;
        try (FilterInputStream in = null;){
            in = new DataInputStream(new FileInputStream(target));
            try {
                while (true) {
                    integers.add(((DataInputStream)in).readInt());
                }
            }
            catch (EOFException eOFException) {
                if (in != null) {
                    in.close();
                }
            }
        }
        if (io != null) {
            throw io;
        }
        return integers;
    }

    public static void deleteDirectory(File root) {
        Stack<File> stack = new Stack<File>();
        stack.push(root);
        while (!stack.isEmpty()) {
            if (((File)stack.lastElement()).isDirectory()) {
                File[] currList = ((File)stack.lastElement()).listFiles();
                if (currList != null && currList.length > 0) {
                    for (File curr : currList) {
                        stack.push(curr);
                    }
                    continue;
                }
                ((File)stack.pop()).delete();
                continue;
            }
            ((File)stack.pop()).delete();
        }
    }

    public static class FileHierarchy {
        static final String STORE = "OMEMO_Store";
        static final String CONTACTS = "contacts";
        static final String DEFAULT_DEVICE_ID = "defaultDeviceId";
        static final String IDENTITY_KEY = "identityKey";
        static final String IDENTITY_KEY_PAIR = "identityKeyPair";
        static final String PRE_KEYS = "preKeys";
        static final String LAST_MESSAGE_RECEVIED_DATE = "lastMessageReceivedDate";
        static final String LAST_PRE_KEY_ID = "lastPreKeyId";
        static final String SIGNED_PRE_KEYS = "signedPreKeys";
        static final String CURRENT_SIGNED_PRE_KEY_ID = "currentSignedPreKeyId";
        static final String LAST_SIGNED_PRE_KEY_RENEWAL = "lastSignedPreKeyRenewal";
        static final String SESSION = "session";
        static final String DEVICE_LIST_ACTIVE = "activeDevices";
        static final String DEVICE_LIST_INAVTIVE = "inactiveDevices";
        static final String TRUST = "trust";
        File basePath;

        FileHierarchy(File basePath) {
            this.basePath = basePath;
            basePath.mkdirs();
        }

        File getStoreDirectory() {
            return FileHierarchy.createDirectory(this.basePath, STORE);
        }

        File getUserDirectory(BareJid bareJid) {
            return FileHierarchy.createDirectory(this.getStoreDirectory(), bareJid.toString());
        }

        File getUserDeviceDirectory(OmemoManager omemoManager) {
            return FileHierarchy.createDirectory(this.getUserDirectory(omemoManager.getOwnJid()), Integer.toString(omemoManager.getDeviceId()));
        }

        File getContactsDir(OmemoManager omemoManager) {
            return FileHierarchy.createDirectory(this.getUserDeviceDirectory(omemoManager), CONTACTS);
        }

        File getContactsDir(OmemoManager omemoManager, BareJid contact) {
            return FileHierarchy.createDirectory(this.getContactsDir(omemoManager), contact.toString());
        }

        File getContactsDir(OmemoManager omemoManager, OmemoDevice omemoDevice) {
            return FileHierarchy.createDirectory(this.getContactsDir(omemoManager, omemoDevice.getJid()), Integer.toString(omemoDevice.getDeviceId()));
        }

        File getIdentityKeyPairPath(OmemoManager omemoManager) {
            return new File(this.getUserDeviceDirectory(omemoManager), IDENTITY_KEY_PAIR);
        }

        File getPreKeysDirectory(OmemoManager omemoManager) {
            return FileHierarchy.createDirectory(this.getUserDeviceDirectory(omemoManager), PRE_KEYS);
        }

        File getPreKeyPath(OmemoManager omemoManager, int preKeyId) {
            return new File(this.getPreKeysDirectory(omemoManager), Integer.toString(preKeyId));
        }

        File getLastMessageReceivedDatePath(OmemoManager omemoManager, OmemoDevice device) {
            return new File(this.getContactsDir(omemoManager, device), LAST_MESSAGE_RECEVIED_DATE);
        }

        File getLastPreKeyIdPath(OmemoManager omemoManager) {
            return new File(this.getUserDeviceDirectory(omemoManager), LAST_PRE_KEY_ID);
        }

        File getSignedPreKeysDirectory(OmemoManager omemoManager) {
            return FileHierarchy.createDirectory(this.getUserDeviceDirectory(omemoManager), SIGNED_PRE_KEYS);
        }

        File getCurrentSignedPreKeyIdPath(OmemoManager omemoManager) {
            return new File(this.getUserDeviceDirectory(omemoManager), CURRENT_SIGNED_PRE_KEY_ID);
        }

        File getLastSignedPreKeyRenewal(OmemoManager omemoManager) {
            return new File(this.getUserDeviceDirectory(omemoManager), LAST_SIGNED_PRE_KEY_RENEWAL);
        }

        File getDefaultDeviceIdPath(BareJid bareJid) {
            return new File(this.getUserDirectory(bareJid), DEFAULT_DEVICE_ID);
        }

        File getContactsIdentityKeyPath(OmemoManager omemoManager, OmemoDevice omemoDevice) {
            return new File(this.getContactsDir(omemoManager, omemoDevice), IDENTITY_KEY);
        }

        File getContactsSessionPath(OmemoManager omemoManager, OmemoDevice omemoDevice) {
            return new File(this.getContactsDir(omemoManager, omemoDevice), SESSION);
        }

        File getContactsActiveDevicesPath(OmemoManager omemoManager, BareJid contact) {
            return new File(this.getContactsDir(omemoManager, contact), DEVICE_LIST_ACTIVE);
        }

        File getContactsInactiveDevicesPath(OmemoManager omemoManager, BareJid contact) {
            return new File(this.getContactsDir(omemoManager, contact), DEVICE_LIST_INAVTIVE);
        }

        File getContactsTrustPath(OmemoManager omemoManager, OmemoDevice omemoDevice) {
            return new File(this.getContactsDir(omemoManager, omemoDevice), TRUST);
        }

        private static File createFile(File f) throws IOException {
            File p = f.getParentFile();
            FileHierarchy.createDirectory(p);
            f.createNewFile();
            return f;
        }

        private static File createFile(File dir, String filename) throws IOException {
            return FileHierarchy.createFile(new File(dir, filename));
        }

        private static File createDirectory(File dir, String subdir) {
            File f = new File(dir, subdir);
            return FileHierarchy.createDirectory(f);
        }

        private static File createDirectory(File f) {
            if (f.exists() && f.isDirectory()) {
                return f;
            }
            f.mkdirs();
            return f;
        }
    }
}

