/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.message_markup.element;

import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.message_markup.element.MarkupElement;

public class ListElement
implements MarkupElement.MarkupChildElement {
    public static final String ELEMENT = "list";
    public static final String ELEM_LI = "li";
    private final int start;
    private final int end;
    private final List<ListEntryElement> entries;

    public ListElement(int start, int end, List<ListEntryElement> entries) {
        this.start = start;
        this.end = end;
        this.entries = Collections.unmodifiableList(entries);
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public List<ListEntryElement> getEntries() {
        return this.entries;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public CharSequence toXML(String enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder();
        xml.halfOpenElement((NamedElement)this);
        xml.attribute("start", this.getStart());
        xml.attribute("end", this.getEnd());
        xml.rightAngleBracket();
        for (ListEntryElement li : this.getEntries()) {
            xml.append(li.toXML(null));
        }
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public static class ListEntryElement
    implements NamedElement {
        private final int start;

        public ListEntryElement(int start) {
            this.start = start;
        }

        public int getStart() {
            return this.start;
        }

        public String getElementName() {
            return ListElement.ELEM_LI;
        }

        public XmlStringBuilder toXML(String enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement((NamedElement)this);
            xml.attribute("start", this.getStart());
            xml.closeEmptyElement();
            return xml;
        }
    }
}

