/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.List;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.util.ResultSyncPoint;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.junit.Assert;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public class MultiUserChatIntegrationTest
extends AbstractSmackIntegrationTest {
    private final String randomString = StringUtils.insecureRandomString((int)6);
    private final MultiUserChatManager mucManagerOne = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conOne);
    private final MultiUserChatManager mucManagerTwo = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conTwo);
    private final DomainBareJid mucService;

    public MultiUserChatIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        super(environment);
        List services = this.mucManagerOne.getMucServiceDomains();
        if (services.isEmpty()) {
            throw new TestNotPossibleException("No MUC (XEP-45) service found");
        }
        this.mucService = (DomainBareJid)services.get(0);
    }

    @SmackIntegrationTest
    public void mucJoinLeaveTest() throws XmppStringprepException, MultiUserChatException.NotAMucServiceException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.MucNotJoinedException {
        EntityBareJid mucAddress = JidCreate.entityBareFrom((Localpart)Localpart.from((String)("smack-inttest-join-leave-" + this.randomString)), (Domainpart)this.mucService.getDomain());
        MultiUserChat muc = this.mucManagerOne.getMultiUserChat(mucAddress);
        muc.join(Resourcepart.from((String)"nick-one"));
        Presence reflectedLeavePresence = muc.leaveSync();
        MUCUser mucUser = MUCUser.from((Stanza)reflectedLeavePresence);
        Assert.assertNotNull((Object)mucUser);
        Assert.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110));
    }

    @SmackIntegrationTest
    public void mucTest() throws Exception {
        EntityBareJid mucAddress = JidCreate.entityBareFrom((Localpart)Localpart.from((String)("smack-inttest-" + this.randomString)), (Domainpart)this.mucService.getDomain());
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final String mucMessage = "Smack Integration Test MUC Test Message " + this.randomString;
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByTwo.addMessageListener(new MessageListener(){

            public void processMessage(Message message) {
                String body = message.getBody();
                if (mucMessage.equals(body)) {
                    resultSyncPoint.signal(body);
                }
            }
        });
        MultiUserChat.MucCreateConfigFormHandle handle = mucAsSeenByOne.createOrJoin(Resourcepart.from((String)("one-" + this.randomString)));
        if (handle != null) {
            handle.makeInstant();
        }
        mucAsSeenByTwo.join(Resourcepart.from((String)("two-" + this.randomString)));
        mucAsSeenByOne.sendMessage(mucMessage);
        resultSyncPoint.waitForResult(this.timeout);
        mucAsSeenByOne.leave();
        mucAsSeenByTwo.leave();
    }
}

