/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muclight.provider;

import java.util.HashMap;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.muclight.MUCLightAffiliation;
import org.jivesoftware.smackx.muclight.MUCLightRoomConfiguration;
import org.jivesoftware.smackx.muclight.element.MUCLightInfoIQ;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.xmlpull.v1.XmlPullParser;

public class MUCLightInfoIQProvider
extends IQProvider<MUCLightInfoIQ> {
    public MUCLightInfoIQ parse(XmlPullParser parser, int initialDepth) throws Exception {
        String version = null;
        String roomName = null;
        String subject = null;
        HashMap<String, String> customConfigs = null;
        HashMap<Jid, MUCLightAffiliation> occupants = new HashMap();
        while (true) {
            int eventType;
            if ((eventType = parser.next()) == 2) {
                if (parser.getName().equals("version")) {
                    version = parser.nextText();
                }
                if (parser.getName().equals("configuration")) {
                    int depth = parser.getDepth();
                    while (true) {
                        if ((eventType = parser.next()) == 2) {
                            if (parser.getName().equals("roomname")) {
                                roomName = parser.nextText();
                                continue;
                            }
                            if (parser.getName().equals("subject")) {
                                subject = parser.nextText();
                                continue;
                            }
                            if (customConfigs == null) {
                                customConfigs = new HashMap<String, String>();
                            }
                            customConfigs.put(parser.getName(), parser.nextText());
                            continue;
                        }
                        if (eventType == 3 && parser.getDepth() == depth) break;
                    }
                }
                if (!parser.getName().equals("occupants")) continue;
                occupants = MUCLightInfoIQProvider.iterateOccupants(parser);
                continue;
            }
            if (eventType == 3 && parser.getDepth() == initialDepth) break;
        }
        return new MUCLightInfoIQ(version, new MUCLightRoomConfiguration(roomName, subject, customConfigs), occupants);
    }

    private static HashMap<Jid, MUCLightAffiliation> iterateOccupants(XmlPullParser parser) throws Exception {
        HashMap<Jid, MUCLightAffiliation> occupants = new HashMap<Jid, MUCLightAffiliation>();
        int depth = parser.getDepth();
        while (true) {
            int eventType;
            if ((eventType = parser.next()) == 2) {
                if (!parser.getName().equals("user")) continue;
                MUCLightAffiliation affiliation = MUCLightAffiliation.fromString(parser.getAttributeValue("", "affiliation"));
                occupants.put(JidCreate.from((String)parser.nextText()), affiliation);
                continue;
            }
            if (eventType == 3 && parser.getDepth() == depth) break;
        }
        return occupants;
    }
}

