/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.internal;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.omemo.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.element.OmemoElement;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.MultipleCryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.NoRawSessionException;
import org.jivesoftware.smackx.omemo.internal.CipherAndAuthTag;
import org.jivesoftware.smackx.omemo.internal.CiphertextTuple;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;

public abstract class OmemoSession<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    protected final T_Ciph cipher;
    protected final OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> omemoStore;
    protected final OmemoDevice remoteDevice;
    protected final OmemoManager omemoManager;
    protected T_IdKey identityKey;
    protected int preKeyId = -1;

    public OmemoSession(OmemoManager omemoManager, OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> omemoStore, OmemoDevice remoteDevice, T_IdKey identityKey) {
        this(omemoManager, omemoStore, remoteDevice);
        this.identityKey = identityKey;
    }

    public OmemoSession(OmemoManager omemoManager, OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> omemoStore, OmemoDevice remoteDevice) {
        this.omemoManager = omemoManager;
        this.omemoStore = omemoStore;
        this.remoteDevice = remoteDevice;
        this.cipher = this.createCipher(remoteDevice);
    }

    public CipherAndAuthTag decryptTransportedKey(OmemoElement element, int keyId) throws CryptoFailedException, NoRawSessionException {
        byte[] unpackedKey = null;
        ArrayList<CryptoFailedException> decryptExceptions = new ArrayList<CryptoFailedException>();
        ArrayList<OmemoElement.OmemoHeader.Key> keys = element.getHeader().getKeys();
        for (OmemoElement.OmemoHeader.Key k : keys) {
            if (k.getId() != keyId) continue;
            try {
                unpackedKey = this.decryptMessageKey(k.getData());
                break;
            }
            catch (CryptoFailedException e) {
                decryptExceptions.add(e);
            }
        }
        if (unpackedKey == null) {
            if (!decryptExceptions.isEmpty()) {
                throw MultipleCryptoFailedException.from(decryptExceptions);
            }
            throw new CryptoFailedException("Transported key could not be decrypted, since no provided message key. Provides keys: " + keys);
        }
        byte[] messageKey = new byte[16];
        byte[] authTag = null;
        if (unpackedKey.length == 32) {
            authTag = new byte[16];
            System.arraycopy(unpackedKey, 0, messageKey, 0, 16);
            System.arraycopy(unpackedKey, 16, authTag, 0, 16);
        } else if (element.isKeyTransportElement() && unpackedKey.length == 16) {
            messageKey = unpackedKey;
        } else {
            throw new CryptoFailedException("MessageKey has wrong length: " + unpackedKey.length + ". Probably legacy auth tag format.");
        }
        return new CipherAndAuthTag(messageKey, element.getHeader().getIv(), authTag);
    }

    public static Message decryptMessageElement(OmemoElement element, CipherAndAuthTag cipherAndAuthTag) throws CryptoFailedException {
        if (!element.isMessageElement()) {
            throw new IllegalArgumentException("decryptMessageElement cannot decrypt OmemoElement which is no MessageElement!");
        }
        if (cipherAndAuthTag.getAuthTag() == null || cipherAndAuthTag.getAuthTag().length != 16) {
            throw new CryptoFailedException("AuthenticationTag is null or has wrong length: " + (cipherAndAuthTag.getAuthTag() == null ? "null" : Integer.valueOf(cipherAndAuthTag.getAuthTag().length)));
        }
        byte[] encryptedBody = new byte[element.getPayload().length + 16];
        byte[] payload = element.getPayload();
        System.arraycopy(payload, 0, encryptedBody, 0, payload.length);
        System.arraycopy(cipherAndAuthTag.getAuthTag(), 0, encryptedBody, payload.length, 16);
        try {
            String plaintext = new String(cipherAndAuthTag.getCipher().doFinal(encryptedBody), "UTF-8");
            Message decrypted = new Message();
            decrypted.setBody(plaintext);
            return decrypted;
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException e) {
            throw new CryptoFailedException("decryptMessageElement could not decipher message body: " + e.getMessage());
        }
    }

    public Message decryptMessageElement(OmemoElement element, int keyId) throws CryptoFailedException, NoRawSessionException {
        if (!element.isMessageElement()) {
            throw new IllegalArgumentException("OmemoElement is not a messageElement!");
        }
        CipherAndAuthTag cipherAndAuthTag = this.decryptTransportedKey(element, keyId);
        return OmemoSession.decryptMessageElement(element, cipherAndAuthTag);
    }

    public abstract T_Ciph createCipher(OmemoDevice var1);

    public int getPreKeyId() {
        return this.preKeyId;
    }

    public abstract CiphertextTuple encryptMessageKey(byte[] var1) throws CryptoFailedException;

    public abstract byte[] decryptMessageKey(byte[] var1) throws CryptoFailedException, NoRawSessionException;

    public T_IdKey getIdentityKey() {
        return this.identityKey;
    }

    public void setIdentityKey(T_IdKey identityKey) {
        this.identityKey = identityKey;
    }

    public OmemoFingerprint getFingerprint() {
        return this.identityKey != null ? this.omemoStore.keyUtil().getFingerprint(this.identityKey) : null;
    }
}

