/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.data.provider;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.iot.data.element.IoTDataField;
import org.jivesoftware.smackx.iot.data.element.IoTFieldsExtension;
import org.jivesoftware.smackx.iot.data.element.NodeElement;
import org.jivesoftware.smackx.iot.data.element.TimestampElement;
import org.jivesoftware.smackx.iot.element.NodeInfo;
import org.jivesoftware.smackx.iot.parser.NodeInfoParser;
import org.jxmpp.util.XmppDateTime;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class IoTFieldsExtensionProvider
extends ExtensionElementProvider<IoTFieldsExtension> {
    private static final Logger LOGGER = Logger.getLogger(IoTFieldsExtensionProvider.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    public IoTFieldsExtension parse(XmlPullParser parser, int initialDepth) throws Exception {
        int seqNr = ParserUtils.getIntegerAttributeOrThrow((XmlPullParser)parser, (String)"seqnr", (String)"IoT data request <accepted/> without sequence number");
        boolean done = ParserUtils.getBooleanAttribute((XmlPullParser)parser, (String)"done", (boolean)false);
        ArrayList<NodeElement> nodes = new ArrayList<NodeElement>();
        while (true) {
            int eventType = parser.next();
            String name = parser.getName();
            block0 : switch (eventType) {
                case 2: {
                    switch (name) {
                        case "node": {
                            NodeElement node = this.parseNode(parser);
                            nodes.add(node);
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return new IoTFieldsExtension(seqNr, done, nodes);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public NodeElement parseNode(XmlPullParser parser) throws XmlPullParserException, IOException, ParseException {
        int initialDepth = parser.getDepth();
        NodeInfo nodeInfo = NodeInfoParser.parse(parser);
        ArrayList<TimestampElement> timestampElements = new ArrayList<TimestampElement>();
        while (true) {
            int eventType = parser.next();
            String name = parser.getName();
            block0 : switch (eventType) {
                case 2: {
                    switch (name) {
                        case "timestamp": {
                            TimestampElement timestampElement = this.parseTimestampElement(parser);
                            timestampElements.add(timestampElement);
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return new NodeElement(nodeInfo, timestampElements);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public TimestampElement parseTimestampElement(XmlPullParser parser) throws ParseException, XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        String dateString = parser.getAttributeValue(null, "value");
        Date date = XmppDateTime.parseDate((String)dateString);
        ArrayList<void> fields = new ArrayList<void>();
        while (true) {
            int eventType = parser.next();
            String name = parser.getName();
            switch (eventType) {
                case 2: {
                    void var8_8;
                    Object var8_9 = null;
                    String fieldName = parser.getAttributeValue(null, "name");
                    String fieldValue = parser.getAttributeValue(null, "value");
                    switch (name) {
                        case "int": {
                            boolean bl = Integer.parseInt(fieldValue);
                            IoTDataField.IntField intField = new IoTDataField.IntField(fieldName, bl ? 1 : 0);
                            break;
                        }
                        case "boolean": {
                            boolean bl = Boolean.parseBoolean(fieldValue);
                            IoTDataField.BooleanField booleanField = new IoTDataField.BooleanField(fieldName, bl);
                            break;
                        }
                        default: {
                            LOGGER.warning("IoT Data field type '" + name + "' not implement yet. Ignoring.");
                        }
                    }
                    if (var8_8 == null) break;
                    fields.add(var8_8);
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return new TimestampElement(date, fields);
                }
            }
        }
    }
}

