/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.sid;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.ToTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.sid.element.OriginIdElement;

public final class StableUniqueStanzaIdManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:sid:0";
    private static final Map<XMPPConnection, StableUniqueStanzaIdManager> INSTANCES = new WeakHashMap<XMPPConnection, StableUniqueStanzaIdManager>();
    private static final StanzaFilter OUTGOING_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL_OR_CHAT_OR_HEADLINE, ToTypeFilter.ENTITY_FULL_OR_BARE_JID});
    private static final StanzaListener ADD_ORIGIN_ID_INTERCEPTOR = new StanzaListener(){

        public void processStanza(Stanza stanza) {
            Message message = (Message)stanza;
            OriginIdElement.addOriginId(message);
        }
    };

    private StableUniqueStanzaIdManager(XMPPConnection connection) {
        super(connection);
        this.enable();
    }

    public static StableUniqueStanzaIdManager getInstanceFor(XMPPConnection connection) {
        StableUniqueStanzaIdManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new StableUniqueStanzaIdManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public synchronized void enable() {
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).addFeature(NAMESPACE);
        AndFilter filter = new AndFilter(new StanzaFilter[]{OUTGOING_FILTER, new NotFilter(OUTGOING_FILTER)});
        this.connection().addStanzaInterceptor(ADD_ORIGIN_ID_INTERCEPTOR, (StanzaFilter)filter);
    }

    public synchronized void disable() {
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).removeFeature(NAMESPACE);
        this.connection().removeStanzaInterceptor(ADD_ORIGIN_ID_INTERCEPTOR);
    }

    public synchronized boolean isEnabled() {
        ServiceDiscoveryManager disco = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection());
        return disco.includesFeature(NAMESPACE);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                StableUniqueStanzaIdManager.getInstanceFor(connection);
            }
        });
    }
}

