/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.util.Date;
import junit.framework.TestCase;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.omemo.AbstractOmemoIntegrationTest;
import org.jivesoftware.smackx.omemo.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.OmemoIntegrationTestHelper;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.OmemoStore;

public class OmemoStoreTest
extends AbstractOmemoIntegrationTest {
    private OmemoManager alice;
    private OmemoManager bob;

    public OmemoStoreTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, TestNotPossibleException {
        super(environment);
    }

    @Override
    public void before() {
        this.alice = OmemoManager.getInstanceFor((XMPPConnection)this.conOne);
        this.bob = OmemoManager.getInstanceFor((XMPPConnection)this.conOne);
    }

    @SmackIntegrationTest
    public void storeTest() throws Exception {
        TestCase.assertEquals((String)"Creating an OmemoManager without MUST have set the default deviceId.", (int)this.alice.getDeviceId(), (int)OmemoService.getInstance().getOmemoStoreBackend().getDefaultDeviceId(this.alice.getOwnJid()));
        TestCase.assertEquals((String)"OmemoManager must be equal, since both got created without giving a deviceId.", (Object)this.alice, (Object)this.bob);
        OmemoService.getInstance().getOmemoStoreBackend().setDefaultDeviceId(this.alice.getOwnJid(), -1);
        this.alice.shutdown();
        this.alice = OmemoManager.getInstanceFor((XMPPConnection)this.conOne);
        TestCase.assertNotSame((String)"Instantiating OmemoManager without deviceId MUST assign random deviceId.", (Object)this.alice.getDeviceId(), (Object)this.bob.getDeviceId());
        OmemoStore store = OmemoService.getInstance().getOmemoStoreBackend();
        OmemoFingerprint finger = new OmemoFingerprint("FINGER");
        store.setDefaultDeviceId(this.alice.getOwnJid(), 777);
        TestCase.assertEquals((String)"defaultDeviceId setting/getting must equal.", (int)777, (int)store.getDefaultDeviceId(this.alice.getOwnJid()));
        this.bob.shutdown();
        this.bob = OmemoManager.getInstanceFor((XMPPConnection)this.conTwo, (Integer)998);
        TestCase.assertFalse((String)"Bobs device MUST be undecided at this point", (boolean)store.isDecidedOmemoIdentity(this.alice, this.bob.getOwnDevice(), finger));
        TestCase.assertFalse((String)"Bobs device MUST not be trusted at this point", (boolean)store.isTrustedOmemoIdentity(this.alice, this.bob.getOwnDevice(), finger));
        store.trustOmemoIdentity(this.alice, this.bob.getOwnDevice(), finger);
        TestCase.assertTrue((String)"Bobs device MUST be trusted at this point.", (boolean)store.isTrustedOmemoIdentity(this.alice, this.bob.getOwnDevice(), finger));
        TestCase.assertTrue((String)"Bobs device MUST be decided at this point.", (boolean)store.isDecidedOmemoIdentity(this.alice, this.bob.getOwnDevice(), finger));
        store.distrustOmemoIdentity(this.alice, this.bob.getOwnDevice(), finger);
        TestCase.assertFalse((String)"Bobs device MUST be untrusted at this point.", (boolean)store.isTrustedOmemoIdentity(this.alice, this.bob.getOwnDevice(), finger));
        TestCase.assertNull((String)"Date of last received message must be null when no message was received ever.", (Object)store.getDateOfLastReceivedMessage(this.alice, this.bob.getOwnDevice()));
        Date now = new Date();
        store.setDateOfLastReceivedMessage(this.alice, this.bob.getOwnDevice(), now);
        TestCase.assertEquals((String)"Date of last received message must match the one we set.", (Object)now, (Object)store.getDateOfLastReceivedMessage(this.alice, this.bob.getOwnDevice()));
        TestCase.assertNull((String)"Date of last signed preKey renewal must be null.", (Object)store.getDateOfLastSignedPreKeyRenewal(this.alice));
        store.setDateOfLastSignedPreKeyRenewal(this.alice, now);
        TestCase.assertEquals((String)"Date of last signed preKey renewal must match our date.", (Object)now, (Object)store.getDateOfLastSignedPreKeyRenewal(this.alice));
        TestCase.assertNull((String)"IdentityKeyPair must be null at this point.", (Object)store.loadOmemoIdentityKeyPair(this.alice));
        TestCase.assertNull((String)"IdentityKey of contact must be null at this point.", (Object)store.loadOmemoIdentityKey(this.alice, this.bob.getOwnDevice()));
        TestCase.assertEquals((String)"PreKeys list must be of length 0 at this point.", (int)0, (int)store.loadOmemoPreKeys(this.alice).size());
        TestCase.assertEquals((String)"SignedPreKeys list must be of length 0 at this point.", (int)0, (int)store.loadOmemoSignedPreKeys(this.alice).size());
        TestCase.assertNotNull((String)"Generated IdentityKeyPair must not be null.", (Object)store.generateOmemoIdentityKeyPair());
        TestCase.assertEquals((String)"Generated PreKey list must be of correct length.", (int)100, (int)store.generateOmemoPreKeys(1, 100).size());
        TestCase.assertEquals((String)"LastPreKeyId must be 0 at this point.", (int)0, (int)store.loadLastPreKeyId(this.alice));
        store.storeLastPreKeyId(this.alice, 1234);
        Thread.sleep(100L);
        TestCase.assertEquals((String)"LastPreKeyId set/get must equal.", (int)1234, (int)store.loadLastPreKeyId(this.alice));
        store.storeLastPreKeyId(this.alice, 0);
        TestCase.assertEquals((String)"CurrentSignedPreKeyId must be 0 at this point.", (int)0, (int)store.loadCurrentSignedPreKeyId(this.alice));
        store.storeCurrentSignedPreKeyId(this.alice, 554);
        Thread.sleep(100L);
        TestCase.assertEquals((String)"CurrentSignedPreKeyId must match the value we set.", (int)554, (int)store.loadCurrentSignedPreKeyId(this.alice));
        store.storeCurrentSignedPreKeyId(this.alice, 0);
        OmemoIntegrationTestHelper.deletePath(this.alice);
        OmemoIntegrationTestHelper.setUpOmemoManager(this.alice);
        TestCase.assertNotNull((String)"IdentityKeyPair must not be null after initialization", (Object)store.loadOmemoIdentityKeyPair(this.alice));
        TestCase.assertNotSame((String)"LastPreKeyId must not be 0 after initialization.", (Object)0, (Object)store.loadLastPreKeyId(this.alice));
        TestCase.assertNotSame((String)"currentSignedPreKeyId must not be 0 after initialization.", (Object)0, (Object)store.loadCurrentSignedPreKeyId(this.alice));
        TestCase.assertNotNull((String)"The last PreKey must not be null.", (Object)store.loadOmemoPreKey(this.alice, store.loadLastPreKeyId(this.alice) - 1));
        TestCase.assertNotNull((String)"The current signedPreKey must not be null.", (Object)store.loadOmemoSignedPreKey(this.alice, store.loadCurrentSignedPreKeyId(this.alice)));
    }

    @Override
    public void after() {
        OmemoIntegrationTestHelper.cleanServerSideTraces(this.alice);
        OmemoIntegrationTestHelper.cleanServerSideTraces(this.bob);
        this.alice.shutdown();
        this.bob.shutdown();
    }
}

