/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hoxt.provider;

import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.hoxt.packet.HttpMethod;
import org.jivesoftware.smackx.hoxt.packet.HttpOverXmppReq;
import org.jivesoftware.smackx.hoxt.provider.AbstractHttpOverXmppProvider;
import org.xmlpull.v1.XmlPullParser;

public class HttpOverXmppReqProvider
extends AbstractHttpOverXmppProvider<HttpOverXmppReq> {
    private static final String ATTRIBUTE_METHOD = "method";
    private static final String ATTRIBUTE_RESOURCE = "resource";
    private static final String ATTRIBUTE_MAX_CHUNK_SIZE = "maxChunkSize";

    public HttpOverXmppReq parse(XmlPullParser parser, int initialDepth) throws Exception {
        String maxChunkSize;
        HttpOverXmppReq.Builder builder = HttpOverXmppReq.builder();
        builder.setResource(parser.getAttributeValue("", ATTRIBUTE_RESOURCE));
        builder.setVersion(parser.getAttributeValue("", "version"));
        String method = parser.getAttributeValue("", ATTRIBUTE_METHOD);
        builder.setMethod(HttpMethod.valueOf(method));
        String sipubStr = parser.getAttributeValue("", "sipub");
        String ibbStr = parser.getAttributeValue("", "ibb");
        String jingleStr = parser.getAttributeValue("", "jingle");
        if (sipubStr != null) {
            builder.setSipub(ParserUtils.parseXmlBoolean((String)sipubStr));
        }
        if (ibbStr != null) {
            builder.setIbb(ParserUtils.parseXmlBoolean((String)ibbStr));
        }
        if (jingleStr != null) {
            builder.setJingle(ParserUtils.parseXmlBoolean((String)jingleStr));
        }
        if ((maxChunkSize = parser.getAttributeValue("", ATTRIBUTE_MAX_CHUNK_SIZE)) != null) {
            builder.setMaxChunkSize(Integer.parseInt(maxChunkSize));
        }
        builder.setHeaders(this.parseHeaders(parser));
        builder.setData(this.parseData(parser));
        return builder.build();
    }
}

