/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.element;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public abstract class OmemoBundleElement
implements ExtensionElement {
    public static final String BUNDLE = "bundle";
    public static final String SIGNED_PRE_KEY_PUB = "signedPreKeyPublic";
    public static final String SIGNED_PRE_KEY_ID = "signedPreKeyId";
    public static final String SIGNED_PRE_KEY_SIG = "signedPreKeySignature";
    public static final String IDENTITY_KEY = "identityKey";
    public static final String PRE_KEYS = "prekeys";
    public static final String PRE_KEY_PUB = "preKeyPublic";
    public static final String PRE_KEY_ID = "preKeyId";
    private final int signedPreKeyId;
    private final String signedPreKeyB64;
    private byte[] signedPreKey;
    private final String signedPreKeySignatureB64;
    private byte[] signedPreKeySignature;
    private final String identityKeyB64;
    private byte[] identityKey;
    private final HashMap<Integer, String> preKeysB64;
    private HashMap<Integer, byte[]> preKeys;

    public OmemoBundleElement(int signedPreKeyId, String signedPreKeyB64, String signedPreKeySigB64, String identityKeyB64, HashMap<Integer, String> preKeysB64) {
        this.signedPreKeyId = signedPreKeyId;
        this.signedPreKeyB64 = signedPreKeyB64;
        this.signedPreKeySignatureB64 = signedPreKeySigB64;
        this.identityKeyB64 = identityKeyB64;
        this.preKeysB64 = preKeysB64;
    }

    public OmemoBundleElement(int signedPreKeyId, byte[] signedPreKey, byte[] signedPreKeySig, byte[] identityKey, HashMap<Integer, byte[]> preKeys) {
        this.signedPreKeyId = signedPreKeyId;
        this.signedPreKey = signedPreKey;
        this.signedPreKeyB64 = Base64.encodeToString((byte[])signedPreKey);
        this.signedPreKeySignature = signedPreKeySig;
        this.signedPreKeySignatureB64 = Base64.encodeToString((byte[])this.signedPreKeySignature);
        this.identityKey = identityKey;
        this.identityKeyB64 = Base64.encodeToString((byte[])identityKey);
        this.preKeys = preKeys;
        this.preKeysB64 = new HashMap();
        for (int id : preKeys.keySet()) {
            this.preKeysB64.put(id, Base64.encodeToString((byte[])preKeys.get(id)));
        }
    }

    public byte[] getSignedPreKey() {
        if (this.signedPreKey == null) {
            this.signedPreKey = Base64.decode((String)this.signedPreKeyB64);
        }
        return (byte[])this.signedPreKey.clone();
    }

    public int getSignedPreKeyId() {
        return this.signedPreKeyId;
    }

    public byte[] getSignedPreKeySignature() {
        if (this.signedPreKeySignature == null) {
            this.signedPreKeySignature = Base64.decode((String)this.signedPreKeySignatureB64);
        }
        return (byte[])this.signedPreKeySignature.clone();
    }

    public byte[] getIdentityKey() {
        if (this.identityKey == null) {
            this.identityKey = Base64.decode((String)this.identityKeyB64);
        }
        return (byte[])this.identityKey.clone();
    }

    public HashMap<Integer, byte[]> getPreKeys() {
        if (this.preKeys == null) {
            this.preKeys = new HashMap();
            for (int id : this.preKeysB64.keySet()) {
                this.preKeys.put(id, Base64.decode((String)this.preKeysB64.get(id)));
            }
        }
        return this.preKeys;
    }

    public byte[] getPreKey(int id) {
        return this.getPreKeys().get(id);
    }

    public String getElementName() {
        return BUNDLE;
    }

    public XmlStringBuilder toXML(String enclosingNamespace) {
        XmlStringBuilder sb = new XmlStringBuilder((ExtensionElement)this, enclosingNamespace).rightAngleBracket();
        sb.halfOpenElement(SIGNED_PRE_KEY_PUB).attribute(SIGNED_PRE_KEY_ID, this.signedPreKeyId).rightAngleBracket().append((CharSequence)this.signedPreKeyB64).closeElement(SIGNED_PRE_KEY_PUB);
        sb.openElement(SIGNED_PRE_KEY_SIG).append((CharSequence)this.signedPreKeySignatureB64).closeElement(SIGNED_PRE_KEY_SIG);
        sb.openElement(IDENTITY_KEY).append((CharSequence)this.identityKeyB64).closeElement(IDENTITY_KEY);
        sb.openElement(PRE_KEYS);
        for (Map.Entry<Integer, String> p : this.preKeysB64.entrySet()) {
            sb.halfOpenElement(PRE_KEY_PUB).attribute(PRE_KEY_ID, p.getKey().intValue()).rightAngleBracket().append((CharSequence)p.getValue()).closeElement(PRE_KEY_PUB);
        }
        sb.closeElement(PRE_KEYS);
        sb.closeElement((NamedElement)this);
        return sb;
    }

    public String toString() {
        String out = "OmemoBundleElement[\n";
        out = out + "signedPreKeyPublic signedPreKeyId=" + this.signedPreKeyId + ": " + this.signedPreKeyB64 + "\n";
        out = out + "signedPreKeySignature: " + this.signedPreKeySignatureB64 + "\n";
        out = out + "identityKey: " + this.identityKeyB64 + "\n";
        out = out + "prekeys (" + this.preKeysB64.size() + ")\n";
        for (Map.Entry<Integer, String> e : this.preKeysB64.entrySet()) {
            out = out + "preKeyPublic preKeyId=" + e.getKey() + ": " + e.getValue() + "\n";
        }
        return out;
    }

    public boolean equals(Object other) {
        if (!(other instanceof OmemoBundleElement)) {
            return false;
        }
        OmemoBundleElement otherOmemoBundleElement = (OmemoBundleElement)other;
        return this.toXML(null).equals((Object)otherOmemoBundleElement.toXML(null));
    }

    public int hashCode() {
        return this.toXML(null).hashCode();
    }
}

