/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.element;

import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.omemo.element.OmemoHeaderElement;

public abstract class OmemoElement
implements ExtensionElement {
    public static final int TYPE_OMEMO_PREKEY_MESSAGE = 1;
    public static final int TYPE_OMEMO_MESSAGE = 0;
    public static final String NAME_ENCRYPTED = "encrypted";
    public static final String ATTR_PAYLOAD = "payload";
    private final OmemoHeaderElement header;
    private final byte[] payload;

    public OmemoElement(OmemoHeaderElement header, byte[] payload) {
        this.header = (OmemoHeaderElement)Objects.requireNonNull((Object)header);
        this.payload = payload;
    }

    public OmemoHeaderElement getHeader() {
        return this.header;
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            return null;
        }
        return (byte[])this.payload.clone();
    }

    public boolean isKeyTransportElement() {
        return this.payload == null;
    }

    public boolean isMessageElement() {
        return this.payload != null;
    }

    public XmlStringBuilder toXML(String enclosingNamespace) {
        XmlStringBuilder sb = new XmlStringBuilder((ExtensionElement)this, enclosingNamespace).rightAngleBracket();
        sb.element((Element)this.header);
        if (this.payload != null) {
            sb.openElement(ATTR_PAYLOAD).append((CharSequence)Base64.encodeToString((byte[])this.payload)).closeElement(ATTR_PAYLOAD);
        }
        sb.closeElement((NamedElement)this);
        return sb;
    }

    public String getElementName() {
        return NAME_ENCRYPTED;
    }
}

