/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.exceptions;

import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;

public class UntrustedOmemoIdentityException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final OmemoDevice device;
    private final OmemoFingerprint trustedKey;
    private final OmemoFingerprint untrustedKey;

    public UntrustedOmemoIdentityException(OmemoDevice device, OmemoFingerprint fpTrusted, OmemoFingerprint fpUntrusted) {
        this.device = device;
        this.trustedKey = fpTrusted;
        this.untrustedKey = fpUntrusted;
    }

    public UntrustedOmemoIdentityException(OmemoDevice device, OmemoFingerprint untrustedKey) {
        this(device, null, untrustedKey);
    }

    public OmemoDevice getDevice() {
        return this.device;
    }

    public OmemoFingerprint getTrustedFingerprint() {
        return this.trustedKey;
    }

    public OmemoFingerprint getUntrustedFingerprint() {
        return this.untrustedKey;
    }

    @Override
    public String toString() {
        if (this.trustedKey != null) {
            return "Untrusted OMEMO Identity encountered:\nFingerprint of trusted key:\n" + this.trustedKey.blocksOf8Chars() + "\nFingerprint of untrusted key:\n" + this.untrustedKey.blocksOf8Chars();
        }
        return "Untrusted OMEMO Identity encountered:\nFingerprint of untrusted key:\n" + this.untrustedKey.blocksOf8Chars();
    }
}

