/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.id.StanzaIdUtil;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;

public abstract class Stanza
implements TopLevelStreamElement {
    public static final String TEXT = "text";
    public static final String ITEM = "item";
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase(Locale.US);
    private final MultiMap<String, ExtensionElement> packetExtensions = new MultiMap();
    private String id = null;
    private Jid to;
    private Jid from;
    private StanzaError error = null;
    protected String language;

    protected Stanza() {
        this(StanzaIdUtil.newStanzaId());
    }

    protected Stanza(String stanzaId) {
        this.setStanzaId(stanzaId);
    }

    protected Stanza(Stanza p) {
        this.id = p.getStanzaId();
        this.to = p.getTo();
        this.from = p.getFrom();
        this.error = p.error;
        for (ExtensionElement pe : p.getExtensions()) {
            this.addExtension(pe);
        }
    }

    public String getStanzaId() {
        return this.id;
    }

    @Deprecated
    public String getPacketID() {
        return this.getStanzaId();
    }

    public void setStanzaId(String id) {
        if (id != null) {
            StringUtils.requireNotNullOrEmpty(id, "id must either be null or not the empty String");
        }
        this.id = id;
    }

    @Deprecated
    public void setPacketID(String packetID) {
        this.setStanzaId(packetID);
    }

    public boolean hasStanzaIdSet() {
        return this.id != null;
    }

    public String setStanzaId() {
        if (!this.hasStanzaIdSet()) {
            this.setStanzaId(StanzaIdUtil.newStanzaId());
        }
        return this.getStanzaId();
    }

    public Jid getTo() {
        return this.to;
    }

    @Deprecated
    public void setTo(String to) {
        Jid jid;
        try {
            jid = JidCreate.from((String)to);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
        this.setTo(jid);
    }

    public void setTo(Jid to) {
        this.to = to;
    }

    public Jid getFrom() {
        return this.from;
    }

    @Deprecated
    public void setFrom(String from) {
        Jid jid;
        try {
            jid = JidCreate.from((String)from);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
        this.setFrom(jid);
    }

    public void setFrom(Jid from) {
        this.from = from;
    }

    public StanzaError getError() {
        return this.error;
    }

    @Deprecated
    public void setError(StanzaError error) {
        this.error = error;
    }

    public void setError(StanzaError.Builder xmppErrorBuilder) {
        if (xmppErrorBuilder == null) {
            return;
        }
        xmppErrorBuilder.setStanza(this);
        this.error = xmppErrorBuilder.build();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExtensionElement> getExtensions() {
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            return this.packetExtensions.values();
        }
    }

    public List<ExtensionElement> getExtensions(String elementName, String namespace) {
        StringUtils.requireNotNullOrEmpty(elementName, "elementName must not be null or empty");
        StringUtils.requireNotNullOrEmpty(namespace, "namespace must not be null or empty");
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        return this.packetExtensions.getAll(key);
    }

    public ExtensionElement getExtension(String namespace) {
        return PacketUtil.extensionElementFrom(this.getExtensions(), null, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <PE extends ExtensionElement> PE getExtension(String elementName, String namespace) {
        ExtensionElement packetExtension;
        if (namespace == null) {
            return null;
        }
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            packetExtension = this.packetExtensions.getFirst(key);
        }
        if (packetExtension == null) {
            return null;
        }
        return (PE)packetExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtension(ExtensionElement extension) {
        if (extension == null) {
            return;
        }
        String key = XmppStringUtils.generateKey((String)extension.getElementName(), (String)extension.getNamespace());
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            this.packetExtensions.put(key, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionElement overrideExtension(ExtensionElement extension) {
        if (extension == null) {
            return null;
        }
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            ExtensionElement removedExtension = this.removeExtension(extension.getElementName(), extension.getNamespace());
            this.addExtension(extension);
            return removedExtension;
        }
    }

    public void addExtensions(Collection<ExtensionElement> extensions) {
        if (extensions == null) {
            return;
        }
        for (ExtensionElement packetExtension : extensions) {
            this.addExtension(packetExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExtension(String elementName, String namespace) {
        if (elementName == null) {
            return this.hasExtension(namespace);
        }
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            return this.packetExtensions.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExtension(String namespace) {
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            for (ExtensionElement packetExtension : this.packetExtensions.values()) {
                if (!packetExtension.getNamespace().equals(namespace)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionElement removeExtension(String elementName, String namespace) {
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            return this.packetExtensions.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionElement removeExtension(ExtensionElement extension) {
        String key = XmppStringUtils.generateKey((String)extension.getElementName(), (String)extension.getNamespace());
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            List<ExtensionElement> list = this.packetExtensions.getAll(key);
            boolean removed = list.remove(extension);
            if (removed) {
                return extension;
            }
        }
        return null;
    }

    public abstract String toString();

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    protected String addCommonAttributes(XmlStringBuilder xml, String enclosingNamespace) {
        String namespace = enclosingNamespace == null || !enclosingNamespace.equals("jabber:client") || !enclosingNamespace.equals("jabber:server") ? "jabber:client" : enclosingNamespace;
        xml.xmlnsAttribute(namespace);
        xml.optAttribute("to", (CharSequence)this.getTo());
        xml.optAttribute("from", (CharSequence)this.getFrom());
        xml.optAttribute("id", this.getStanzaId());
        xml.xmllangAttribute(this.getLanguage());
        return namespace;
    }

    protected void logCommonAttributes(StringBuilder sb) {
        if (this.getTo() != null) {
            sb.append("to=").append((CharSequence)this.to).append(',');
        }
        if (this.getFrom() != null) {
            sb.append("from=").append((CharSequence)this.from).append(',');
        }
        if (this.hasStanzaIdSet()) {
            sb.append("id=").append(this.id).append(',');
        }
    }

    protected void appendErrorIfExists(XmlStringBuilder xml) {
        StanzaError error = this.getError();
        if (error != null) {
            xml.append(error.toXML());
        }
    }
}

