/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.internal.creation.DelegatingMethod;
import org.mockito.internal.debugging.Localized;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.exceptions.stacktrace.StackTraceFilter;
import org.mockito.internal.invocation.InvocationImpl;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.realmethod.CleanTraceRealMethod;
import org.mockito.internal.invocation.realmethod.RealMethod;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.verification.VerificationDataImpl;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.MockHandler;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.internal.invocation.InvocationControlAssertionError;
import org.powermock.api.mockito.internal.verification.StaticMockAwareVerificationMode;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.core.MockGateway;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.internal.WhiteboxImpl;

public class MockitoMethodInvocationControl
implements MethodInvocationControl {
    private final Set<Method> mockedMethods;
    private final Object delegator;
    private final Object mockInstance;
    private final MockHandler mockHandler;

    public MockitoMethodInvocationControl(Object mockInstance, MockHandler mockHandler, Method ... methodsToMock) {
        this(mockHandler, null, mockInstance, methodsToMock);
    }

    public MockitoMethodInvocationControl(MockHandler mockHandler, Object delegator, Object mockInstance, Method ... methodsToMock) {
        this.mockHandler = mockHandler;
        this.mockedMethods = this.toSet(methodsToMock);
        this.mockInstance = mockInstance;
        this.delegator = delegator;
    }

    public boolean isMocked(Method method) {
        return this.mockedMethods == null || this.mockedMethods.contains(method);
    }

    private boolean isInVerificationMode() {
        return this.getVerificationMode() != null;
    }

    private VerificationMode getVerificationMode() {
        try {
            MockingProgress progress = ThreadSafeMockingProgress.mockingProgress();
            return this.getVerificationModeFromMockProgress(progress);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private VerificationMode getVerificationModeFromMockProgress(MockingProgress mockingProgress) {
        if (mockingProgress == null) {
            return null;
        }
        Localized verificationMode = (Localized)Whitebox.getInternalState((Object)mockingProgress, Localized.class);
        return verificationMode == null ? null : (VerificationMode)verificationMode.getObject();
    }

    public Object invoke(Object obj, Method method, Object[] arguments) throws Throwable {
        Object returnValue;
        int methodModifiers = method.getModifiers();
        if (this.hasDelegator() && !Modifier.isPrivate(methodModifiers) && !Modifier.isFinal(methodModifiers) && !Modifier.isStatic(methodModifiers) && this.hasBeenCaughtByMockitoProxy()) {
            returnValue = MockGateway.PROCEED;
        } else {
            boolean inVerificationMode = this.isInVerificationMode();
            if (WhiteboxImpl.isClass((Object)obj) && inVerificationMode) {
                this.handleStaticVerification((Class)obj);
            }
            if ((returnValue = this.performIntercept(obj, method, arguments)) == null) {
                return MockGateway.SUPPRESS;
            }
        }
        return returnValue;
    }

    private void handleStaticVerification(Class<?> cls) {
        StaticMockAwareVerificationMode mode;
        VerificationMode verificationMode = this.getVerificationMode();
        if (verificationMode instanceof StaticMockAwareVerificationMode && (mode = (StaticMockAwareVerificationMode)verificationMode).getClassMock() == null) {
            mode.setClassMock(cls);
        }
    }

    private boolean hasBeenCaughtByMockitoProxy() {
        StackTraceFilter filter = new StackTraceFilter();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] filteredStackTrace = filter.filter(stackTrace, true);
        return filteredStackTrace.length != stackTrace.length;
    }

    private Object performIntercept(final Object interceptionObject, final Method method, Object[] arguments) throws Throwable {
        CleanTraceRealMethod cleanTraceRealMethod = new CleanTraceRealMethod(new RealMethod(){
            private static final long serialVersionUID = 4564320968038564170L;

            public Object invoke(Object target, Object[] arguments) throws Throwable {
                boolean isFinalSystemClass;
                Class type = Whitebox.getType((Object)interceptionObject);
                boolean bl = isFinalSystemClass = type.getName().startsWith("java.") && Modifier.isFinal(type.getModifiers());
                if (!isFinalSystemClass) {
                    MockRepository.putAdditionalState((String)"DontMockNextCall", (Object)true);
                }
                try {
                    return method.invoke(target, arguments);
                }
                catch (InvocationTargetException e) {
                    SafeExceptionRethrower.safeRethrow((Throwable)e.getCause());
                    return null;
                }
            }
        });
        InvocationImpl invocation = new InvocationImpl(interceptionObject, (MockitoMethod)new DelegatingMethod(method), arguments, SequenceNumber.next(), (RealMethod)cleanTraceRealMethod, (Location)new LocationImpl());
        try {
            return this.mockHandler.handle((Invocation)invocation);
        }
        catch (NotAMockException e) {
            if (invocation.getMock().getClass().getName().startsWith("java.") && MockRepository.getInstanceMethodInvocationControl((Object)invocation.getMock()) != null) {
                return invocation.callRealMethod();
            }
            throw e;
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.updateErrorMessageForMethodInvocation((AssertionError)((Object)e));
            throw e;
        }
    }

    public Object replay(Object ... mocks) {
        throw new IllegalStateException("Internal error: No such thing as replay exists in Mockito.");
    }

    public Object reset(Object ... mocks) {
        throw new IllegalStateException("Internal error: No such thing as reset exists in Mockito.");
    }

    public Object verify(Object ... mocks) {
        if (mocks == null || mocks.length != 1) {
            throw new IllegalArgumentException("Must supply one mock to the verify method.");
        }
        return Mockito.verify((Object)mocks[0]);
    }

    public void verifyNoMoreInteractions() {
        try {
            InvocationContainer invocationContainer = (InvocationContainer)Whitebox.invokeMethod((Object)this.mockHandler, (String)"getInvocationContainer", (Object[])new Object[0]);
            VerificationDataImpl data = new VerificationDataImpl(invocationContainer, null);
            VerificationModeFactory.noMoreInteractions().verify((VerificationData)data);
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.updateErrorMessageForVerifyNoMoreInteractions((AssertionError)((Object)e));
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("PowerMock internal error", e);
        }
    }

    private Set<Method> toSet(Method ... methods) {
        return methods == null ? null : new HashSet<Method>(Arrays.asList(methods));
    }

    private boolean hasDelegator() {
        return this.delegator != null;
    }

    public MockHandler getMockHandler() {
        return this.mockHandler;
    }
}

