/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.javapinning;

import eu.geekplace.javapinning.PinningTrustManager;
import eu.geekplace.javapinning.pin.Pin;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JavaPinning {
    public static final String TLS = "TLS";
    public static final JavaPinning INSTANCE = new JavaPinning();

    public static X509TrustManager trustManagerForPin(String pinString) {
        return INSTANCE.tmForPin(pinString);
    }

    public static X509TrustManager trustManagerforPins(Collection<Pin> pins) {
        return INSTANCE.tmForPins(pins);
    }

    public static SSLContext forPin(String pinString) throws KeyManagementException, NoSuchAlgorithmException {
        return INSTANCE.ctxForPin(pinString);
    }

    public static SSLContext forPins(Collection<Pin> pins) throws KeyManagementException, NoSuchAlgorithmException {
        return INSTANCE.ctxForPins(pins);
    }

    protected JavaPinning() {
    }

    protected final X509TrustManager tmForPin(String pinString) {
        Pin pin = Pin.fromString(pinString);
        List<Pin> pins = Arrays.asList(pin);
        return this.tmForPins(pins);
    }

    protected final X509TrustManager tmForPins(Collection<Pin> pins) {
        PinningTrustManager pinningTrustManager = new PinningTrustManager(pins);
        X509TrustManager trustManager = this.eventuallySpecialize(pinningTrustManager);
        return trustManager;
    }

    protected final SSLContext ctxForPin(String pinString) throws KeyManagementException, NoSuchAlgorithmException {
        X509TrustManager trustManager = this.tmForPin(pinString);
        return JavaPinning.fromTrustManager(trustManager);
    }

    protected final SSLContext ctxForPins(Collection<Pin> pins) throws KeyManagementException, NoSuchAlgorithmException {
        X509TrustManager trustManager = this.tmForPins(pins);
        return JavaPinning.fromTrustManager(trustManager);
    }

    private static final SSLContext fromTrustManager(TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustManagers = new TrustManager[]{trustManager};
        SSLContext sslContext = SSLContext.getInstance(TLS);
        sslContext.init(null, trustManagers, new SecureRandom());
        return sslContext;
    }

    protected X509TrustManager eventuallySpecialize(PinningTrustManager pinningTrustManager) {
        return pinningTrustManager;
    }
}

