/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.javapinning;

import eu.geekplace.javapinning.pin.Pin;
import eu.geekplace.javapinning.util.JavaPinningUtil;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.X509TrustManager;

public class PinningTrustManager
implements X509TrustManager {
    private final Collection<Pin> pins;

    PinningTrustManager(Collection<Pin> pins) {
        this.pins = pins;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate leafCertificate = chain[0];
        if (this.isPinned(leafCertificate)) {
            return;
        }
        StringBuilder pinHexString = JavaPinningUtil.toHex(leafCertificate.getEncoded(), false, false);
        throw new CertificateException("Certificate not pinned. Use 'CERTPLAIN:" + pinHexString + "' to pin this certificate. But only pin the certificate if you are sure this is the correct certificate!");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    private boolean isPinned(X509Certificate x509certificate) throws CertificateEncodingException {
        for (Pin pin : this.pins) {
            if (!pin.pinsCertificate(x509certificate)) continue;
            return true;
        }
        return false;
    }
}

