/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.parsing;

import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.parsing.StandardExtensionElementProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.junit.Assert;
import org.junit.Test;

public class StandardExtensionElementParserTest {
    @Test
    public void buildAndParse() throws Exception {
        StandardExtensionElement.Builder builder = StandardExtensionElement.builder((String)"foo", (String)"ns1");
        builder.addAttribute("attr1", "attr1-value");
        builder.addElement(StandardExtensionElement.builder((String)"bar", (String)"ns2").addAttribute("attr2", "attr2-value").build());
        builder.addElement("another-element", "another-element-text");
        String elementString = builder.build().toXML(null).toString();
        StandardExtensionElement parsedElement = (StandardExtensionElement)StandardExtensionElementProvider.INSTANCE.parse(PacketParserUtils.getParserFor((String)elementString));
        Assert.assertEquals((Object)"foo", (Object)parsedElement.getElementName());
        Assert.assertEquals((Object)"ns1", (Object)parsedElement.getNamespace());
        Assert.assertEquals((Object)"attr1-value", (Object)parsedElement.getAttributeValue("attr1"));
        StandardExtensionElement barNs2Element = parsedElement.getFirstElement("bar", "ns2");
        Assert.assertEquals((Object)"bar", (Object)barNs2Element.getElementName());
        Assert.assertEquals((Object)"ns2", (Object)barNs2Element.getNamespace());
        Assert.assertEquals((Object)"attr2-value", (Object)barNs2Element.getAttributeValue("attr2"));
        Assert.assertEquals((Object)"another-element-text", (Object)parsedElement.getFirstElement("another-element").getText());
        String parsedElementString = parsedElement.toXML(null).toString();
        Assert.assertEquals((Object)elementString, (Object)parsedElementString);
    }

    @Test
    public void buildWithAttrNamespacesAndParse() throws Exception {
        StandardExtensionElement.Builder builder = StandardExtensionElement.builder((String)"foo", (String)"ns1-value");
        builder.addAttribute("xmlns:ns2", "ns2-value");
        builder.addAttribute("ns2:bar", "bar-ns2-value");
        String elementString = builder.build().toXML(null).toString();
        StandardExtensionElement parsedElement = (StandardExtensionElement)StandardExtensionElementProvider.INSTANCE.parse(PacketParserUtils.getParserFor((String)elementString));
        Assert.assertEquals((Object)"foo", (Object)parsedElement.getElementName());
        Assert.assertEquals((Object)"ns1-value", (Object)parsedElement.getNamespace());
        String barNs2Value = parsedElement.getAttributeValue("ns2:bar");
        Assert.assertEquals((Object)"bar-ns2-value", (Object)barNs2Value);
        String ns2Value = parsedElement.getAttributeValue("xmlns:ns2");
        Assert.assertEquals((Object)"ns2-value", (Object)ns2Value);
    }
}

