/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.data.element;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.iot.data.element.IoTDataField;
import org.jivesoftware.smackx.iot.data.element.NodeElement;
import org.jivesoftware.smackx.iot.data.element.TimestampElement;
import org.jivesoftware.smackx.iot.element.NodeInfo;

public class IoTFieldsExtension
implements ExtensionElement {
    public static final String ELEMENT = "fields";
    public static final String NAMESPACE = "urn:xmpp:iot:sensordata";
    private final int seqNr;
    private final boolean done;
    private final List<NodeElement> nodes;

    public IoTFieldsExtension(int seqNr, boolean done, NodeElement node) {
        this(seqNr, done, Collections.singletonList(node));
    }

    public IoTFieldsExtension(int seqNr, boolean done, List<NodeElement> nodes) {
        this.seqNr = seqNr;
        this.done = done;
        this.nodes = Collections.unmodifiableList(nodes);
    }

    public int getSequenceNr() {
        return this.seqNr;
    }

    public boolean isDone() {
        return this.done;
    }

    public List<NodeElement> getNodes() {
        return this.nodes;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML(String enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
        xml.attribute("seqnr", Integer.toString(this.seqNr));
        xml.attribute("done", this.done);
        xml.rightAngleBracket();
        xml.append(this.nodes);
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public static IoTFieldsExtension buildFor(int seqNr, boolean done, NodeInfo nodeInfo, List<? extends IoTDataField> data) {
        TimestampElement timestampElement = new TimestampElement(new Date(), data);
        NodeElement nodeElement = new NodeElement(nodeInfo, timestampElement);
        return new IoTFieldsExtension(seqNr, done, nodeElement);
    }

    public static IoTFieldsExtension from(Message message) {
        return (IoTFieldsExtension)message.getExtension(ELEMENT, NAMESPACE);
    }
}

