/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle_filetransfer.provider;

import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smackx.hashes.element.HashElement;
import org.jivesoftware.smackx.hashes.provider.HashElementProvider;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle_filetransfer.element.Checksum;
import org.jivesoftware.smackx.jingle_filetransfer.element.JingleFileTransferChild;
import org.jivesoftware.smackx.jingle_filetransfer.element.Range;
import org.xmlpull.v1.XmlPullParser;

public class ChecksumProvider
extends ExtensionElementProvider<Checksum> {
    public Checksum parse(XmlPullParser parser, int initialDepth) throws Exception {
        JingleContent.Creator creator = null;
        String creatorString = parser.getAttributeValue(null, "creator");
        if (creatorString != null) {
            creator = JingleContent.Creator.valueOf((String)creatorString);
        }
        String name = parser.getAttributeValue(null, "name");
        JingleFileTransferChild.Builder cb = JingleFileTransferChild.getBuilder();
        HashElement hashElement = null;
        Range range = null;
        boolean go = true;
        while (go) {
            int tag = parser.nextTag();
            String n = parser.getText();
            if (tag == 2) {
                switch (n) {
                    case "hash": {
                        hashElement = (HashElement)new HashElementProvider().parse(parser);
                        break;
                    }
                    case "range": {
                        String offset = parser.getAttributeValue(null, "offset");
                        String length = parser.getAttributeValue(null, "length");
                        int o = offset == null ? 0 : Integer.parseInt(offset);
                        int l = length == null ? -1 : Integer.parseInt(length);
                        range = new Range(o, l);
                    }
                }
                continue;
            }
            if (tag != 3) continue;
            switch (n) {
                case "range": {
                    if (hashElement == null || range == null) break;
                    range = new Range(range.getOffset(), range.getLength(), hashElement);
                    hashElement = null;
                    break;
                }
                case "file": {
                    if (hashElement != null) {
                        cb.setHash(hashElement);
                    }
                    if (range != null) {
                        cb.setRange(range);
                    }
                    go = false;
                }
            }
        }
        return new Checksum(creator, name, cb.build());
    }
}

