/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Date;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatManagerListener;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.jxmpp.jid.EntityJid;

public class ChatTest
extends AbstractSmackIntegrationTest {
    private final ChatManager chatManagerOne;
    private boolean invoked;

    public ChatTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.chatManagerOne = ChatManager.getInstanceFor((XMPPConnection)this.conOne);
    }

    @BeforeClass
    public void setUp() {
        JivePropertiesManager.setJavaObjectEnabled((boolean)true);
    }

    @AfterClass
    public void tearDown() {
        JivePropertiesManager.setJavaObjectEnabled((boolean)false);
    }

    @SmackIntegrationTest
    public void testProperties() throws Exception {
        Chat newChat = this.chatManagerOne.createChat((EntityJid)this.conTwo.getUser());
        StanzaCollector collector = this.conTwo.createStanzaCollector((StanzaFilter)new ThreadFilter(newChat.getThreadID()));
        Message msg = new Message();
        msg.setSubject("Subject of the chat");
        msg.setBody("Body of the chat");
        JivePropertiesManager.addProperty((Stanza)msg, (String)"favoriteColor", (Object)"red");
        JivePropertiesManager.addProperty((Stanza)msg, (String)"age", (Object)30);
        JivePropertiesManager.addProperty((Stanza)msg, (String)"distance", (Object)Float.valueOf(30.0f));
        JivePropertiesManager.addProperty((Stanza)msg, (String)"weight", (Object)30.0);
        JivePropertiesManager.addProperty((Stanza)msg, (String)"male", (Object)true);
        JivePropertiesManager.addProperty((Stanza)msg, (String)"birthdate", (Object)new Date());
        newChat.sendMessage(msg);
        Message msg2 = (Message)collector.nextResult(2000L);
        Assert.assertNotNull((String)"No message was received", (Object)msg2);
        Assert.assertEquals((String)"Subjects are different", (Object)msg.getSubject(), (Object)msg2.getSubject());
        Assert.assertEquals((String)"Bodies are different", (Object)msg.getBody(), (Object)msg2.getBody());
        Assert.assertEquals((String)"favoriteColors are different", (Object)JivePropertiesManager.getProperty((Stanza)msg, (String)"favoriteColor"), (Object)JivePropertiesManager.getProperty((Stanza)msg2, (String)"favoriteColor"));
        Assert.assertEquals((String)"ages are different", (Object)JivePropertiesManager.getProperty((Stanza)msg, (String)"age"), (Object)JivePropertiesManager.getProperty((Stanza)msg2, (String)"age"));
        Assert.assertEquals((String)"distances are different", (Object)JivePropertiesManager.getProperty((Stanza)msg, (String)"distance"), (Object)JivePropertiesManager.getProperty((Stanza)msg2, (String)"distance"));
        Assert.assertEquals((String)"weights are different", (Object)JivePropertiesManager.getProperty((Stanza)msg, (String)"weight"), (Object)JivePropertiesManager.getProperty((Stanza)msg2, (String)"weight"));
        Assert.assertEquals((String)"males are different", (Object)JivePropertiesManager.getProperty((Stanza)msg, (String)"male"), (Object)JivePropertiesManager.getProperty((Stanza)msg2, (String)"male"));
        Assert.assertEquals((String)"birthdates are different", (Object)JivePropertiesManager.getProperty((Stanza)msg, (String)"birthdate"), (Object)JivePropertiesManager.getProperty((Stanza)msg2, (String)"birthdate"));
    }

    @SmackIntegrationTest
    public void chatManagerTest() {
        ChatManagerListener listener = new ChatManagerListener(){

            public void chatCreated(Chat chat, boolean createdLocally) {
                ChatTest.this.invoked = true;
            }
        };
        try {
            this.chatManagerOne.addChatListener(listener);
            this.chatManagerOne.createChat((EntityJid)this.conTwo.getUser());
            Assert.assertTrue((String)"TestChatManagerListener wasn't invoked", (boolean)this.invoked);
        }
        finally {
            this.chatManagerOne.removeChatListener(listener);
        }
    }
}

