/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.junit.Assert;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;

public class FormTest
extends AbstractSmackIntegrationTest {
    public FormTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void testFilloutForm() throws SmackException.NotConnectedException, InterruptedException {
        Form formToSend = new Form(DataForm.Type.form);
        formToSend.setInstructions("Fill out this form to report your case.\nThe case will be created automatically.");
        formToSend.setTitle("Case configurations");
        FormField field = new FormField("hidden_var");
        field.setType(FormField.Type.hidden);
        field.addValue((CharSequence)"Some value for the hidden variable");
        formToSend.addField(field);
        field = new FormField();
        field.addValue((CharSequence)"Section 1: Case description");
        formToSend.addField(field);
        field = new FormField("name");
        field.setLabel("Enter a name for the case");
        field.setType(FormField.Type.text_single);
        formToSend.addField(field);
        field = new FormField("description");
        field.setLabel("Enter a description");
        field.setType(FormField.Type.text_multi);
        formToSend.addField(field);
        field = new FormField("time");
        field.setLabel("Is this your first case?");
        field.setType(FormField.Type.bool);
        formToSend.addField(field);
        field = new FormField("age");
        field.setLabel("How old are you?");
        field.setType(FormField.Type.text_single);
        formToSend.addField(field);
        Chat chat = ChatManager.getInstanceFor((XMPPConnection)this.conOne).createChat((EntityJid)this.conTwo.getUser(), null);
        StanzaCollector collector = this.conOne.createStanzaCollector((StanzaFilter)new ThreadFilter(chat.getThreadID()));
        StanzaCollector collector2 = this.conTwo.createStanzaCollector((StanzaFilter)new ThreadFilter(chat.getThreadID()));
        Message msg = new Message();
        msg.setBody("To enter a case please fill out this form and send it back to me");
        msg.addExtension((ExtensionElement)formToSend.getDataFormToSend());
        try {
            chat.sendMessage(msg);
            Message msg2 = (Message)collector2.nextResult();
            Assert.assertNotNull((String)"Message not found", (Object)msg2);
            Form formToRespond = Form.getFormFrom((Stanza)msg2);
            Assert.assertNotNull((Object)formToRespond);
            Assert.assertNotNull((Object)formToRespond.getField("name"));
            Assert.assertNotNull((Object)formToRespond.getField("description"));
            Form completedForm = formToRespond.createAnswerForm();
            Assert.assertNotNull((Object)completedForm.getField("hidden_var"));
            try {
                completedForm.setAnswer("name", true);
                Assert.fail((String)"A boolean value was set to a field of type String");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            completedForm.setAnswer("name", "Credit card number invalid");
            completedForm.setAnswer("description", "The ATM says that my credit card number is invalid. What's going on?");
            completedForm.setAnswer("time", true);
            completedForm.setAnswer("age", 20);
            msg2 = new Message();
            msg2.setTo((Jid)this.conOne.getUser().asBareJid());
            msg2.setThread(msg.getThread());
            msg2.setType(Message.Type.chat);
            msg2.setBody("To enter a case please fill out this form and send it back to me");
            msg2.addExtension((ExtensionElement)completedForm.getDataFormToSend());
            this.conTwo.sendStanza((Stanza)msg2);
            Message msg3 = (Message)collector.nextResult();
            Assert.assertNotNull((String)"Message not found", (Object)msg3);
            completedForm = Form.getFormFrom((Stanza)msg3);
            Assert.assertNotNull((Object)completedForm);
            Assert.assertNotNull((Object)completedForm.getField("name"));
            Assert.assertNotNull((Object)completedForm.getField("description"));
            Assert.assertEquals(completedForm.getField("name").getValues().get(0), (Object)"Credit card number invalid");
            Assert.assertNotNull((Object)completedForm.getField("time"));
            Assert.assertNotNull((Object)completedForm.getField("age"));
            Assert.assertEquals((String)"The age is bad", (Object)"20", completedForm.getField("age").getValues().get(0));
        }
        finally {
            collector.cancel();
            collector2.cancel();
        }
    }
}

