/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.TypedCloneable;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public final class Message
extends Stanza
implements TypedCloneable<Message> {
    public static final String ELEMENT = "message";
    public static final String BODY = "body";
    private Type type;
    private String thread = null;
    private final Set<Subject> subjects = new HashSet<Subject>();

    public Message() {
    }

    public Message(Jid to) {
        this.setTo(to);
    }

    public Message(Jid to, Type type) {
        this(to);
        this.setType(type);
    }

    public Message(Jid to, String body) {
        this(to);
        this.setBody(body);
    }

    public Message(String to, String body) throws XmppStringprepException {
        this(JidCreate.from((String)to), body);
    }

    public Message(Jid to, ExtensionElement extensionElement) {
        this(to);
        this.addExtension(extensionElement);
    }

    public Message(Message other) {
        super(other);
        this.type = other.type;
        this.thread = other.thread;
        this.subjects.addAll(other.subjects);
    }

    public Type getType() {
        if (this.type == null) {
            return Type.normal;
        }
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getSubject() {
        return this.getSubject(null);
    }

    public String getSubject(String language) {
        Subject subject = this.getMessageSubject(language);
        return subject == null ? null : subject.subject;
    }

    private Subject getMessageSubject(String language) {
        language = this.determineLanguage(language);
        for (Subject subject : this.subjects) {
            if (!Objects.equals(language, subject.language)) continue;
            return subject;
        }
        return null;
    }

    public Set<Subject> getSubjects() {
        return Collections.unmodifiableSet(this.subjects);
    }

    public void setSubject(String subject) {
        if (subject == null) {
            this.removeSubject("");
            return;
        }
        this.addSubject(null, subject);
    }

    public Subject addSubject(String language, String subject) {
        language = this.determineLanguage(language);
        Subject messageSubject = new Subject(language, subject);
        this.subjects.add(messageSubject);
        return messageSubject;
    }

    public boolean removeSubject(String language) {
        language = this.determineLanguage(language);
        for (Subject subject : this.subjects) {
            if (!language.equals(subject.language)) continue;
            return this.subjects.remove(subject);
        }
        return false;
    }

    public boolean removeSubject(Subject subject) {
        return this.subjects.remove(subject);
    }

    public List<String> getSubjectLanguages() {
        Subject defaultSubject = this.getMessageSubject(null);
        ArrayList<String> languages = new ArrayList<String>();
        for (Subject subject : this.subjects) {
            if (subject.equals(defaultSubject)) continue;
            languages.add(subject.language);
        }
        return Collections.unmodifiableList(languages);
    }

    public String getBody() {
        return this.getBody(this.language);
    }

    public String getBody(String language) {
        Body body = this.getMessageBody(language);
        return body == null ? null : body.message;
    }

    private Body getMessageBody(String language) {
        language = this.determineLanguage(language);
        for (Body body : this.getBodies()) {
            if (!Objects.equals(language, body.language) && (language == null || !language.equals(this.language) || body.language != null)) continue;
            return body;
        }
        return null;
    }

    public Set<Body> getBodies() {
        List<ExtensionElement> bodiesList = this.getExtensions(BODY, "jabber:client");
        HashSet<Body> resultSet = new HashSet<Body>(bodiesList.size());
        for (ExtensionElement extensionElement : bodiesList) {
            Body body = (Body)extensionElement;
            resultSet.add(body);
        }
        return resultSet;
    }

    public void setBody(CharSequence body) {
        String bodyString = body != null ? body.toString() : null;
        this.setBody(bodyString);
    }

    public void setBody(String body) {
        if (body == null) {
            this.removeBody("");
            return;
        }
        this.addBody(null, body);
    }

    public Body addBody(String language, String body) {
        language = this.determineLanguage(language);
        this.removeBody(language);
        Body messageBody = new Body(language, body);
        this.addExtension(messageBody);
        return messageBody;
    }

    public boolean removeBody(String language) {
        language = this.determineLanguage(language);
        for (Body body : this.getBodies()) {
            String bodyLanguage = body.getLanguage();
            if (!Objects.equals(bodyLanguage, language)) continue;
            this.removeExtension(body);
            return true;
        }
        return false;
    }

    public boolean removeBody(Body body) {
        ExtensionElement removedElement = this.removeExtension(body);
        return removedElement != null;
    }

    public List<String> getBodyLanguages() {
        Body defaultBody = this.getMessageBody(null);
        ArrayList<String> languages = new ArrayList<String>();
        for (Body body : this.getBodies()) {
            if (body.equals(defaultBody)) continue;
            languages.add(body.language);
        }
        return Collections.unmodifiableList(languages);
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    private String determineLanguage(String language) {
        String string = language = "".equals(language) ? null : language;
        if (language == null && this.language != null) {
            return this.language;
        }
        return language;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Message Stanza [");
        this.logCommonAttributes(sb);
        if (this.type != null) {
            sb.append("type=").append((Object)this.type).append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public XmlStringBuilder toXML(String enclosingNamespace) {
        XmlStringBuilder buf = new XmlStringBuilder(enclosingNamespace);
        buf.halfOpenElement(ELEMENT);
        enclosingNamespace = this.addCommonAttributes(buf, enclosingNamespace);
        buf.optAttribute("type", this.type);
        buf.rightAngleBracket();
        Subject defaultSubject = this.getMessageSubject(null);
        if (defaultSubject != null) {
            buf.element("subject", defaultSubject.subject);
        }
        for (Subject subject : this.getSubjects()) {
            if (subject.equals(defaultSubject)) continue;
            buf.append(subject.toXML(null));
        }
        buf.optElement("thread", this.thread);
        if (this.type == Type.error) {
            this.appendErrorIfExists(buf);
        }
        buf.append(this.getExtensions(), enclosingNamespace);
        buf.closeElement(ELEMENT);
        return buf;
    }

    @Override
    public Message clone() {
        return new Message(this);
    }

    public static enum Type {
        normal,
        chat,
        groupchat,
        headline,
        error;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }

    public static final class Body
    implements ExtensionElement {
        public static final String ELEMENT = "body";
        public static final String NAMESPACE = "jabber:client";
        private final String message;
        private final String language;
        private final BodyElementNamespace namespace;

        public Body(String language, String message) {
            this(language, message, BodyElementNamespace.client);
        }

        public Body(String language, String message, BodyElementNamespace namespace) {
            if (message == null) {
                throw new NullPointerException("Message cannot be null.");
            }
            this.language = language;
            this.message = message;
            this.namespace = Objects.requireNonNull(namespace);
        }

        public String getLanguage() {
            return this.language;
        }

        public String getMessage() {
            return this.message;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            if (this.language != null) {
                result = 31 * result + this.language.hashCode();
            }
            result = 31 * result + this.message.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Body other = (Body)obj;
            return Objects.equals(this.language, other.language) && this.message.equals(other.message);
        }

        @Override
        public String getElementName() {
            return "body";
        }

        @Override
        public String getNamespace() {
            return this.namespace.xmlNamespace;
        }

        @Override
        public XmlStringBuilder toXML(String enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder(this, enclosingNamespace);
            xml.optXmlLangAttribute(this.getLanguage()).rightAngleBracket();
            xml.escape(this.message);
            xml.closeElement(this.getElementName());
            return xml;
        }

        static enum BodyElementNamespace {
            client("jabber:client"),
            server("jabber:server");

            private final String xmlNamespace;

            private BodyElementNamespace(String xmlNamespace) {
                this.xmlNamespace = xmlNamespace;
            }

            public String getNamespace() {
                return this.xmlNamespace;
            }
        }
    }

    public static final class Subject
    implements ExtensionElement {
        public static final String ELEMENT = "subject";
        public static final String NAMESPACE = "jabber:client";
        private final String subject;
        private final String language;

        private Subject(String language, String subject) {
            if (subject == null) {
                throw new NullPointerException("Subject cannot be null.");
            }
            this.language = language;
            this.subject = subject;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getSubject() {
            return this.subject;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            if (this.language != null) {
                result = 31 * result + this.language.hashCode();
            }
            result = 31 * result + this.subject.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Subject other = (Subject)obj;
            return this.language.equals(other.language) && this.subject.equals(other.subject);
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return NAMESPACE;
        }

        @Override
        public XmlStringBuilder toXML(String enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement(this.getElementName()).optXmlLangAttribute(this.getLanguage()).rightAngleBracket();
            xml.escape(this.subject);
            xml.closeElement(this.getElementName());
            return xml;
        }
    }
}

