/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.roster.AbstractPresenceEventListener;
import org.jivesoftware.smack.roster.AbstractRosterListener;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.SubscribeListener;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.util.StringUtils;
import org.junit.Assert;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;

public class RosterIntegrationTest
extends AbstractSmackIntegrationTest {
    private final Roster rosterOne;
    private final Roster rosterTwo;

    public RosterIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.rosterOne = Roster.getInstanceFor((XMPPConnection)this.conOne);
        this.rosterTwo = Roster.getInstanceFor((XMPPConnection)this.conTwo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void subscribeRequestListenerTest() throws TimeoutException, Exception {
        RosterIntegrationTest.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        SubscribeListener subscribeListener = new SubscribeListener(){

            public SubscribeListener.SubscribeAnswer processSubscribe(Jid from, Presence subscribeRequest) {
                if (from.equals((CharSequence)RosterIntegrationTest.this.conOne.getUser().asBareJid())) {
                    return SubscribeListener.SubscribeAnswer.Approve;
                }
                return SubscribeListener.SubscribeAnswer.Deny;
            }
        };
        this.rosterTwo.addSubscribeListener(subscribeListener);
        final String conTwosRosterName = "ConTwo " + this.testRunId;
        final SimpleResultSyncPoint addedAndSubscribed = new SimpleResultSyncPoint();
        this.rosterOne.addRosterListener((RosterListener)new AbstractRosterListener(){

            public void entriesAdded(Collection<Jid> addresses) {
                this.checkIfAddedAndSubscribed(addresses);
            }

            public void entriesUpdated(Collection<Jid> addresses) {
                this.checkIfAddedAndSubscribed(addresses);
            }

            private void checkIfAddedAndSubscribed(Collection<Jid> addresses) {
                for (Jid jid : addresses) {
                    if (!jid.equals((CharSequence)RosterIntegrationTest.this.conTwo.getUser().asBareJid())) continue;
                    BareJid bareJid = RosterIntegrationTest.this.conTwo.getUser().asBareJid();
                    RosterEntry rosterEntry = RosterIntegrationTest.this.rosterOne.getEntry(bareJid);
                    if (rosterEntry == null) {
                        addedAndSubscribed.signalFailure("No roster entry for " + bareJid);
                        return;
                    }
                    String name = rosterEntry.getName();
                    if (StringUtils.isNullOrEmpty((CharSequence)name)) {
                        addedAndSubscribed.signalFailure("Roster entry without name");
                        return;
                    }
                    if (!rosterEntry.getName().equals(conTwosRosterName)) {
                        addedAndSubscribed.signalFailure("Roster name does not match");
                        return;
                    }
                    if (!rosterEntry.getType().equals((Object)RosterPacket.ItemType.to)) {
                        return;
                    }
                    addedAndSubscribed.signal();
                }
            }
        });
        try {
            this.rosterOne.createEntry(this.conTwo.getUser().asBareJid(), conTwosRosterName, null);
            Assert.assertTrue((boolean)((Boolean)addedAndSubscribed.waitForResult(2L * this.connection.getReplyTimeout())));
        }
        finally {
            this.rosterTwo.removeSubscribeListener(subscribeListener);
        }
    }

    public static void ensureBothAccountsAreNotInEachOthersRoster(XMPPConnection conOne, XMPPConnection conTwo) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        RosterIntegrationTest.notInRoster(conOne, conTwo);
        RosterIntegrationTest.notInRoster(conTwo, conOne);
    }

    private static void notInRoster(XMPPConnection c1, XMPPConnection c2) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Roster roster = Roster.getInstanceFor((XMPPConnection)c1);
        RosterEntry c2Entry = roster.getEntry(c2.getUser().asBareJid());
        if (c2Entry == null) {
            return;
        }
        roster.removeEntry(c2Entry);
    }

    public static void ensureBothAccountsAreSubscribedToEachOther(XMPPConnection conOne, XMPPConnection conTwo, long timeout) throws TimeoutException, Exception {
        RosterIntegrationTest.ensureSubscribedTo(conOne, conTwo, timeout);
        RosterIntegrationTest.ensureSubscribedTo(conTwo, conOne, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureSubscribedTo(final XMPPConnection conOne, final XMPPConnection conTwo, long timeout) throws TimeoutException, Exception {
        Roster rosterOne = Roster.getInstanceFor((XMPPConnection)conOne);
        Roster rosterTwo = Roster.getInstanceFor((XMPPConnection)conTwo);
        if (rosterOne.isSubscribedToMyPresence((Jid)conTwo.getUser())) {
            return;
        }
        SubscribeListener subscribeListener = new SubscribeListener(){

            public SubscribeListener.SubscribeAnswer processSubscribe(Jid from, Presence subscribeRequest) {
                if (from.equals((CharSequence)conTwo.getUser().asBareJid())) {
                    return SubscribeListener.SubscribeAnswer.Approve;
                }
                return SubscribeListener.SubscribeAnswer.Deny;
            }
        };
        rosterOne.addSubscribeListener(subscribeListener);
        final SimpleResultSyncPoint syncPoint = new SimpleResultSyncPoint();
        rosterTwo.addPresenceEventListener((PresenceEventListener)new AbstractPresenceEventListener(){

            public void presenceSubscribed(BareJid address, Presence subscribedPresence) {
                if (!address.equals((CharSequence)conOne.getUser().asBareJid())) {
                    return;
                }
                syncPoint.signal();
            }
        });
        rosterTwo.sendSubscriptionRequest(conOne.getUser().asBareJid());
        try {
            syncPoint.waitForResult(timeout);
        }
        finally {
            rosterOne.removeSubscribeListener(subscribeListener);
        }
    }
}

